/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.SplineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;

public class SplineNAlg
extends SplineAlg {
    protected IPolygon controls_;
    protected static final int MAX_LEVEL = 7;

    public SplineNAlg(IPolygon _controls) {
        this.controls_ = _controls;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public SplineNAlg() {
    }

    public IPolygon getControls() {
        return this.controls_;
    }

    public void setSpline(IPolygon controls) {
        this.controls_ = controls;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    protected int divide(int index, int size, double[] p, int level) {
        if (level < 7) {
            double[] pp = p;
            double[] np = new double[2 * size];
            System.arraycopy(p, 0, pp, 0, 2 * size);
            int i = 1;
            while (i < size) {
                np[2 * (size - i)] = pp[2 * (size - 1)];
                np[2 * (size - i) + 1] = pp[2 * (size - 1) + 1];
                int j = size - 1;
                while (j >= i) {
                    double mx = (pp[2 * (j - 1)] + pp[2 * j]) / 2.0;
                    double my = (pp[2 * (j - 1) + 1] + pp[2 * j + 1]) / 2.0;
                    pp[2 * j] = mx;
                    pp[2 * j + 1] = my;
                    --j;
                }
                ++i;
            }
            np[0] = pp[2 * (size - 1)];
            np[1] = pp[2 * (size - 1) + 1];
            index = this.divide(index, size, pp, level + 1);
            this.points_[index++] = (int)Math.round(np[0]);
            this.points_[index++] = (int)Math.round(np[1]);
            index = this.divide(index, size, np, level + 1);
        }
        return index;
    }

    public void prepareDPoints() {
        int size;
        this.num_points_ = 0;
        System.out.println("SplineNAlg controls=" + this.controls_);
        if (this.controls_ == null) {
            return;
        }
        if (this.points_ == null) {
            this.points_ = new int[258];
        }
        if ((size = this.controls_.getPolySize()) < 3) {
            this.num_points_ = 0;
            System.out.println("!!! control size<3 !!!");
            return;
        }
        if ((this.flags_ & 8) != 0) {
            if (this.points_.length < size) {
                this.points_ = new int[2 * size];
            }
            int w = 0;
            int i = 0;
            while (i < size) {
                this.points_[w++] = this.controls_.getPolyX(i);
                this.points_[w++] = this.controls_.getPolyY(i);
                ++i;
            }
            this.num_points_ = 2 * size;
        } else {
            this.points_[0] = this.controls_.getPolyX(0);
            this.points_[1] = this.controls_.getPolyY(0);
            double[] pt = new double[2 * size];
            int i = 0;
            int w = 0;
            while (i < size) {
                pt[w++] = this.controls_.getPolyX(i);
                pt[w++] = this.controls_.getPolyY(i);
                ++i;
            }
            i = this.divide(2, size, pt, 0);
            this.points_[i++] = this.controls_.getPolyX(size - 1);
            this.points_[i++] = this.controls_.getPolyY(size - 1);
            this.num_points_ = i;
        }
        this.flags_ = (byte)(this.flags_ | 2);
        System.out.println("  => num_points_=" + this.num_points_);
    }
}

