/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class FilterBrush
implements IBrush {
    protected IBrush brush_;
    protected int filter_rgba_;
    protected int gr_;
    protected int gg_;
    protected int gb_;
    protected int ga_;

    public FilterBrush(IBrush brush, int rgba_filter) {
        this.brush_ = brush;
        this.setFilter(rgba_filter);
    }

    public FilterBrush(FilterBrush b) {
        this.brush_ = b.brush_;
        this.setFilter(b.filter_rgba_);
    }

    public IBrush getBrush() {
        return this.brush_;
    }

    public void setBrush(IBrush b) {
        this.brush_ = b;
    }

    public int getFilter() {
        return this.filter_rgba_;
    }

    public void setFilter(int filter_rgba) {
        this.filter_rgba_ = filter_rgba;
        this.ga_ = this.filter_rgba_ & 0xFF;
        this.gb_ = this.filter_rgba_ >> 8 & 0xFF;
        this.gg_ = this.filter_rgba_ >> 16 & 0xFF;
        this.gr_ = this.filter_rgba_ >> 24 & 0xFF;
    }

    public IBrush copyBrush() {
        return new FilterBrush(this);
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        int rgba = this.brush_.getBrushColor(x, y, curr_rgba);
        if (this.filter_rgba_ != -1) {
            int a = rgba & 0xFF;
            int b = (rgba >>= 8) & 0xFF;
            int g = (rgba >>= 8) & 0xFF;
            int r = (rgba >>= 8) & 0xFF;
            if (this.ga_ != 255) {
                a = this.ga_ * a / 255;
            }
            if (this.gb_ != 255) {
                b = this.gb_ * b / 255;
            }
            if (this.gg_ != 255) {
                g = this.gg_ * g / 255;
            }
            if (this.gr_ != 255) {
                r = this.gr_ * r / 255;
            }
            rgba = r << 24 | g << 16 | b << 8 | a;
        }
        return RGBA.Combine(rgba, curr_rgba);
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        this.brush_.brushBegin(gc, gd);
    }

    public void brushEnd() {
        this.brush_.brushEnd();
    }
}

