/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class FilteredImageBrush
implements IBrush {
    protected IImage image_;
    protected int zx_;
    protected int zy_;
    protected boolean tile_;
    protected int filter_rgba_;
    protected IGCDirect gd_;
    protected int iw_;
    protected int ih_;
    protected int gr_;
    protected int gg_;
    protected int gb_;
    protected int ga_;

    public FilteredImageBrush(IImage image, int x, int y, int rgba_filter, boolean tile) {
        this.image_ = image;
        this.zx_ = x;
        this.zy_ = y;
        this.setFilter(rgba_filter);
        this.tile_ = tile;
    }

    public FilteredImageBrush(FilteredImageBrush b) {
        this.image_ = b.image_;
        this.zx_ = b.zx_;
        this.zy_ = b.zy_;
        this.tile_ = b.tile_;
        this.setFilter(b.filter_rgba_);
    }

    public boolean isTiled() {
        return this.tile_;
    }

    public void setTile(boolean b) {
        this.tile_ = b;
    }

    public int getX() {
        return this.zx_;
    }

    public int getY() {
        return this.zy_;
    }

    public void setOrigin(int x, int y) {
        this.zx_ = x;
        this.zy_ = y;
    }

    public int getFilter() {
        return this.filter_rgba_;
    }

    public void setFilter(int filter_rgba) {
        this.filter_rgba_ = filter_rgba;
        this.ga_ = this.filter_rgba_ & 0xFF;
        this.gb_ = this.filter_rgba_ >> 8 & 0xFF;
        this.gg_ = this.filter_rgba_ >> 16 & 0xFF;
        this.gr_ = this.filter_rgba_ >> 24 & 0xFF;
    }

    public IBrush copyBrush() {
        return new FilteredImageBrush(this);
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        int px = this.gd_.pixX(x) - this.zx_;
        int py = this.gd_.pixY(y) - this.zy_;
        if (px < 0 || py < 0 || px >= this.iw_ || py >= this.ih_) {
            if (this.tile_) {
                py %= this.ih_;
                if ((px %= this.iw_) < 0) {
                    px += this.iw_;
                }
                if (py < 0) {
                    py += this.ih_;
                }
            } else {
                return 0;
            }
        }
        int rgba_img = this.image_.getPixel(px, py);
        if (this.filter_rgba_ != -1) {
            int a = rgba_img & 0xFF;
            int b = (rgba_img >>= 8) & 0xFF;
            int g = (rgba_img >>= 8) & 0xFF;
            int r = (rgba_img >>= 8) & 0xFF;
            if (this.ga_ != 255) {
                a = this.ga_ * a / 255;
            }
            if (this.gb_ != 255) {
                b = this.gb_ * b / 255;
            }
            if (this.gg_ != 255) {
                g = this.gg_ * g / 255;
            }
            if (this.gr_ != 255) {
                r = this.gr_ * r / 255;
            }
            rgba_img = r << 24 | g << 16 | b << 8 | a;
        }
        return RGBA.Combine(rgba_img, curr_rgba);
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        this.gd_ = gd;
        this.iw_ = this.image_.getWidth();
        this.ih_ = this.image_.getHeight();
    }

    public void brushEnd() {
        this.gd_ = null;
    }
}

