/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.util.internal.IGradientGenerator;
import org.eclipse.tptp.platform.report.igc.util.internal.Point;

public class FullGradientBrush
implements IBrush {
    public static final int T_LINEAR = 0;
    public static final int T_CIRCULAR = 1;
    public static final int T_CONIC = 2;
    public static final int T_CONIC2 = 3;
    public static final int T_ELLIPTIC = 4;
    public static final int T_ELECTROMAGNETIC = 5;
    public static final int T_RECTANGULAR = 6;
    public static final int T_RECTANGULAR2 = 7;
    private int x1_;
    private int y1_;
    private int x2_;
    private int y2_;
    private boolean repeat_;
    private boolean raise_fall_;
    private int type_;
    private IGradientGenerator gradient_;
    private int c_dx_;
    private int c_dy_;
    private int c_xr_;
    private int c_yr_;
    private int c_wr_;
    private int c_hr_;
    private double c_K_;
    private double c_A_;
    int smp = 0;
    protected int sx1_;
    protected int sy1_;
    protected int sx2_;
    protected int sy2_;

    public FullGradientBrush(int _x1, int _y1, int _x2, int _y2, IGradientGenerator _gradient) {
        this.x1_ = _x1;
        this.y1_ = _y1;
        this.x2_ = _x2;
        this.y2_ = _y2;
        this.gradient_ = _gradient;
        this.type_ = 0;
        this.updateCache();
    }

    public FullGradientBrush(int _x1, int _y1, int _x2, int _y2, IGradientGenerator _gradient, int _type) {
        this.gradient_ = _gradient;
        this.x1_ = _x1;
        this.y1_ = _y1;
        this.x2_ = _x2;
        this.y2_ = _y2;
        this.type_ = _type;
        this.updateCache();
    }

    public FullGradientBrush(int _c1, int _c2, IGradientGenerator _gradient, boolean _vertical) {
        this.type_ = 0;
        this.gradient_ = _gradient;
        if (_vertical) {
            this.x2_ = 0;
            this.x1_ = 0;
            this.y1_ = _c1;
            this.y2_ = _c2;
        } else {
            this.y2_ = 0;
            this.y1_ = 0;
            this.x1_ = _c1;
            this.x2_ = _c2;
        }
    }

    public FullGradientBrush(IGradientGenerator _gradient, int _type) {
        this.gradient_ = _gradient;
        this.type_ = _type;
    }

    public FullGradientBrush(FullGradientBrush b) {
        this.gradient_ = b.gradient_;
        this.type_ = b.type_;
        this.repeat_ = b.repeat_;
        this.raise_fall_ = b.raise_fall_;
        this.setPoints(b.x1_, b.y1_, b.x2_, b.y2_);
    }

    public IBrush copyBrush() {
        return new FullGradientBrush(this);
    }

    public void setPoints(int _x1, int _y1, int _x2, int _y2) {
        this.x1_ = _x1;
        this.y1_ = _y1;
        this.x2_ = _x2;
        this.y2_ = _y2;
        this.updateCache();
    }

    public void setPoint1(int _x1, int _y1) {
        this.x1_ = _x1;
        this.y1_ = _y1;
        this.updateCache();
    }

    public void setPoint2(int _x2, int _y2) {
        this.x2_ = _x2;
        this.y2_ = _y2;
        this.updateCache();
    }

    public int getPoint1X() {
        return this.x1_;
    }

    public int getPoint2X() {
        return this.x2_;
    }

    public int getPoint1Y() {
        return this.y1_;
    }

    public int getPoint2Y() {
        return this.y2_;
    }

    public IPoint getPoint1() {
        return new Point(this.x1_, this.y1_);
    }

    public IPoint getPoint2() {
        return new Point(this.x2_, this.y2_);
    }

    public IGradientGenerator getGradientColor() {
        return this.gradient_;
    }

    public IGradientGenerator setGradientColor(IGradientGenerator _gradient) {
        IGradientGenerator g = this.gradient_;
        this.gradient_ = _gradient;
        return g;
    }

    public boolean isRepeated() {
        return this.repeat_;
    }

    public void setRepeated(boolean b) {
        this.repeat_ = b;
    }

    public boolean isRaiseFall() {
        return this.raise_fall_;
    }

    public void setRaiseFall(boolean b) {
        this.raise_fall_ = b;
    }

    public int getType() {
        return this.type_;
    }

    public void setType(int type) {
        this.type_ = type;
        this.updateCache();
    }

    private void updateCache() {
        this.c_dx_ = this.x2_ - this.x1_;
        this.c_dy_ = this.y2_ - this.y1_;
        double c_radius2 = this.c_dx_ * this.c_dx_ + this.c_dy_ * this.c_dy_;
        switch (this.type_) {
            case 0: {
                this.c_K_ = 1.0 / c_radius2;
                break;
            }
            case 1: {
                this.c_K_ = 1.0 / Math.sqrt(c_radius2);
                break;
            }
            case 2: {
                this.c_A_ = Math.atan2(this.c_dy_, this.c_dx_);
                break;
            }
            case 3: {
                this.c_A_ = Math.atan2(this.c_dy_, this.c_dx_);
                this.c_K_ = 1.0 / Math.sqrt(c_radius2);
                break;
            }
            case 4: {
                this.c_K_ = 0.5 / Math.sqrt(c_radius2);
                break;
            }
            case 5: {
                this.c_K_ = 1.0 / Math.sqrt(c_radius2);
                this.c_K_ *= this.c_K_;
                break;
            }
            case 6: 
            case 7: {
                this.c_xr_ = Math.min(this.x1_, this.x2_);
                this.c_yr_ = Math.min(this.y1_, this.y2_);
                this.c_wr_ = Math.abs(this.c_dx_);
                this.c_hr_ = Math.abs(this.c_dy_);
                this.c_K_ = (double)this.c_wr_ == 0.0 ? 0.0 : 2.0 / (double)this.c_wr_;
                this.c_A_ = (double)this.c_hr_ == 0.0 ? 0.0 : 2.0 / (double)this.c_hr_;
            }
        }
    }

    public int getBrushColor(int x, int y, int curr_clr) {
        if (this.gradient_ == null) {
            return 0;
        }
        if (this.c_dx_ == 0 && this.c_dy_ == 0) {
            return 0;
        }
        int X = x - this.x1_;
        int Y = y - this.y1_;
        double k = 0.0;
        double k1 = 0.0;
        boolean is_rectangular2 = false;
        switch (this.type_) {
            default: {
                k = (double)(X * this.c_dx_ + Y * this.c_dy_) * this.c_K_;
                break;
            }
            case 1: {
                k = Math.sqrt(X * X + Y * Y) * this.c_K_;
                break;
            }
            case 3: {
                k = k1 = Math.sqrt(X * X + Y * Y) * this.c_K_;
                if (k > 1.0 && ((int)k1 & 1) != 0) {
                    return 0;
                }
            }
            case 2: {
                double da = Math.atan2(Y, X) - this.c_A_;
                if (da < 0.0) {
                    da += Math.PI * 2;
                } else if (da > Math.PI * 2) {
                    da -= Math.PI * 2;
                }
                k = da / (Math.PI * 2);
                break;
            }
            case 4: {
                int X2 = x - this.x2_;
                int Y2 = y - this.y2_;
                double d1 = Math.sqrt(X * X + Y * Y);
                double d2 = Math.sqrt(X2 * X2 + Y2 * Y2);
                k = (d1 + d2) * this.c_K_;
                break;
            }
            case 5: {
                int X2 = x - this.x2_;
                int Y2 = y - this.y2_;
                double d1 = Math.sqrt(X * X + Y * Y);
                double d2 = Math.sqrt(X2 * X2 + Y2 * Y2);
                k = d1 * d2 * this.c_K_;
                break;
            }
            case 7: {
                is_rectangular2 = true;
            }
            case 6: {
                int s2;
                int a;
                if (this.repeat_) {
                    if (is_rectangular2) {
                        if (this.c_wr_ > 0) {
                            while (x > this.c_xr_ + this.c_wr_) {
                                x -= this.c_wr_;
                            }
                            while (x < this.c_xr_) {
                                x += this.c_wr_;
                            }
                        }
                        if (this.c_hr_ > 0) {
                            while (y > this.c_yr_ - this.c_hr_) {
                                y -= this.c_hr_;
                            }
                            while (y < this.c_yr_) {
                                y += this.c_hr_;
                            }
                        }
                        X = x - this.x1_;
                        Y = y - this.y1_;
                    }
                } else if (x < this.c_xr_ || y < this.c_yr_ || x > this.c_xr_ + this.c_wr_ || y > this.c_yr_ + this.c_hr_) {
                    return 0;
                }
                int s1 = (a = X * this.c_dy_) - Y * this.c_dx_ >= 0 ? 1 : -1;
                int n = s2 = -a - (y - this.y2_) * this.c_dx_ >= 0 ? 1 : -1;
                if (s1 != s2) {
                    int distx = Math.abs(this.c_xr_ + this.c_wr_ / 2 - x);
                    k = 1.0 - (double)distx * this.c_K_;
                    break;
                }
                int disty = Math.abs(this.c_yr_ + this.c_hr_ / 2 - y);
                k = 1.0 - (double)disty * this.c_A_;
            }
        }
        if (this.repeat_) {
            while (k > 1.0) {
                k -= 1.0;
            }
            while (k < 0.0) {
                k += 1.0;
            }
        } else if (k < 0.0 || k > 1.0) {
            return 0;
        }
        if (this.raise_fall_) {
            k = k <= 0.5 ? (k *= 2.0) : 2.0 * (1.0 - k);
        }
        return this.gradient_.getRGBA(k);
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        this.sx1_ = this.x1_;
        this.sy1_ = this.y1_;
        this.sx2_ = this.x2_;
        this.sy2_ = this.y2_;
        this.setPoints(gd.devX(this.x1_), gd.devY(this.y1_), gd.devX(this.x2_), gd.devY(this.y2_));
    }

    public void brushEnd() {
        this.setPoints(this.sx1_, this.sy1_, this.sx2_, this.sy2_);
    }
}

