/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

public class GradientBrush
implements IBrush {
    protected int rgba1_;
    protected int rgba2_;
    protected boolean vertical_;
    protected int x_;
    protected int y_;
    protected int w_;
    protected int h_;
    protected int dx_;
    protected int dy_;
    protected int dw_;
    protected int dh_;

    public GradientBrush(int _rgba1, int _rgba2, boolean _vertical) {
        this.rgba1_ = _rgba1;
        this.rgba2_ = _rgba2;
        this.vertical_ = _vertical;
    }

    public GradientBrush(GradientBrush brush) {
        this.rgba1_ = brush.rgba1_;
        this.rgba2_ = brush.rgba2_;
        this.vertical_ = brush.vertical_;
        this.x_ = brush.x_;
        this.y_ = brush.y_;
        this.w_ = brush.w_;
        this.h_ = brush.h_;
    }

    public IBrush copyBrush() {
        return new GradientBrush(this);
    }

    public int getRGBA1() {
        return this.rgba1_;
    }

    public int getRGBA2() {
        return this.rgba2_;
    }

    public boolean isVertical() {
        return this.vertical_;
    }

    public void setRGBA1(int _rgba) {
        this.rgba1_ = _rgba;
    }

    public void setRGBA2(int _rgba) {
        this.rgba2_ = _rgba;
    }

    public void setVertical(boolean _v) {
        this.vertical_ = _v;
    }

    public void setRGBA(int rgba1, int rgba2) {
        this.rgba1_ = rgba1;
        this.rgba2_ = rgba2;
    }

    public void setGradient(int rgba1, int rgba2, boolean vertical) {
        this.rgba1_ = rgba1;
        this.rgba2_ = rgba2;
        this.vertical_ = vertical;
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        double k = this.vertical_ ? (double)(y - this.dy_) / (double)this.dh_ : (double)(x - this.dx_) / (double)this.dw_;
        int grgba = RGBA.Gradient(this.rgba1_, this.rgba2_, k);
        int res = RGBA.Combine(grgba, curr_rgba);
        return res;
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        if (gd.usePixelCoordinates()) {
            this.dx_ = this.x_;
            this.dy_ = this.y_;
            this.dw_ = this.w_;
            this.dh_ = this.h_;
        } else {
            this.dx_ = gd.devX(this.x_);
            this.dy_ = gd.devY(this.y_);
            this.dw_ = gd.devX(this.w_);
            this.dh_ = gd.devY(this.h_);
        }
    }

    public void brushEnd() {
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x_ = x;
        this.y_ = y;
        this.w_ = w;
        this.h_ = h;
    }

    public void setBounds(IRect r) {
        this.x_ = r.getX();
        this.y_ = r.getY();
        this.w_ = r.getW();
        this.h_ = r.getH();
    }

    public Rect getBounds() {
        return new Rect(this.x_, this.y_, this.w_, this.h_);
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + "{rgba1=" + RGBA.Str(this.rgba1_) + ",rgba2=" + RGBA.Str(this.rgba2_) + ",vertical=" + this.vertical_ + ",x=" + this.x_ + ",y=" + this.y_ + ",w=" + this.w_ + ",h=" + this.h_ + "}";
        return s;
    }

    public void fillRectNT(IGC gc, IGCDirect gd, int _x, int _y, int _w, int _h) {
        IBrush old = gc.getBrush();
        int x = gd.devX(_x);
        int y = gd.devY(_y);
        int w = gd.devX(_w);
        int h = gd.devY(_h);
        this.brushBegin(gc, gd);
        SolidBrush b = new SolidBrush(0);
        if (this.isVertical()) {
            int X = x + w;
            int Y = y + h;
            int i = y;
            while (i <= Y) {
                int rgba = this.getBrushColor(x, i, -1);
                b.setRGBA(rgba);
                gc.setBrush(b);
                gd.drawHLineDirect(x, X, i);
                ++i;
            }
        } else {
            int X = x + w;
            int Y = y + h;
            int i = x;
            while (i <= X) {
                int rgba = this.getBrushColor(i, y, -1);
                b.setRGBA(rgba);
                gc.setBrush(b);
                gd.drawVLineDirect(i, y, Y);
                ++i;
            }
        }
        this.brushEnd();
        gc.setBrush(old);
    }

    public void fillRectWT(IGC gc, IGCDirect gd, int _x, int _y, int _w, int _h) {
        boolean opaque;
        boolean bl = opaque = RGBA.IsOpaque(this.rgba1_) && RGBA.IsOpaque(this.rgba2_);
        if (opaque) {
            this.fillRectNT(gc, gd, _x, _y, _w, _h);
            return;
        }
        int x = gd.devX(_x);
        int y = gd.devY(_y);
        int w = gd.devX(_w);
        int h = gd.devY(_h);
        this.brushBegin(gc, gd);
        int X = x + w;
        int Y = y + h;
        int j = y;
        while (j <= Y) {
            int i = x;
            while (i <= X) {
                int curr = gd.getPointDirect(i, j);
                int rgba = this.getBrushColor(i, j, curr);
                gd.drawPointDirect(i, j, rgba);
                ++i;
            }
            ++j;
        }
        this.brushEnd();
    }
}

