/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class ImageBrush
implements IBrush {
    protected IImage image_;
    protected int zx_;
    protected int zy_;
    protected boolean tile_;
    protected IGCDirect gd_;
    protected int iw_;
    protected int ih_;

    public ImageBrush(IImage image, int x, int y, boolean tile) {
        this.image_ = image;
        this.zx_ = x;
        this.zy_ = y;
        this.tile_ = tile;
    }

    public ImageBrush(ImageBrush b) {
        this.image_ = b.image_;
        this.zx_ = b.zx_;
        this.zy_ = b.zy_;
        this.tile_ = b.tile_;
    }

    public boolean isTiled() {
        return this.tile_;
    }

    public void setTile(boolean b) {
        this.tile_ = b;
    }

    public int getX() {
        return this.zx_;
    }

    public int getY() {
        return this.zy_;
    }

    public void setOrigin(int x, int y) {
        this.zx_ = x;
        this.zy_ = y;
    }

    public IBrush copyBrush() {
        return new ImageBrush(this);
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        int px = this.gd_.pixX(x) - this.zx_;
        int py = this.gd_.pixY(y) - this.zy_;
        if (px < 0 || py < 0 || px >= this.iw_ || py >= this.ih_) {
            if (this.tile_) {
                py %= this.ih_;
                if ((px %= this.iw_) < 0) {
                    px += this.iw_;
                }
                if (py < 0) {
                    py += this.ih_;
                }
            } else {
                return 0;
            }
        }
        int rgba_img = this.image_.getPixel(px, py);
        return RGBA.Combine(rgba_img, curr_rgba);
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        this.gd_ = gd;
        this.iw_ = this.image_.getWidth();
        this.ih_ = this.image_.getHeight();
    }

    public void brushEnd() {
        this.gd_ = null;
    }
}

