/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class PatternBrush
implements IBrush {
    public static final int SLASH = 0;
    public static final int SLASH2 = 1;
    protected int type_;
    protected int rgba1_;
    protected int rgba2_;
    protected int zx_;
    protected int zy_;
    private boolean[] slash_;
    private int dzx_;
    private int dzy_;
    private boolean have_rgba1_;
    private boolean have_rgba2_;

    public PatternBrush(int _type, int _rgba) {
        this.type_ = _type;
        this.rgba1_ = _rgba;
        this.rgba2_ = 0;
    }

    public PatternBrush(int _type, int _rgba1, int _rgba2) {
        this.type_ = _type;
        this.rgba1_ = _rgba1;
        this.rgba2_ = _rgba2;
    }

    public PatternBrush(PatternBrush _b) {
        this.type_ = _b.type_;
        this.rgba1_ = _b.rgba1_;
        this.rgba2_ = _b.rgba2_;
        this.zx_ = _b.zx_;
        this.zy_ = _b.zy_;
    }

    public IBrush copyBrush() {
        return new PatternBrush(this);
    }

    public int getZeroX() {
        return this.zx_;
    }

    public int getZeroY() {
        return this.zy_;
    }

    public void setZero(int x, int y) {
        this.zx_ = x;
        this.zy_ = y;
    }

    public int getRGBA1() {
        return this.rgba1_;
    }

    public int getRGBA2() {
        return this.rgba2_;
    }

    public void setRGBA1(int rgba) {
        this.rgba1_ = rgba;
    }

    public void setRGBA2(int rgba) {
        this.rgba2_ = rgba;
    }

    public void setRGBA(int rgba1, int rgba2) {
        this.rgba1_ = rgba1;
        this.rgba2_ = rgba2;
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        int dx = x - this.zx_;
        int dy = y - this.zy_;
        int i = (dx + dy) % this.slash_.length;
        if (i < 0) {
            i += this.slash_.length;
        }
        if (this.slash_[i]) {
            if (this.have_rgba1_) {
                return RGBA.Combine(this.rgba1_, curr_rgba);
            }
            return curr_rgba;
        }
        if (this.have_rgba2_) {
            return RGBA.Combine(this.rgba2_, curr_rgba);
        }
        return curr_rgba;
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        this.dzx_ = gd.devX(this.zx_);
        this.dzy_ = gd.devY(this.zy_);
        this.have_rgba1_ = !RGBA.IsInvisible(this.rgba1_);
        this.have_rgba2_ = !RGBA.IsInvisible(this.rgba2_);
        switch (this.type_) {
            case 0: {
                int l = gd.devX(10);
                if (this.slash_ != null && l == this.slash_.length) break;
                float k = 10.0f / (float)l;
                int s = Math.round(9.0f * k);
                this.slash_ = new boolean[l];
                int i = s;
                while (i < l) {
                    this.slash_[i] = true;
                    ++i;
                }
                break;
            }
            case 1: {
                int l = gd.devX(14);
                if (this.slash_ != null && l == this.slash_.length) break;
                float k = 14.0f / (float)l;
                this.slash_ = new boolean[l];
                int s = Math.round(9.0f * k);
                int e = Math.round(10.0f * k);
                int i = s;
                while (i < e) {
                    this.slash_[i] = true;
                    ++i;
                }
                i = s = Math.round(13.0f * k);
                while (i < l) {
                    this.slash_[i] = true;
                    ++i;
                }
                break;
            }
        }
    }

    public void brushEnd() {
    }
}

