/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.swt.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class ImageViewer
extends Canvas
implements PaintListener,
SelectionListener,
ControlListener,
MouseMoveListener,
MouseListener,
DisposeListener {
    private Image image_;
    private ArrayList listeners_;
    private boolean selection_enabled_ = true;
    private boolean mouse_scroll_on_button_1_enabled_;
    private boolean scrolling_on_button_1_;
    private ArrayList scroll_listeners_;
    private int msdn_x_;
    private int msdn_y_;
    private int msup_x_;
    private int msup_y_;
    private boolean scrolling_;

    public ImageViewer(Composite parent, int _flags) {
        super(parent, _flags | 0x40000 | 0x100 | 0x200);
        this.addPaintListener(this);
        this.getVerticalBar().setVisible(false);
        this.getHorizontalBar().setVisible(false);
        this.getVerticalBar().addSelectionListener((SelectionListener)this);
        this.getHorizontalBar().addSelectionListener((SelectionListener)this);
        this.addControlListener(this);
        this.addMouseMoveListener(this);
        this.addMouseListener(this);
        this.addDisposeListener(this);
        this.mouse_scroll_on_button_1_enabled_ = true;
    }

    public void ensureVisible(int x, int y, boolean centerit) {
        int s;
        int t;
        if (this.image_ == null) {
            return;
        }
        ScrollBar sbh = this.getHorizontalBar();
        ScrollBar sbv = this.getVerticalBar();
        boolean dirty = false;
        Rectangle ib = this.image_.getBounds();
        Rectangle ca = this.getClientArea();
        if (ib.width >= ca.width - sbv.getSize().x) {
            if (x < sbh.getMinimum()) {
                sbh.setSelection(sbh.getMinimum());
                dirty = true;
            } else if (x > sbh.getMaximum()) {
                sbh.setSelection(sbh.getMaximum());
                dirty = true;
            } else {
                t = sbh.getThumb();
                s = sbh.getSelection();
                if (centerit) {
                    sbh.setSelection(x - t / 2);
                    dirty = true;
                } else if (x < s + 5) {
                    sbh.setSelection(x - 5);
                    dirty = true;
                } else if (x > s + t - 5) {
                    sbh.setSelection(x - t + 5);
                    dirty = true;
                }
            }
        }
        if (ib.height >= ca.height - sbh.getSize().y) {
            if (y < sbv.getMinimum()) {
                sbv.setSelection(sbv.getMinimum());
                dirty = true;
            } else if (y > sbv.getMaximum()) {
                sbv.setSelection(sbv.getMaximum());
                dirty = true;
            } else {
                t = sbv.getThumb();
                s = sbv.getSelection();
                if (centerit) {
                    sbv.setSelection(y - t / 2);
                    dirty = true;
                } else if (y < s + 5) {
                    sbv.setSelection(y - 5);
                    dirty = true;
                } else if (y > s + t - 5) {
                    sbv.setSelection(y - t + 5);
                    dirty = true;
                }
            }
        }
        if (dirty) {
            this.fireScrolling();
            this.redraw();
        }
    }

    public void setMouseScrollOnButton1Enabled(boolean b) {
        this.mouse_scroll_on_button_1_enabled_ = b;
        if (this.scrolling_on_button_1_) {
            this.scrolling_ = false;
            this.scrolling_on_button_1_ = false;
        }
    }

    public void addScrollListener(ScrollListener l) {
        if (this.scroll_listeners_ == null) {
            this.scroll_listeners_ = new ArrayList(10);
        }
        this.scroll_listeners_.add(l);
    }

    public boolean removeScrollListener(ScrollListener l) {
        if (this.scroll_listeners_ == null) {
            return false;
        }
        return this.scroll_listeners_.remove(l);
    }

    private void fireScrolling() {
        if (this.scroll_listeners_ == null) {
            return;
        }
        Iterator I = this.scroll_listeners_.iterator();
        while (I.hasNext()) {
            ((ScrollListener)I.next()).viewerScrolled(this);
        }
    }

    private void updateScrollBars() {
        if (this.image_ == null) {
            this.getVerticalBar().setVisible(false);
            this.getHorizontalBar().setVisible(false);
        } else {
            int cv;
            boolean need_vb;
            Rectangle ca = this.getClientArea();
            Rectangle ib = this.image_.getBounds();
            ScrollBar hb = this.getHorizontalBar();
            ScrollBar vb = this.getVerticalBar();
            int hb_height = hb.getSize().y;
            int vb_width = vb.getSize().x;
            if (vb.isVisible()) {
                ca.width += vb_width;
            }
            if (hb.isVisible()) {
                ca.height += hb_height;
            }
            boolean need_hb = ib.width > ca.width;
            boolean bl = need_vb = ib.height > ca.height;
            if (need_hb && !need_vb) {
                boolean bl2 = need_vb = ib.height > ca.height - hb_height;
            }
            if (need_vb && !need_hb) {
                need_hb = ib.width > ca.width - vb_width;
            }
            hb.setVisible(need_hb);
            if (need_hb) {
                cv = hb.getSelection();
                if (cv > ib.width) {
                    cv = ib.width;
                }
                hb.setValues(cv, 0, ib.width, ca.width - (need_vb ? vb_width : 0), ca.width / 10, ca.width / 2);
            }
            vb.setVisible(need_vb);
            if (need_vb) {
                cv = vb.getSelection();
                if (cv > ib.height) {
                    cv = ib.height;
                }
                vb.setValues(cv, 0, ib.height, ca.height - (need_hb ? hb_height : 0), ca.height / 10, ca.height / 2);
            }
        }
    }

    public void setImage(Image _img) {
        this.image_ = _img;
        this.updateScrollBars();
        this.redraw();
    }

    public Image getImage() {
        return this.image_;
    }

    public void paintControl(PaintEvent e) {
        Rectangle ca = this.getClientArea();
        if (this.image_ == null) {
            e.gc.setBackground(this.getBackground());
            e.gc.fillRectangle(ca);
        } else {
            Rectangle ib = this.image_.getBounds();
            int x = this.imagePosX();
            int y = this.imagePosY();
            e.gc.setBackground(this.getBackground());
            if (y > 0) {
                e.gc.fillRectangle(0, 0, ca.width, y);
                e.gc.fillRectangle(0, y + ib.height, ca.width, ca.height - y - ib.height);
            }
            if (x > 0) {
                e.gc.fillRectangle(0, y, x, ib.height);
                e.gc.fillRectangle(x + ib.width, y, ca.width - x - ib.width, ib.height);
            }
            e.gc.drawImage(this.image_, x, y);
        }
    }

    private int imagePosX() {
        if (this.image_ == null) {
            return -1;
        }
        int x = (this.getClientArea().width - this.image_.getBounds().width) / 2;
        if (this.getHorizontalBar().isVisible()) {
            x = -this.getHorizontalBar().getSelection();
        }
        return x;
    }

    private int imagePosY() {
        if (this.image_ == null) {
            return -1;
        }
        int y = (this.getClientArea().height - this.image_.getBounds().height) / 2;
        if (this.getVerticalBar().isVisible()) {
            y = -this.getVerticalBar().getSelection();
        }
        return y;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.getVerticalBar() || e.getSource() == this.getHorizontalBar()) {
            this.redraw();
            this.fireScrolling();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.updateScrollBars();
    }

    public int imageToScreenX(int _imgx) {
        ScrollBar sb = this.getHorizontalBar();
        _imgx = sb.isVisible() ? (_imgx -= sb.getSelection()) : (_imgx += this.imagePosX());
        return _imgx;
    }

    public int screenToImageX(int _x) {
        ScrollBar sb = this.getHorizontalBar();
        _x = sb.isVisible() ? (_x += sb.getSelection()) : (_x -= this.imagePosX());
        return _x;
    }

    public int imageToScreenY(int _imgy) {
        ScrollBar sb = this.getVerticalBar();
        _imgy = sb.isVisible() ? (_imgy -= sb.getSelection()) : (_imgy += this.imagePosY());
        return _imgy;
    }

    public int screenToImageY(int _y) {
        ScrollBar sb = this.getVerticalBar();
        _y = sb.isVisible() ? (_y += sb.getSelection()) : (_y -= this.imagePosY());
        return _y;
    }

    public void mouseMove(MouseEvent e) {
        if (this.scrolling_) {
            int lx = this.screenToImageX(e.x);
            int ly = this.screenToImageY(e.y);
            int dx = this.msdn_x_ - lx;
            int dy = this.msdn_y_ - ly;
            boolean dirty = false;
            if (dx != 0 && this.getHorizontalBar().isVisible()) {
                this.getHorizontalBar().setSelection(this.getHorizontalBar().getSelection() + dx);
                dirty = true;
            }
            if (dy != 0 && this.getVerticalBar().isVisible()) {
                this.getVerticalBar().setSelection(this.getVerticalBar().getSelection() + dy);
                dirty = true;
            }
            if (dirty) {
                this.redraw();
                this.fireScrolling();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if ((e.button == 2 || e.button == 1 && !this.selection_enabled_ && this.mouse_scroll_on_button_1_enabled_) && (this.getVerticalBar().isVisible() || this.getHorizontalBar().isVisible())) {
            this.msdn_x_ = this.msup_x_ = this.screenToImageX(e.x);
            this.msdn_y_ = this.msup_y_ = this.screenToImageY(e.y);
            this.scrolling_ = true;
            this.scrolling_on_button_1_ = e.button == 1;
            this.setCursor(new Cursor((Device)this.getDisplay(), 21));
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.scrolling_) {
            this.scrolling_ = false;
            this.setCursor(null);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
    }

    public static interface ScrollListener {
        public void viewerScrolled(ImageViewer var1);
    }
}

