/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.swt.internal;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTFillGradientRectangleBrush;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTImage;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTOGCAdapter;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTSystemColor;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Oval;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Segment;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

public class SWTGC
implements IGC {
    protected Device device_;
    protected GC gc_;
    protected boolean dispose_gc_;
    protected IBrush brush_;
    protected IPen pen_;
    protected IFont font_;
    protected IGCDirect gd_;
    protected org.eclipse.swt.graphics.Font swtfont_;
    protected boolean line_style_pen_swt_compliant_;
    protected boolean brush_swt_compliant_;
    protected float KdpiX_;
    protected float KdpiY_;
    private Segment segment_;

    public SWTGC(Device device, GC gc) {
        this.device_ = device;
        this.gc_ = gc;
        this.dispose_gc_ = false;
        this.gd_ = new GCDirect();
        this.fixDPI();
        this.createPenFromGC();
        this.createBrushFromGC();
    }

    private void fixDPI() {
        if (this.device_ instanceof Display) {
            this.KdpiY_ = 1.0f;
            this.KdpiX_ = 1.0f;
        } else {
            Point dev_dpi = this.device_.getDPI();
            Point dsp_dpi = Display.getDefault().getDPI();
            this.KdpiX_ = (float)dev_dpi.x / (float)dsp_dpi.x;
            this.KdpiY_ = (float)dev_dpi.y / (float)dsp_dpi.y;
        }
    }

    public IGCDirect getIGCDirect() {
        return this.gd_;
    }

    public void dispose() {
        if (this.gc_ != null && this.dispose_gc_) {
            this.gc_.dispose();
        }
        if (this.swtfont_ != null) {
            this.swtfont_.dispose();
            this.swtfont_ = null;
        }
        this.gc_ = null;
    }

    public Color createColor(int _rgba) {
        return new Color(this.device_, RGBA.GetR(_rgba), RGBA.GetG(_rgba), RGBA.GetB(_rgba));
    }

    public int createRGBA(Color c) {
        return RGBA.Get(c.getRed(), c.getGreen(), c.getBlue());
    }

    private IBrush getBrushInternal() {
        if (this.brush_ == null) {
            Color c = this.gc_.getBackground();
            this.brush_ = new SolidBrush(RGBA.Get(c.getRed(), c.getGreen(), c.getBlue(), 255));
        }
        return this.brush_;
    }

    public IBrush getBrush() {
        return this.getBrushInternal().copyBrush();
    }

    public IBrush setBrush(IBrush _brush) {
        if (this.brush_ == null) {
            this.brush_ = this.getBrush();
        }
        if (_brush instanceof SolidBrush) {
            IBrush old = this.brush_;
            SolidBrush brush = new SolidBrush((SolidBrush)_brush);
            this.brush_ = brush;
            this.gc_.setBackground(this.createColor(brush.getRGBA()));
            this.brush_swt_compliant_ = true;
            return old;
        }
        if (_brush instanceof SWTFillGradientRectangleBrush) {
            IBrush old = this.brush_;
            SWTFillGradientRectangleBrush b = new SWTFillGradientRectangleBrush((SWTFillGradientRectangleBrush)_brush);
            this.brush_ = b;
            this.gc_.setBackground(this.createColor(b.getRGBA2()));
            this.brush_swt_compliant_ = false;
            return old;
        }
        this.brush_swt_compliant_ = this.brush_ == null;
        IBrush old = this.brush_;
        this.brush_ = _brush;
        return old;
    }

    public IPen getPen() {
        return this.getPenInternal().copyPen();
    }

    private IPen getPenInternal() {
        if (this.pen_ == null) {
            Color c = this.gc_.getBackground();
            int swtsty = this.gc_.getLineStyle();
            int sty = 0;
            switch (swtsty) {
                default: {
                    sty = 0;
                    break;
                }
                case 2: {
                    sty = 1;
                    break;
                }
                case 3: {
                    sty = 2;
                }
            }
            this.pen_ = new LineStylePen(RGBA.Get(c.getRed(), c.getGreen(), c.getBlue(), 255), sty, this.gc_.getLineWidth());
        }
        return this.pen_;
    }

    public IPen setPen(IPen _pen) {
        if (this.pen_ == null) {
            this.pen_ = this.getPen();
        }
        if (_pen instanceof LineStylePen) {
            IPen old = this.pen_;
            LineStylePen pen = new LineStylePen((LineStylePen)_pen);
            this.pen_ = pen;
            this.gc_.setForeground(this.createColor(pen.getRGBA()));
            int swtsty = 1;
            this.line_style_pen_swt_compliant_ = true;
            switch (pen.getLineStyle()) {
                case 0: {
                    swtsty = 1;
                    break;
                }
                case 1: {
                    swtsty = 2;
                    break;
                }
                case 2: {
                    swtsty = 3;
                    break;
                }
                case 3: {
                    swtsty = 4;
                    break;
                }
                case 4: {
                    swtsty = 5;
                    break;
                }
                default: {
                    this.line_style_pen_swt_compliant_ = false;
                }
            }
            if (this.line_style_pen_swt_compliant_) {
                this.gc_.setLineStyle(swtsty);
                this.gc_.setLineWidth(this.gd_.devY(pen.getLineWidth()));
            }
            return old;
        }
        this.line_style_pen_swt_compliant_ = this.pen_ == null;
        IPen old = this.pen_;
        this.pen_ = _pen;
        return old;
    }

    private void createPenFromGC() {
        LineStylePen pen = new LineStylePen();
        pen.setRGBA(this.createRGBA(this.gc_.getForeground()));
        pen.setLineWidth(this.gc_.getLineWidth());
        this.line_style_pen_swt_compliant_ = true;
        switch (this.gc_.getLineStyle()) {
            case 1: {
                pen.setLineStyle(0);
                break;
            }
            case 2: {
                pen.setLineStyle(1);
                break;
            }
            case 3: {
                pen.setLineStyle(2);
                break;
            }
            case 4: {
                pen.setLineStyle(3);
                break;
            }
            case 5: {
                pen.setLineStyle(4);
            }
        }
        this.pen_ = pen;
    }

    private void createBrushFromGC() {
        this.brush_ = new SolidBrush(this.createRGBA(this.gc_.getBackground()));
        this.brush_swt_compliant_ = true;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.line_style_pen_swt_compliant_) {
            this.gc_.drawLine(this.gd_.devX(x1), this.gd_.devY(y1), this.gd_.devX(x2), this.gd_.devY(y2));
        } else if (this.pen_ != null) {
            this.pen_.drawPath(this, this.gd_, this.getSegment(x1, y1, x2, y2));
        }
    }

    private Segment getSegment(int x1, int y1, int x2, int y2) {
        if (this.segment_ == null) {
            return new Segment(x1, y1, x2, y2);
        }
        this.segment_.setLine(x1, y1, x2, y2);
        return this.segment_;
    }

    public int getPoint(int x, int y) {
        return 0;
    }

    public void drawPoint(int x, int y) {
        this.gc_.drawPoint(this.gd_.devX(x), this.gd_.devY(y));
    }

    public void drawCircle(int cx, int cy, int radius) {
        if (this.line_style_pen_swt_compliant_) {
            int rx = this.gd_.devX(2 * radius);
            int ry = this.gd_.devY(2 * radius);
            this.gc_.drawOval(this.gd_.devX(cx - radius), this.gd_.devY(cy - radius), rx, ry);
        } else {
            SWTGC.Unsupported("drawOval() using not swt compliant pen");
        }
    }

    public void fillCircle(int cx, int cy, int radius) {
        int rx = this.gd_.devX(2 * radius);
        int ry = this.gd_.devY(2 * radius);
        this.gc_.fillOval(this.gd_.devX(cx - radius), this.gd_.devY(cy - radius), rx + 1, ry + 1);
    }

    public void drawOval(int x, int y, int w, int h) {
        if (this.line_style_pen_swt_compliant_) {
            this.gc_.drawOval(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
        } else {
            SWTGC.Unsupported("drawOval() using not swt compliant pen: " + this.pen_);
        }
    }

    public void fillOval(int x, int y, int w, int h) {
        if (this.brush_ == null || this.brush_ instanceof SolidBrush) {
            this.gc_.fillOval(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w) + 1, this.gd_.devY(h) + 1);
        } else {
            int rx = w / 2;
            int ry = h / 2;
            Oval oval = new Oval(x + rx, y + ry, rx, ry);
            oval.fillShape(this, this.gd_, this.getBrushInternal(), oval);
        }
    }

    public void drawArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            int deg_len = Radian.iR2D(_arc_length);
            if (deg_len != 0) {
                this.gc_.drawArc(this.gd_.devX(xc - r1), this.gd_.devY(yc - r2), this.gd_.devX(2 * r1), this.gd_.devY(2 * r2), Radian.iR2D(_start_angle), deg_len);
            }
            return;
        }
        SWTGC.Unsupported("drawArc with _r1_angle!=0");
    }

    public void fillArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            if (this.brush_swt_compliant_) {
                int deg_len = Radian.iR2D(_arc_length);
                if (deg_len != 0) {
                    this.gc_.fillArc(this.gd_.devX(xc - r1), this.gd_.devY(yc - r2), this.gd_.devX(2 * r1) + 1, this.gd_.devY(2 * r2) + 1, Radian.iR2D(_start_angle), deg_len);
                }
                return;
            }
            SWTGC.Unsupported("fillARc with brush " + this.brush_);
            return;
        }
        SWTGC.Unsupported("fillArc with _r1_angle!=0");
    }

    public void drawEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            this.gc_.drawOval(this.gd_.devX(xc - r1), this.gd_.devY(yc - r2), this.gd_.devX(2 * r1), this.gd_.devY(2 * r2));
            return;
        }
        SWTGC.Unsupported("drawEllipse with _r1_angle !=0 ");
    }

    public void fillEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            this.gc_.fillOval(this.gd_.devX(xc - r1), this.gd_.devY(yc - r2), this.gd_.devX(2 * r1) + 1, this.gd_.devY(2 * r2) + 1);
            return;
        }
        SWTGC.Unsupported("fillEllipse() with _r1_angle !=0 ");
    }

    public void fillRect(int x, int y, int w, int h) {
        if (this.brush_ instanceof SolidBrush) {
            this.gc_.fillRectangle(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
            return;
        }
        if (this.brush_ instanceof SWTFillGradientRectangleBrush) {
            Color fc = this.gc_.getForeground();
            SWTFillGradientRectangleBrush b = (SWTFillGradientRectangleBrush)this.brush_;
            this.gc_.setForeground(this.createColor(b.getRGBA1()));
            this.gc_.fillGradientRectangle(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h), b.isVertical());
            this.gc_.setForeground(fc);
            return;
        }
        if (this.brush_ instanceof IShapeFiller && ((IShapeFiller)((Object)this.brush_)).fillShape(this, this.gd_, this.brush_, new Rect(x, y, w, h))) {
            return;
        }
        if (this.brush_ != null) {
            Color old = this.gc_.getForeground();
            this.brush_.brushBegin(this, this.gd_);
            int dx = this.gd_.devX(x);
            int dy = this.gd_.devY(y);
            int X = dx + this.gd_.devX(w);
            int Y = dy + this.gd_.devY(h);
            int j = dy;
            while (j <= Y) {
                int i = dx;
                while (i <= X) {
                    int rgba = this.brush_.getBrushColor(i, j, 0);
                    if (rgba != 0) {
                        this.gc_.setForeground(this.createColor(rgba));
                        this.gc_.drawPoint(i, j);
                    }
                    ++i;
                }
                ++j;
            }
            this.brush_.brushEnd();
            this.gc_.setForeground(old);
        }
    }

    public void drawRect(int x, int y, int w, int h) {
        if (this.pen_ == null || this.pen_ instanceof LineStylePen) {
            this.gc_.drawRectangle(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
        } else {
            this.pen_.drawPath(this, this.gd_, new Rect(x, y, w, h));
        }
    }

    public void fillRect(IRect r) {
        this.fillRect(r.getX(), r.getY(), r.getW(), r.getH());
    }

    public void drawRect(IRect r) {
        this.drawRect(r.getX(), r.getY(), r.getW(), r.getH());
    }

    public void drawImage(IImage image, int x, int y) {
        SWTImage img;
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (image instanceof SWTImage) {
            img = (SWTImage)image;
            this.gc_.drawImage(img.getImage(), this.gd_.devX(x), this.gd_.devY(y));
            return;
        }
        if (image instanceof RGBAImage) {
            img = null;
            try {
                img = new Image(this.device_, SWTImage.ToImageData((RGBAImage)image));
                this.gc_.drawImage((Image)img, this.gd_.devX(x), this.gd_.devY(y));
            }
            finally {
                img.dispose();
            }
            return;
        }
        SWTGC.Unsupported("drawImage(int,int,IImage) where IImage isn't an instance of SWTImage");
    }

    public void drawImage(IImage image, int x, int y, int w, int h) {
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (image instanceof SWTImage) {
            SWTImage img = (SWTImage)image;
            Image swtimg = img.getImage();
            Rectangle r = swtimg.getBounds();
            this.gc_.drawImage(swtimg, 0, 0, r.width, r.height, this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
            return;
        }
        if (image instanceof RGBAImage) {
            RGBAImage rimg = (RGBAImage)image;
            Image img = null;
            try {
                img = new Image(this.device_, SWTImage.ToImageData(rimg));
                this.gc_.drawImage(img, 0, 0, rimg.getWidth(), rimg.getHeight(), this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
            }
            finally {
                img.dispose();
            }
            return;
        }
        SWTGC.Unsupported("drawImage(IImage,...) where IImage isn't an instance of SWTImage");
    }

    public void drawImage(IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH) {
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (image instanceof SWTImage) {
            SWTImage img = (SWTImage)image;
            this.gc_.drawImage(img.getImage(), srcX, srcY, srcW, srcH, this.gd_.devX(dstX), this.gd_.devY(dstY), this.gd_.devX(dstW), this.gd_.devY(dstH));
            return;
        }
        if (image instanceof RGBAImage) {
            RGBAImage rimg = (RGBAImage)image;
            Image img = null;
            try {
                img = new Image(this.device_, SWTImage.ToImageData(rimg));
                this.gc_.drawImage(img, srcX, srcY, srcW, srcH, this.gd_.devX(dstX), this.gd_.devY(dstY), this.gd_.devX(dstW), this.gd_.devY(dstH));
            }
            finally {
                img.dispose();
            }
            return;
        }
        SWTGC.Unsupported("drawImage(IImage,...) where IImage isn't an instance of SWTImage");
    }

    public void drawPoly(IPolygon poly) {
        if (this.pen_ == null || this.pen_ instanceof LineStylePen) {
            Polygon p = null;
            p = poly instanceof Polygon ? (Polygon)poly : new Polygon(poly);
            if (this.gd_.usePixelCoordinates()) {
                this.gc_.drawPolyline(p.getPoints());
            } else {
                int[] xy = p.getPoints();
                int s = xy.length;
                int[] devxy = new int[s];
                int i = 0;
                while (i < s) {
                    devxy[i] = this.gd_.devX(xy[i]);
                    devxy[++i] = this.gd_.devY(xy[i]);
                    ++i;
                }
                this.gc_.drawPolyline(devxy);
            }
            return;
        }
        if (poly instanceof IPath) {
            this.pen_.drawPath(this, this.gd_, (IPath)((Object)poly));
            return;
        }
        SWTGC.Unsupported("drawPoly() with pen=" + this.pen_);
    }

    public void fillPoly(IPolygon poly) {
        if (this.brush_swt_compliant_) {
            Polygon p = null;
            p = poly instanceof Polygon ? (Polygon)poly : new Polygon(poly);
            if (this.gd_.usePixelCoordinates()) {
                this.gc_.fillPolygon(p.getPoints());
            } else {
                int[] xy = p.getPoints();
                int s = xy.length;
                int[] devxy = new int[s];
                int i = 0;
                i = 0;
                while (i < s) {
                    devxy[i] = this.gd_.devX(xy[i]);
                    devxy[++i] = this.gd_.devY(xy[i]);
                    ++i;
                }
                this.gc_.fillPolygon(devxy);
            }
            return;
        }
        if (poly instanceof IShape) {
            if (this.brush_ instanceof IShapeFiller && ((IShapeFiller)((Object)this.brush_)).fillShape(this, this.gd_, this.brush_, poly)) {
                return;
            }
            if (poly instanceof IShapeFiller && ((IShapeFiller)((Object)poly)).fillShape(this, this.gd_, this.brush_, poly)) {
                return;
            }
        }
        SWTGC.Unsupported("fillPoly() with brush=" + this.brush_);
    }

    public ISize textExtent(String text) {
        Point te = this.gc_.textExtent(text);
        return new Size(this.gd_.pixX(te.x), this.gd_.pixY(te.y));
    }

    public ISize textExtent(String text, double _angle) {
        double a = Radian.normalize(_angle);
        if (a == 0.0 || a == Math.PI) {
            Point te = this.gc_.textExtent(text);
            return new Size(this.gd_.pixX(te.x), this.gd_.pixY(te.y));
        }
        if (a == 1.5707963267948966 || a == 4.71238898038469) {
            Point te = this.gc_.textExtent(text);
            return new Size(this.gd_.pixX(te.y), this.gd_.pixY(te.x));
        }
        SWTGC.Unsupported("textExtent(String,int): angle other than 0,90,180,270? aren't supported");
        return null;
    }

    public IPolygon textExtent(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        ISize size = this.textExtent(text);
        return RGBAImage.rotateImageBounds(x, y, size.getW(), size.getH(), a);
    }

    public void drawText(String text, int x, int y) {
        if (this.brush_ instanceof SolidBrush) {
            Color c = this.gc_.getForeground();
            this.gc_.setForeground(this.createColor(((SolidBrush)this.brush_).getRGBA()));
            int dtx = this.gd_.devX(x);
            int dty = this.gd_.devY(y);
            this.gc_.drawText(text, dtx, dty, true);
            if (this.font_ != null) {
                SWTOGCAdapter.DrawFontLineStyle(this.gc_, dtx, dty, this.gc_.textExtent((String)text).x, this.font_.getFontStyle(), this.gd_.devX(5));
            }
            this.gc_.setForeground(c);
        } else {
            SWTGC.Unsupported("drawText() without SolidBrush");
        }
    }

    public void drawText(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        if (this.brush_swt_compliant_ && (a == 0.0 || a == 1.5707963267948966 || a == Math.PI || a == 4.71238898038469)) {
            this.rotatedDrawText(text, x, y, Radian.iR2D(a));
            return;
        }
        int tx = this.gd_.devX(x);
        int ty = this.gd_.devY(y);
        RGB bg = new RGB(0, 0, 0);
        ISize size = this.textExtent(text);
        RGBAImage s = SWTImage.ToRGBAImage(this.getTextImage(text, new Color(null, 0, 0, 0), bg));
        RGBAImage r = s.rotateImage(a, -1, true);
        Polygon rte = RGBAImage.rotateImageBounds(tx, ty, size.getW(), size.getH(), a);
        IRect rb = rte.getBounds();
        this.drawTextImage(r, tx + rb.getX() - rte.getPolyX(0), ty + rb.getY() - rte.getPolyY(0), true);
    }

    protected void drawTextImage(RGBAImage data, int devx, int devy, boolean transparent) {
        int white = -1;
        int black = 255;
        int brush_rgba = 255;
        boolean solid_brush = this.brush_ instanceof SolidBrush;
        if (solid_brush) {
            brush_rgba = ((SolidBrush)this.brush_).getRGBA();
        }
        int brush_alpha = brush_rgba & 0xFF;
        Color c_brush_rgba = this.createColor(brush_rgba);
        Color saved = this.gc_.getForeground();
        this.brush_.brushBegin(this, this.gd_);
        int Y = devy;
        int height = data.getHeight();
        int width = data.getWidth();
        int[] image = data.getImage();
        int ir0 = 0;
        int iy = 0;
        while (iy < height) {
            if (Y >= 0) {
                int X = devx;
                int ix = 0;
                int ir = ir0;
                while (ix < width) {
                    if (X >= 0) {
                        int rgba = image[ir];
                        if (rgba == black) {
                            if (solid_brush) {
                                this.gc_.setForeground(c_brush_rgba);
                                this.gc_.drawPoint(X, Y);
                            } else {
                                this.gc_.setForeground(this.createColor(this.brush_.getBrushColor(X, Y, 0)));
                                this.gc_.drawPoint(X, Y);
                            }
                        } else if (rgba != white) {
                            int alpha = 255 - RGBA.GetB(rgba);
                            if (solid_brush) {
                                if ((alpha = alpha * brush_alpha / 255) > 85) {
                                    this.gc_.setForeground(c_brush_rgba);
                                    this.gc_.drawPoint(X, Y);
                                }
                            } else {
                                int brgba = this.brush_.getBrushColor(X, Y, 0);
                                if ((alpha = alpha * (brgba & 0xFF) / 255) > 85) {
                                    this.gc_.setForeground(this.createColor(brgba | 0xFF));
                                    this.gc_.drawPoint(X, Y);
                                }
                            }
                        }
                    }
                    ++ix;
                    ++X;
                    ++ir;
                }
            }
            ++iy;
            ++Y;
            ir0 += width;
        }
        this.brush_.brushEnd();
        this.gc_.setForeground(saved);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.gc_.drawFocus(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
    }

    public void drawFocus(IRect rect) {
        this.gc_.drawFocus(this.gd_.devX(rect.getX()), this.gd_.devX(rect.getY()), this.gd_.devX(rect.getW()), this.gd_.devX(rect.getH()));
    }

    public IFont getFont() {
        if (this.font_ == null) {
            org.eclipse.swt.graphics.Font sf = this.gc_.getFont();
            if (sf == null) {
                return null;
            }
            FontData fd = sf.getFontData()[0];
            if (fd == null) {
                return null;
            }
            int swtsty = fd.getStyle();
            int sty = 0;
            if ((swtsty & 1) != 0) {
                sty |= 1;
            }
            if ((swtsty & 2) != 0) {
                sty |= 2;
            }
            this.font_ = new Font(fd.getLocale(), fd.getName(), fd.getHeight(), sty);
        }
        return this.font_;
    }

    public IFont setFont(IFont font) {
        IFont old = this.getFont();
        if (this.swtfont_ != null) {
            this.swtfont_.dispose();
            this.swtfont_ = null;
        }
        if (font != null) {
            int sty = font.getFontStyle();
            int swtsty = 0;
            if ((sty & 1) != 0) {
                swtsty |= 1;
            }
            if ((sty & 2) != 0) {
                swtsty |= 2;
            }
            int size = font.getFontSize();
            this.swtfont_ = new org.eclipse.swt.graphics.Font(this.device_, font.getFontName(), size, swtsty);
        }
        this.font_ = font;
        this.gc_.setFont(this.swtfont_);
        return old;
    }

    public IFontMetrics getFontMetrics() {
        final FontMetrics fm = this.gc_.getFontMetrics();
        return new IFontMetrics(){

            public int getAscent() {
                return SWTGC.this.gd_.pixY(fm.getAscent());
            }

            public int getDescent() {
                return SWTGC.this.gd_.pixY(fm.getDescent());
            }

            public int getHeight() {
                return SWTGC.this.gd_.pixY(fm.getHeight());
            }

            public int getLeading() {
                return SWTGC.this.gd_.pixY(fm.getLeading());
            }
        };
    }

    public IShape getClipping() {
        Rectangle r = this.gc_.getClipping();
        if (r == null) {
            return null;
        }
        return new Rect(this.gd_.pixX(r.x), this.gd_.pixY(r.y), this.gd_.pixX(r.width), this.gd_.pixY(r.height));
    }

    public IShape setClipping(IShape s) {
        if (s instanceof IRect) {
            IShape old = this.getClipping();
            IRect r = (IRect)s;
            this.gc_.setClipping(this.gd_.devX(r.getX()), this.gd_.devY(r.getY()), this.gd_.devX(r.getW()), this.gd_.devY(r.getH()));
            return old;
        }
        if (s == null) {
            this.gc_.setClipping(null);
        }
        return null;
    }

    public void fillShape(IShape shape) {
        if (shape instanceof IRect) {
            this.fillRect((IRect)shape);
            return;
        }
        if (shape instanceof Oval) {
            Oval o = (Oval)shape;
            int cx = o.getCenterX();
            int cy = o.getCenterY();
            int rx = o.getRadiusX();
            int ry = o.getRadiusY();
            this.fillOval(cx - rx, cy - ry, 2 * rx, 2 * ry);
            return;
        }
        if (shape instanceof IPolygon) {
            this.fillPoly((IPolygon)shape);
            return;
        }
        if (this.brush_ instanceof IShapeFiller && ((IShapeFiller)((Object)this.brush_)).fillShape(this, this.gd_, this.brush_, shape)) {
            return;
        }
        if (shape instanceof IShapeFiller && ((IShapeFiller)((Object)shape)).fillShape(this, this.gd_, this.getBrushInternal(), shape)) {
            return;
        }
        SWTGC.Unsupported("fillShape() for shape=" + shape + " and brush=" + this.brush_);
    }

    public void drawPath(IPath path) {
        if (path instanceof IPolygon) {
            this.drawPoly((IPolygon)((Object)path));
        } else {
            this.pen_.drawPath(this, this.gd_, path);
        }
    }

    protected static void Unsupported(String what) {
        System.err.println("SWTGC: Unsupported method: " + what);
    }

    private ImageData getTextImage(String text, Color txt_clr, RGB bg) {
        Point sz = this.gc_.textExtent(text);
        ImageData data = null;
        Image img = null;
        GC igc = null;
        try {
            img = new Image(this.device_, sz.x, sz.y);
            igc = new GC((Drawable)img);
            igc.setForeground(txt_clr);
            RGB rgb = txt_clr.getRGB();
            bg.red = 255 - rgb.red;
            bg.green = 255 - rgb.green;
            bg.blue = 255 - rgb.blue;
            Color cbg = new Color(this.device_, bg);
            igc.setBackground(cbg);
            igc.fillRectangle(0, 0, sz.x, sz.y);
            data = img.getImageData();
            rgb = data.palette.getRGB(data.getPixel(0, 0));
            bg.red = rgb.red;
            bg.green = rgb.green;
            bg.blue = rgb.blue;
            FontData fontdata = this.gc_.getFont().getFontData()[0];
            org.eclipse.swt.graphics.Font font = new org.eclipse.swt.graphics.Font(this.device_, fontdata);
            igc.setFont(font);
            igc.drawText(text, 0, 0, true);
            if (this.font_ != null) {
                SWTOGCAdapter.DrawFontLineStyle(igc, 0, 0, sz.x, this.font_.getFontStyle(), this.gd_.devX(5));
            }
            font.dispose();
            igc.dispose();
            data = img.getImageData();
        }
        finally {
            if (img != null) {
                img.dispose();
            }
            if (igc != null) {
                igc.dispose();
            }
        }
        return data;
    }

    protected void rotatedDrawText(String text, int tx, int ty, int angle) {
        Color txt_clr = this.gc_.getBackground();
        tx = this.gd_.devX(tx);
        ty = this.gd_.devY(ty);
        switch (angle % 360) {
            case 270: {
                RGB bg = new RGB(0, 0, 0);
                ImageData s = this.getTextImage(text, txt_clr, bg);
                int dx = tx;
                int sy = 0;
                while (sy < s.height) {
                    int dy = ty;
                    int sx = 0;
                    while (sx < s.width) {
                        int pixel = s.getPixel(sx, sy);
                        RGB rgb = s.palette.getRGB(pixel);
                        if (rgb.red != bg.red || rgb.green != bg.green || rgb.blue != bg.blue) {
                            this.gc_.setForeground(new Color(this.device_, rgb));
                            this.gc_.drawPoint(dx, dy);
                        }
                        ++sx;
                        ++dy;
                    }
                    ++sy;
                    --dx;
                }
                break;
            }
            case 90: {
                RGB bg = new RGB(0, 0, 0);
                ImageData s = this.getTextImage(text, txt_clr, bg);
                int dx = tx;
                int sy = 0;
                while (sy < s.height) {
                    int dy = ty;
                    int sx = 0;
                    while (sx < s.width) {
                        int pixel = s.getPixel(sx, sy);
                        RGB rgb = s.palette.getRGB(pixel);
                        if (rgb.red != bg.red || rgb.green != bg.green || rgb.blue != bg.blue) {
                            this.gc_.setForeground(new Color(this.device_, rgb));
                            this.gc_.drawPoint(dx, dy);
                        }
                        ++sx;
                        --dy;
                    }
                    ++sy;
                    ++dx;
                }
                break;
            }
            case 180: {
                RGB bg = new RGB(0, 0, 0);
                ImageData s = this.getTextImage(text, txt_clr, bg);
                int dy = ty;
                int sy = 0;
                while (sy < s.height) {
                    int dx = tx;
                    int sx = 0;
                    while (sx < s.width) {
                        int pixel = s.getPixel(sx, sy);
                        RGB rgb = s.palette.getRGB(pixel);
                        if (rgb.red != bg.red || rgb.green != bg.green || rgb.blue != bg.blue) {
                            this.gc_.setForeground(new Color(this.device_, rgb));
                            this.gc_.drawPoint(dx, dy);
                        }
                        ++sx;
                        --dx;
                    }
                    ++sy;
                    --dy;
                }
                break;
            }
            case 0: {
                Color c = this.gc_.getForeground();
                this.gc_.setForeground(txt_clr);
                this.gc_.drawText(text, tx, ty, true);
                if (this.font_ != null) {
                    SWTOGCAdapter.DrawFontLineStyle(this.gc_, tx, ty, this.gc_.textExtent((String)text).x, this.font_.getFontStyle(), this.gd_.devX(5));
                }
                this.gc_.setForeground(c);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported angle " + angle + "?");
            }
        }
    }

    public int getSystemColor(int id) {
        return SWTSystemColor.GetSystemColor(this.device_, id);
    }

    private class GCDirect
    implements IGCDirect {
        private GCDirect() {
        }

        public IGC getIGC() {
            return SWTGC.this;
        }

        public boolean usePixelCoordinates() {
            return SWTGC.this.KdpiX_ == 1.0f && SWTGC.this.KdpiY_ == 1.0f;
        }

        public int devX(int x) {
            return (int)(SWTGC.this.KdpiX_ * (float)x);
        }

        public int devY(int y) {
            return (int)(SWTGC.this.KdpiY_ * (float)y);
        }

        public int pixX(int x) {
            return (int)((float)x / SWTGC.this.KdpiX_);
        }

        public int pixY(int y) {
            return (int)((float)y / SWTGC.this.KdpiY_);
        }

        public void drawPointDirect(int x, int y, int _rgba) {
            boolean chg;
            Color c = SWTGC.this.gc_.getForeground();
            int crgba = RGBA.Get(c.getRed(), c.getGreen(), c.getBlue());
            boolean bl = chg = _rgba != crgba;
            if (chg) {
                SWTGC.this.gc_.setForeground(SWTGC.this.createColor(_rgba));
                SWTGC.this.gc_.drawPoint(x, y);
                SWTGC.this.gc_.setForeground(c);
            } else {
                SWTGC.this.gc_.drawPoint(x, y);
            }
        }

        public int getPointDirect(int x, int y) {
            return 0;
        }

        public void drawHLineDirect(int x1, int x2, int y) {
            if (SWTGC.this.brush_swt_compliant_) {
                SWTGC.this.gc_.drawLine(x1, y, x2, y);
            } else if (SWTGC.this.brush_ != null) {
                Color c = SWTGC.this.gc_.getForeground();
                int x = x1;
                while (x <= x2) {
                    int rgba = SWTGC.this.brush_.getBrushColor(x, y, 0);
                    if (rgba != 0) {
                        SWTGC.this.gc_.setForeground(SWTGC.this.createColor(rgba));
                        SWTGC.this.gc_.drawPoint(x, y);
                    }
                    ++x;
                }
                SWTGC.this.gc_.setForeground(c);
            } else {
                SWTGC.Unsupported("drawHLineDirect() without brush.");
            }
        }

        public void drawVLineDirect(int x, int y1, int y2) {
            if (SWTGC.this.brush_swt_compliant_) {
                SWTGC.this.gc_.drawLine(x, y1, x, y2);
            } else if (SWTGC.this.brush_ != null) {
                Color c = SWTGC.this.gc_.getForeground();
                int y = y1;
                while (y <= y2) {
                    int rgba = SWTGC.this.brush_.getBrushColor(x, y, 0);
                    SWTGC.this.gc_.setForeground(SWTGC.this.createColor(rgba));
                    SWTGC.this.gc_.drawPoint(x, y);
                    ++x;
                }
                SWTGC.this.gc_.setForeground(c);
            } else {
                SWTGC.Unsupported("drawVLineDirect() without brush.");
            }
        }

        public void fillRectDirect(int x, int y, int w, int h) {
            if (SWTGC.this.brush_ instanceof SolidBrush) {
                Color c = SWTGC.this.gc_.getBackground();
                SWTGC.this.gc_.setBackground(SWTGC.this.createColor(((SolidBrush)SWTGC.this.brush_).getRGBA()));
                SWTGC.this.gc_.fillRectangle(x, y, w, h);
                SWTGC.this.gc_.setBackground(c);
            } else if (SWTGC.this.brush_ instanceof SWTFillGradientRectangleBrush) {
                Color fc = SWTGC.this.gc_.getForeground();
                Color bg = SWTGC.this.gc_.getBackground();
                SWTFillGradientRectangleBrush b = (SWTFillGradientRectangleBrush)SWTGC.this.brush_;
                SWTGC.this.gc_.setForeground(SWTGC.this.createColor(b.getRGBA1()));
                SWTGC.this.gc_.setBackground(SWTGC.this.createColor(b.getRGBA2()));
                SWTGC.this.gc_.fillGradientRectangle(SWTGC.this.gd_.devX(x), SWTGC.this.gd_.devY(y), SWTGC.this.gd_.devX(w), SWTGC.this.gd_.devY(h), b.isVertical());
                SWTGC.this.gc_.setForeground(fc);
                SWTGC.this.gc_.setBackground(bg);
            } else {
                SWTGC.Unsupported("fillRectDirect() with brush = " + SWTGC.this.brush_);
            }
        }

        public void drawRectDirect(int x, int y, int w, int h) {
            SWTGC.this.brush_.brushBegin(SWTGC.this, this);
            int x2 = x + w - 1;
            int y2 = y + h - 1;
            this.drawHLineDirect(x, x2, y);
            this.drawHLineDirect(x, x2, y2);
            this.drawVLineDirect(x, ++y, --y2);
            this.drawVLineDirect(x2, y, y2);
            SWTGC.this.brush_.brushEnd();
        }

        public void drawLineDirect(int x1, int y1, int x2, int y2) {
            if (SWTGC.this.brush_swt_compliant_) {
                Color c = SWTGC.this.gc_.getForeground();
                SWTGC.this.gc_.setForeground(SWTGC.this.gc_.getBackground());
                SWTGC.this.gc_.drawLine(x1, y1, x2, y2);
                SWTGC.this.gc_.setForeground(c);
            } else if (SWTGC.this.brush_ != null) {
                LineAlg line = new LineAlg(x1, y1, x2, y2);
                Color c = SWTGC.this.gc_.getForeground();
                SWTGC.this.gc_.setForeground(SWTGC.this.gc_.getBackground());
                int last_rgba = 0;
                boolean first = true;
                while (line.nextPoint(null)) {
                    int x = line.getX();
                    int y = line.getY();
                    int rgba = SWTGC.this.brush_.getBrushColor(x, y, 0);
                    if (first || last_rgba != rgba) {
                        SWTGC.this.gc_.setForeground(SWTGC.this.createColor(rgba));
                        first = false;
                        last_rgba = rgba;
                    }
                    SWTGC.this.gc_.drawPoint(x, y);
                }
                SWTGC.this.gc_.setForeground(c);
                SWTGC.this.pen_.drawPath(SWTGC.this, SWTGC.this.gd_, SWTGC.this.getSegment(x1, y1, x2, y2));
            } else {
                SWTGC.Unsupported("drawLineDirect() without brush ");
            }
        }
    }
}

