/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.CircleAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.OvalAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.IVector;
import org.eclipse.tptp.platform.report.igc.util.internal.Oval;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Vector;

public class Circle
implements IPath,
IPathElement,
IShape,
IShapeFiller {
    protected int cx_;
    protected int cy_;
    protected int radius_;
    protected double arc_start_;
    protected double arc_length_;
    protected boolean path_element_is_circle_;
    protected boolean path_element_returned_;
    protected CircleAlg path_alg_;
    protected int curr_index_;
    protected int curr_octant_;
    protected Vector vector_ = new Vector();
    protected boolean finished_;

    public Circle() {
        this.setCircle(0, 0, 0);
    }

    public Circle(int cx, int cy, int radius) {
        this.setCircle(cx, cy, radius);
    }

    public Circle(int cx, int cy, int radius, double arc_start, double arc_length) {
        this.setArc(cx, cy, radius, arc_start, arc_length);
    }

    public Circle(Circle c) {
        this.setCircle(c);
    }

    public void setCircle(int cx, int cy, int radius) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.radius_ = radius;
        this.arc_start_ = 0.0;
        this.arc_length_ = Math.PI * 2;
    }

    public void setArc(int cx, int cy, int radius, double arc_start, double arc_length) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.radius_ = radius;
        this.arc_start_ = Radian.normalize(arc_start);
        this.arc_length_ = arc_length;
    }

    public void setCircle(Circle c) {
        this.cx_ = c.cx_;
        this.cy_ = c.cy_;
        this.arc_start_ = c.arc_start_;
        this.arc_length_ = c.arc_length_;
        this.radius_ = c.radius_;
    }

    public int getCenterX() {
        return this.cx_;
    }

    public int getCenterY() {
        return this.cy_;
    }

    public int getRadius() {
        return this.radius_;
    }

    public double getArcStart() {
        return this.arc_start_;
    }

    public double getArcLength() {
        return this.arc_length_;
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.path_element_is_circle_ = gd.usePixelCoordinates() || gd.devX(this.radius_) == gd.devY(this.radius_);
        return true;
    }

    public void pathEnd() {
        this.path_element_returned_ = false;
    }

    public IPathElement nextPathElement() {
        if (this.path_element_returned_) {
            return null;
        }
        this.path_element_returned_ = true;
        if (this.path_element_is_circle_) {
            return this;
        }
        return new Oval(this.cx_, this.cy_, this.radius_, this.radius_, this.arc_start_, this.arc_length_);
    }

    public IPathElement copyPathElement() {
        return new Circle(this);
    }

    public boolean pathElementBegin(IGC gc, IGCDirect gd) {
        this.path_alg_ = new CircleAlg(this.cx_, this.cy_, this.radius_, this.arc_start_, this.arc_length_);
        this.path_alg_.restart();
        return !this.finished_;
    }

    public void pathElementEnd() {
        this.path_alg_ = null;
    }

    public boolean nextPoint(IPoint point) {
        return this.path_alg_.nextPoint(point);
    }

    public void backTangent(IVector vector) {
        this.path_alg_.getCurrentTangent(vector);
    }

    public void frontTangent(IVector vector) {
        this.path_alg_.getCurrentTangent(vector);
    }

    public IShape copyShape() {
        return new Circle(this);
    }

    public boolean contains(int x, int y) {
        return CircleAlg.Contains(x, y, this.cx_, this.cy_, this.radius_, this.arc_start_, this.arc_length_);
    }

    public boolean contains(IPoint p) {
        return CircleAlg.Contains(p.getX(), p.getY(), this.cx_, this.cy_, this.radius_, this.arc_start_, this.arc_length_);
    }

    public IRect getBounds() {
        int r = this.radius_ < 0 ? -this.radius_ : this.radius_;
        int r2 = r << 1;
        return new Rect(this.cx_ - r, this.cy_ - r, r2, r2);
    }

    public boolean fillShape(IGC gc, IGCDirect gd, IBrush brush, IShape shape) {
        if (shape != this) {
            return false;
        }
        int drx = gd.devX(this.radius_);
        int dry = gd.devY(this.radius_);
        if (this.arc_length_ >= Math.PI * 2 || this.arc_length_ <= Math.PI * -2) {
            if (drx == dry) {
                CircleAlg.FillCircle(gd, this.cx_, this.cy_, drx);
            } else {
                OvalAlg.FillOval(gd, this.cx_, this.cy_, drx, dry);
            }
        } else if (drx == dry) {
            CircleAlg.FillArc(gd, this.cx_, this.cy_, this.radius_, this.arc_start_, this.arc_length_);
        } else {
            OvalAlg.FillArc(gd, this.cx_, this.cy_, drx, dry, this.arc_start_, this.arc_length_);
        }
        return true;
    }

    public boolean contains(IRect r) {
        int y;
        int x = r.getX();
        if (!this.contains(x, y = r.getY())) {
            return false;
        }
        int xr = x + r.getW() - 1;
        if (!this.contains(xr, y)) {
            return false;
        }
        int yb = y + r.getH() - 1;
        return this.contains(x, yb) && this.contains(xr, yb);
    }

    public boolean contains(Circle c) {
        if (!this.contains(c.cx_, c.cy_)) {
            return false;
        }
        int dx = c.cx_ - this.cx_;
        int dy = c.cy_ - this.cy_;
        long r02 = dx * dx + dy * dy;
        long rc2 = c.radius_ * c.radius_;
        long r2 = this.radius_ * this.radius_;
        return r02 + rc2 <= r2;
    }
}

