/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.EllipseAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.IVector;

public class Ellipse
implements IShape,
IShapeFiller,
IPath,
IPathElement {
    protected EllipseAlg def_;
    EllipseAlg dev_def_;
    protected boolean give_path_element_;

    private Ellipse() {
    }

    public Ellipse(int cx, int cy, double rx_angle, int rx, int ry, double start_angle, double arc_length) {
        this.setArc(cx, cy, rx_angle, rx, ry, start_angle, arc_length);
    }

    public Ellipse(int cx, int cy, double rx_angle, int rx, int ry) {
        this.setEllipse(cx, cy, rx_angle, rx, ry);
    }

    public Ellipse(int cx, int cy, int rx, int ry) {
        this.setEllipse(cx, cy, rx, ry);
    }

    public Ellipse(Ellipse e) {
        this.setEllipse(e);
    }

    public void setEllipse(int cx, int cy, int rx, int ry) {
        if (this.def_ == null) {
            this.def_ = new EllipseAlg(cx, cy, 0.0, rx, ry);
        } else {
            this.def_.setEllipse(cx, cy, 0.0, rx, ry);
        }
    }

    public void setEllipse(int cx, int cy, double rx_angle, int rx, int ry) {
        if (this.def_ == null) {
            this.def_ = new EllipseAlg(cx, cy, rx_angle, rx, ry);
        } else {
            this.def_.setEllipse(cx, cy, rx_angle, rx, ry);
        }
    }

    public void setArc(int cx, int cy, double rx_angle, int rx, int ry, double start_angle, double arc_length) {
        if (this.def_ == null) {
            this.def_ = new EllipseAlg(cx, cy, rx_angle, rx, ry, start_angle, arc_length);
        } else {
            this.def_.setArc(cx, cy, rx_angle, rx, ry, start_angle, arc_length);
        }
    }

    public void setEllipse(Ellipse e) {
        if (this.def_ == null) {
            this.def_ = new EllipseAlg(e.def_);
        } else {
            this.def_.setEllipse(e.def_);
        }
    }

    public IShape copyShape() {
        return new Ellipse(this);
    }

    public boolean contains(int x, int y) {
        return this.def_.contains(x, y);
    }

    public boolean contains(IPoint p) {
        return this.contains(p.getX(), p.getY());
    }

    public IRect getBounds() {
        return this.def_.getBounds();
    }

    public boolean fillShape(IGC gc, IGCDirect gd, IBrush brush, IShape shape) {
        if (!(shape instanceof Ellipse)) {
            return false;
        }
        if (brush != null) {
            brush.brushBegin(gc, gd);
        }
        this.setupEllipseData(gd);
        this.dev_def_.fill(gd);
        if (brush != null) {
            brush.brushEnd();
        }
        return true;
    }

    private void setupEllipseData(IGCDirect gd) {
        if (gd.usePixelCoordinates()) {
            this.dev_def_ = this.def_;
        } else {
            int dcx = gd.devX(this.def_.getCenterX());
            int dcy = gd.devY(this.def_.getCenterY());
            int drx = gd.devX(this.def_.getRadiusX());
            int dry = gd.devY(this.def_.getRadiusY());
            if (this.dev_def_ == null || this.dev_def_ == this.def_) {
                this.dev_def_ = new EllipseAlg(dcx, dcy, this.def_.getAngle(), drx, dry, this.def_.getArcStart(), this.def_.getArcLength());
            } else {
                this.dev_def_.setArc(dcx, dcy, this.def_.getAngle(), drx, dry, this.def_.getArcStart(), this.def_.getArcLength());
            }
        }
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.give_path_element_ = true;
        return true;
    }

    public void pathEnd() {
        this.give_path_element_ = false;
    }

    public IPathElement nextPathElement() {
        if (this.give_path_element_) {
            this.give_path_element_ = false;
            return this;
        }
        return null;
    }

    public IPathElement copyPathElement() {
        Ellipse e = new Ellipse();
        e.def_ = e.dev_def_ = this.dev_def_;
        return e;
    }

    public boolean pathElementBegin(IGC gc, IGCDirect gd) {
        this.setupEllipseData(gd);
        return true;
    }

    public void pathElementEnd() {
    }

    public boolean nextPoint(IPoint point) {
        return this.dev_def_.nextPoint(point);
    }

    public void backTangent(IVector vector) {
        throw new UnsupportedOperationException("backTangent() in Ellipse");
    }

    public void frontTangent(IVector vector) {
        throw new UnsupportedOperationException("backTangent() in Ellipse");
    }
}

