/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.util.internal.IGradientGenerator;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class GradientGenerator
implements IGradientGenerator {
    private int[] rgba_;
    private double[] k_;

    public GradientGenerator() {
    }

    public GradientGenerator(int _rgba0, int _rgba1) {
        this.setGradient(_rgba0, _rgba1);
    }

    public GradientGenerator(int _rgba0, int _rgbaM, int _rgba1) {
        this.setGradient(_rgba0, _rgbaM, _rgba1);
    }

    public GradientGenerator(double[] _k, int[] _rgba) {
        this.setGradient(_k, _rgba);
    }

    public GradientGenerator(GradientGenerator _gradient) {
        this.setGradient(_gradient);
    }

    public GradientGenerator(int[] _rgba) {
        this.setGradient(_rgba);
    }

    public void reset() {
        this.rgba_ = null;
        this.k_ = null;
    }

    public void setGradient(int _rgba0, int _rgba1) {
        this.rgba_ = new int[]{_rgba0, _rgba1};
        this.k_ = new double[]{0.0, 1.0};
    }

    public void setGradient(int _rgba0, int _rgbaM, int _rgba1) {
        this.rgba_ = new int[]{_rgba0, _rgbaM, _rgba1};
        this.k_ = new double[]{0.0, 0.5, 1.0};
    }

    public void setGradient(double[] _k, int[] _rgba) {
        if (_k == null || _rgba == null) {
            return;
        }
        int len = Math.min(_k.length, _rgba.length);
        if (len == 0) {
            this.rgba_ = null;
            this.k_ = null;
            return;
        }
        this.rgba_ = new int[len];
        this.k_ = new double[len];
        this.rgba_[0] = _rgba[0];
        this.k_[0] = _k[0];
        int l = 0;
        int i = 1;
        boolean def = false;
        while (i < len) {
            block5: {
                block6: {
                    block4: {
                        if (this.k_[i] != this.k_[l]) break block4;
                        if (def) break block5;
                        def = true;
                        break block6;
                    }
                    def = false;
                }
                this.k_[++l] = _k[i];
                this.rgba_[l] = _rgba[i];
            }
            ++i;
        }
        if (++l != len) {
            int[] c = new int[l];
            double[] k = new double[l];
            System.arraycopy(this.k_, 0, k, 0, l);
            System.arraycopy(this.rgba_, 0, c, 0, l);
            this.k_ = k;
            this.rgba_ = c;
        }
    }

    public void setGradient(int[] _rgba) {
        this.rgba_ = null;
        this.k_ = null;
        if (_rgba == null || _rgba.length < 2) {
            return;
        }
        this.rgba_ = new int[_rgba.length];
        this.k_ = new double[_rgba.length];
        double dk = 1.0 / (double)(_rgba.length - 1);
        double ck = 0.0;
        int i = 0;
        while (i < _rgba.length) {
            this.rgba_[i] = _rgba[i];
            this.k_[i] = ck;
            ck += dk;
            ++i;
        }
    }

    public void setGradient(GradientGenerator _gradient) {
        if (_gradient == null) {
            return;
        }
        int size = _gradient.size();
        if (size == 0) {
            this.k_ = null;
            this.rgba_ = null;
        } else {
            this.k_ = new double[size];
            this.rgba_ = new int[size];
            System.arraycopy(_gradient.k_, 0, this.k_, 0, size);
            System.arraycopy(_gradient.rgba_, 0, this.rgba_, 0, size);
        }
    }

    public void setColorAt(int _index, int _rgba) {
        this.rgba_[_index] = _rgba;
    }

    public int setColor(double _k, int _rgba) {
        if (this.rgba_ == null) {
            this.rgba_ = new int[]{_rgba};
            this.k_ = new double[]{_k};
            return 0;
        }
        int already = 0;
        int[] c = new int[this.rgba_.length - already + 1];
        double[] k = new double[this.k_.length - already + 1];
        int i = 0;
        while (i < this.rgba_.length) {
            if (this.k_[i] >= _k) break;
            k[i] = this.k_[i];
            c[i] = this.rgba_[i];
            ++i;
        }
        int j = i;
        k[j] = _k;
        c[j] = _rgba;
        int index = j++;
        while (i < this.rgba_.length) {
            k[j] = this.k_[i];
            c[j] = this.rgba_[i];
            ++i;
            ++j;
        }
        this.k_ = k;
        this.rgba_ = c;
        return index;
    }

    public void setColor(double _k1, int _rgba1, double _k2, int _rgba2) {
        if (this.rgba_ == null) {
            this.rgba_ = new int[]{_rgba1, _rgba2};
            this.k_ = new double[]{_k1, _k2};
            return;
        }
        if (_k1 == _k2) {
            this.setColor(_k1, _rgba1);
            return;
        }
        if (_k2 < _k1) {
            _k2 = _k1 = _k2;
            int c = _rgba1;
            _rgba1 = _rgba2;
            _rgba2 = c;
        }
        int count = 0;
        int len = this.k_.length;
        boolean first = true;
        int i = 0;
        while (i < len) {
            if (this.k_[i] == _k1) {
                if (!first) break;
                first = false;
            }
            if (this.k_[i] > _k1) break;
            ++i;
        }
        first = true;
        while (i < len && this.k_[i] <= _k2) {
            if (this.k_[i] > _k2) break;
            if (this.k_[i] == _k2) {
                if (i == len - 1) {
                    ++count;
                    break;
                }
                if (this.k_[i + 1] != _k2) break;
                ++count;
                break;
            }
            ++count;
            ++i;
        }
        double[] k = new double[len - count + 2];
        int[] c = new int[len - count + 2];
        first = true;
        i = 0;
        while (i < len) {
            if (this.k_[i] > _k1) break;
            if (this.k_[i] == _k1) {
                if (!first) break;
                first = false;
            }
            k[i] = this.k_[i];
            c[i] = this.rgba_[i];
            ++i;
        }
        int j = i;
        k[j] = _k1;
        c[j] = _rgba1;
        k[++j] = _k2;
        c[j] = _rgba2;
        ++j;
        first = true;
        while (i < len && this.k_[i] <= _k2) {
            if (this.k_[i] > _k2) break;
            if (this.k_[i] == _k2) {
                if (i == len - 1) {
                    ++i;
                    break;
                }
                if (this.k_[i + 1] != _k2) break;
                ++i;
                break;
            }
            ++i;
        }
        while (i < len) {
            k[j] = this.k_[i];
            c[j] = this.rgba_[i];
            ++i;
            ++j;
        }
        this.rgba_ = c;
        this.k_ = k;
    }

    public void removeColorAt(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            return;
        }
        if (size == 1) {
            this.k_ = null;
            this.rgba_ = null;
            return;
        }
        int[] nc = new int[size - 1];
        double[] nk = new double[size - 1];
        int iw = 0;
        int i = 0;
        while (i < size) {
            if (i != index) {
                nc[iw] = this.rgba_[i];
                nk[iw] = this.k_[i];
                ++iw;
            }
            ++i;
        }
        this.k_ = nk;
        this.rgba_ = nc;
    }

    public void removeColor(double _k) {
        if (this.rgba_ == null || this.rgba_.length < 3) {
            return;
        }
        if (_k <= 0.0 || _k > 1.0) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.k_.length) {
            if (this.k_[i] == _k) {
                ++count;
            }
            if (this.k_[i] > _k) break;
            ++i;
        }
        if (count == 0) {
            return;
        }
        double[] k = new double[this.k_.length - count];
        int[] c = new int[this.k_.length - count];
        i = 0;
        while (i < this.k_.length) {
            if (this.k_[i] >= _k) break;
            k[i] = this.k_[i];
            c[i] = this.rgba_[i];
            ++i;
        }
        int j = i;
        while (i < this.k_.length && this.k_[i] == _k) {
            ++i;
        }
        while (i < this.k_.length) {
            k[j] = this.k_[i];
            c[j] = this.rgba_[i];
            ++i;
            ++j;
        }
        this.k_ = k;
        this.rgba_ = c;
    }

    public int size() {
        return this.rgba_ == null ? 0 : this.rgba_.length;
    }

    public double getValueAt(int index) {
        return this.k_[index];
    }

    public int getColorAt(int index) {
        return this.rgba_[index];
    }

    public int getRGBA(double _k) {
        if (this.rgba_ == null || this.rgba_.length < 2 || _k < 0.0 || _k > 1.0 || Double.isNaN(_k)) {
            return 0;
        }
        int i = this.rgba_.length - 1;
        while (this.k_[i] > _k && i > 0) {
            --i;
        }
        if (i < 0) {
            return 0;
        }
        if (this.k_[i] == _k) {
            return this.rgba_[i];
        }
        int c1 = this.rgba_[i];
        int c2 = this.rgba_[i + 1];
        return RGBA.Gradient(c1, c2, (_k - this.k_[i]) / (this.k_[i + 1] - this.k_[i]));
    }

    public String toString() {
        String s = super.toString();
        s = String.valueOf(s) + "[" + (this.k_ == null ? 0 : this.k_.length) + "]";
        if (this.k_ != null && this.k_.length > 0) {
            s = String.valueOf(s) + "{";
            int i = 0;
            while (i < this.k_.length) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                String c = Long.toString((long)this.rgba_[i] & 0xFFFFFFFFL, 16);
                while (c.length() < 8) {
                    c = "0" + c;
                }
                s = String.valueOf(s) + Double.toString(this.k_[i]) + ":" + c;
                ++i;
            }
            s = String.valueOf(s) + "}";
        }
        return s;
    }

    public boolean containsTransparency() {
        int i = 0;
        while (i < this.rgba_.length) {
            if (!RGBA.IsOpaque(this.rgba_[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static GradientGenerator Rainbow() {
        return new GradientGenerator(new int[]{-16776961, -6291201, -65281, 0xFF00FF, 65535, -16711681});
    }
}

