/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.util.internal.Point;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class LineStylePen
implements IPen {
    public static final int SOLID = 0;
    public static final int DASH = 1;
    public static final int DOT = 2;
    public static final int DASH_DOT = 3;
    public static final int DASH_DOT_DOT = 4;
    public static final int PIXEL = 5;
    public static final int[] DEF_DOT = new int[]{6, 1, 3, 3};
    public static final int[] DEF_DASH = new int[]{24, 1, 18, 6};
    public static final int[] DEF_DASH_DOT = new int[]{24, 1, 9, 6, 3, 6};
    public static final int[] DEF_DASH_DOT_DOT = new int[]{24, 1, 9, 3, 3, 3, 3, 3};
    public static final int[] DEF_PIXEL = new int[]{2, 1, 1, 1};
    protected int rgba_;
    protected int line_style_;
    protected int line_width_;
    protected IGC gc_;

    public LineStylePen(int _rgba, int line_style, int line_width) {
        this.rgba_ = _rgba;
        this.line_style_ = line_style;
        this.line_width_ = line_width;
    }

    public LineStylePen(int _rgba, int line_style) {
        this.rgba_ = _rgba;
        this.line_style_ = line_style;
        this.line_width_ = 0;
    }

    public LineStylePen(int _rgba) {
        this.rgba_ = _rgba;
        this.line_style_ = 0;
        this.line_width_ = 0;
    }

    public LineStylePen(LineStylePen _pen) {
        this.rgba_ = _pen.rgba_;
        this.line_width_ = _pen.line_width_;
        this.line_style_ = _pen.line_style_;
    }

    public LineStylePen() {
        this.rgba_ = 255;
        this.line_width_ = 0;
        this.line_style_ = 0;
    }

    public IPen copyPen() {
        return new LineStylePen(this);
    }

    public String toString() {
        String s = super.toString();
        s = String.valueOf(s) + "{rgba=" + RGBA.Str(this.rgba_) + ", style=" + LineStylePen.StrStyle(this.line_style_) + ", width=" + this.line_width_ + " }";
        return s;
    }

    public static String StrStyle(int style) {
        switch (style) {
            case 0: {
                return "SOLID";
            }
            case 1: {
                return "DASH";
            }
            case 2: {
                return "DOT";
            }
            case 3: {
                return "DASH_DOT";
            }
            case 4: {
                return "DASH_DOT_DOT";
            }
        }
        return Integer.toString(style);
    }

    public int getRGBA() {
        return this.rgba_;
    }

    public int getLineStyle() {
        return this.line_style_;
    }

    public int getLineWidth() {
        return this.line_width_;
    }

    public void setRGBA(int _rgba) {
        this.rgba_ = _rgba;
    }

    public void setLineStyle(int line_style) {
        this.line_style_ = line_style;
    }

    public void setLineWidth(int line_width) {
        this.line_width_ = line_width;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawPath(IGC gc, IGCDirect gd, IPath path, int[] def) {
        rdef = def;
        if (def[0] == 0) {
            return;
        }
        def[1];
        if (!gd.usePixelCoordinates()) {
            len = def.length;
            nlen = gd.devX(def[0]);
            rdef = new int[def.length];
            rdef[0] = nlen;
            rdef[1] = def[1];
            k = (double)nlen / (double)def[0];
            i = 2;
            while (i < len) {
                rdef[i] = npix = (int)Math.round(k * (double)def[i]);
                ++i;
            }
        }
        lx = -1;
        ly = -1;
        rdef[0];
        curr = 0;
        on = rdef[1] == 1;
        icurr = 2;
        p = new Point();
        def_len = rdef.length;
        transp = RGBA.IsOpaque(this.rgba_) == false;
        e = path.nextPathElement();
        while (e != null) {
            block9: {
                if (e.pathElementBegin(gc, gd)) ** GOTO lbl48
                break block9;
lbl-1000:
                // 1 sources

                {
                    px = p.getX();
                    py = p.getY();
                    if (lx == px && ly == py) continue;
                    if (on) {
                        rgba = this.rgba_;
                        if (transp) {
                            rgba = RGBA.Combine(this.rgba_, gd.getPointDirect(px, py));
                        }
                        gd.drawPointDirect(px, py, rgba);
                    }
                    if (++curr >= rdef[icurr]) {
                        on = on == false;
                        curr = 0;
                        if (++icurr >= def_len) {
                            icurr = 2;
                            on = rdef[1] == 1;
                        }
                    }
                    lx = px;
                    ly = py;
lbl48:
                    // 3 sources

                    ** while (e.nextPoint((IPoint)p))
                }
lbl49:
                // 1 sources

                e.pathElementEnd();
            }
            e = path.nextPathElement();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawPath(IGC gc, IGCDirect gd, IPath path) {
        path.pathBegin(gc, gd);
        Point p = new Point();
        int lx = -1;
        int ly = -1;
        boolean transp = !RGBA.IsOpaque(this.rgba_);
        switch (this.line_style_) {
            case 0: {
                IPathElement e = path.nextPathElement();
                while (e != null) {
                    if (e.pathElementBegin(gc, gd)) {
                        while (true) {
                            if (!e.nextPoint(p)) {
                                e.pathElementEnd();
                                break;
                            }
                            int px = p.getX();
                            int py = p.getY();
                            if (lx == px && ly == py) continue;
                            int rgba = this.rgba_;
                            if (transp) {
                                rgba = RGBA.Combine(this.rgba_, gd.getPointDirect(px, py));
                            }
                            gd.drawPointDirect(px, py, rgba);
                            lx = px;
                            ly = py;
                        }
                    }
                    e = path.nextPathElement();
                }
                break;
            }
            case 2: {
                this.drawPath(gc, gd, path, DEF_DOT);
                break;
            }
            case 1: {
                this.drawPath(gc, gd, path, DEF_DASH);
                break;
            }
            case 3: {
                this.drawPath(gc, gd, path, DEF_DASH_DOT);
                break;
            }
            case 4: {
                this.drawPath(gc, gd, path, DEF_DASH_DOT_DOT);
                break;
            }
            case 5: {
                this.drawPath(gc, gd, path, DEF_PIXEL);
                break;
            }
        }
        path.pathEnd();
    }
}

