/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.Spline3Alg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IVector;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;

public class PolygonSpline3
implements IPath,
IPathElement {
    protected IPolygon poly_;
    protected boolean give_next_path_element_;
    protected int curr_index_;
    protected int state_;
    protected int[] dpoints_;
    protected Spline3Alg spline_;

    public PolygonSpline3(IPolygon _poly) {
        this.poly_ = _poly;
    }

    public PolygonSpline3() {
    }

    public IPolygon getPolygon() {
        return this.poly_;
    }

    public void setPolygon(IPolygon p) {
        this.poly_ = p;
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.give_next_path_element_ = this.poly_ != null && this.poly_.getPolySize() > 3;
        return this.give_next_path_element_;
    }

    public void pathEnd() {
        this.give_next_path_element_ = false;
    }

    public IPathElement nextPathElement() {
        if (this.give_next_path_element_) {
            this.give_next_path_element_ = false;
            return this;
        }
        return null;
    }

    public IPathElement copyPathElement() {
        return new PolygonSpline3(new Polygon(this.poly_));
    }

    public boolean pathElementBegin(IGC gc, IGCDirect gd) {
        if (this.poly_ == null || this.poly_.getPolySize() < 3) {
            return false;
        }
        int size = this.poly_.getPolySize();
        this.curr_index_ = 0;
        int index = 0;
        if (this.poly_.isPolyClosed()) {
            if (this.poly_.getPolyX(0) == this.poly_.getPolyX(size - 1) && this.poly_.getPolyY(0) == this.poly_.getPolyY(size - 1)) {
                --size;
            }
            this.dpoints_ = new int[4 * size + 2];
            int lx = gd.devX(this.poly_.getPolyX(size - 1));
            int ly = gd.devY(this.poly_.getPolyY(size - 1));
            int i = 0;
            while (i < size) {
                int px = gd.devX(this.poly_.getPolyX(i));
                int py = gd.devY(this.poly_.getPolyY(i));
                this.dpoints_[index++] = lx + px >> 1;
                this.dpoints_[index++] = ly + py >> 1;
                this.dpoints_[index++] = px;
                this.dpoints_[index++] = py;
                lx = px;
                ly = py;
                ++i;
            }
            this.dpoints_[index++] = this.dpoints_[0];
            this.dpoints_[index++] = this.dpoints_[1];
        } else {
            this.dpoints_ = new int[2 * (2 * (size - 3) + 3)];
            this.dpoints_[index++] = gd.devX(this.poly_.getPolyX(0));
            this.dpoints_[index++] = gd.devY(this.poly_.getPolyY(0));
            int n = index++;
            int n2 = gd.devX(this.poly_.getPolyX(1));
            this.dpoints_[n] = n2;
            int lx = n2;
            int n3 = index++;
            int n4 = gd.devY(this.poly_.getPolyY(1));
            this.dpoints_[n3] = n4;
            int ly = n4;
            int i = 2;
            while (i < size - 1) {
                int px = gd.devX(this.poly_.getPolyX(i));
                int py = gd.devY(this.poly_.getPolyY(i));
                this.dpoints_[index++] = lx + px >> 1;
                this.dpoints_[index++] = ly + py >> 1;
                this.dpoints_[index++] = px;
                this.dpoints_[index++] = py;
                lx = px;
                ly = py;
                ++i;
            }
            this.dpoints_[index++] = gd.devX(this.poly_.getPolyX(size - 1));
            this.dpoints_[index++] = gd.devY(this.poly_.getPolyY(size - 1));
        }
        if (this.spline_ == null) {
            this.spline_ = new Spline3Alg();
        }
        this.state_ = 0;
        return true;
    }

    public void pathElementEnd() {
        this.dpoints_ = null;
        this.state_ = 2;
    }

    public boolean nextPoint(IPoint point) {
        if (this.state_ == 0) {
            this.spline_.setSpline(this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_], this.dpoints_[this.curr_index_ + 1]);
            this.state_ = 1;
            return this.spline_.nextPoint(point);
        }
        if (this.state_ == 1) {
            if (this.spline_.nextPoint(point)) {
                return true;
            }
            do {
                if (this.curr_index_ >= this.dpoints_.length - 4) {
                    this.state_ = 2;
                    return false;
                }
                this.spline_.setSpline(this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_++], this.dpoints_[this.curr_index_], this.dpoints_[this.curr_index_ + 1]);
            } while (!this.spline_.nextPoint(null) || !this.spline_.nextPoint(point));
            return true;
        }
        return false;
    }

    public void backTangent(IVector vector) {
        this.spline_.backTangent(vector);
    }

    public void frontTangent(IVector vector) {
        this.spline_.frontTangent(vector);
    }
}

