/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;

public class RGBAImage
implements IImage {
    protected int width_;
    protected int height_;
    protected int[] image_;

    public RGBAImage(int width, int height) {
        this.width_ = width;
        this.height_ = height;
        this.image_ = new int[this.width_ * this.height_];
    }

    public RGBAImage(int width, int height, int[] image) {
        this.width_ = width;
        this.height_ = height;
        this.image_ = image;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getPixel(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width_ || y >= this.height_) {
            return 0;
        }
        return this.image_[y * this.width_ + x];
    }

    public int[] getImage() {
        return this.image_;
    }

    protected int antialiased(double _rx, double _ry) {
        if (_rx < 0.0) {
            _rx = 0.0;
        }
        int sx = (int)_rx;
        int sy = (int)_ry;
        double dx = _rx - (double)sx;
        double dy = _ry - (double)sy;
        double a1 = (1.0 - dx) * (1.0 - dy);
        double a2 = (1.0 - dx) * dy;
        double a3 = dx * dy;
        double a4 = dx * (1.0 - dy);
        int index = sy * this.width_ + sx;
        int rgba = this.image_[index];
        int r1 = RGBA.GetR(rgba);
        int g1 = RGBA.GetG(rgba);
        int b1 = RGBA.GetB(rgba);
        int al1 = RGBA.GetA(rgba);
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int al2 = 0;
        int r3 = 0;
        int g3 = 0;
        int b3 = 0;
        int al3 = 0;
        boolean incomplete = false;
        if (sy + 1 < this.height_) {
            rgba = this.image_[index + this.width_];
            r2 = RGBA.GetR(rgba);
            g2 = RGBA.GetG(rgba);
            b2 = RGBA.GetB(rgba);
            al2 = RGBA.GetA(rgba);
            if (sx + 1 < this.width_) {
                rgba = this.image_[index + this.width_ + 1];
                r3 = RGBA.GetR(rgba);
                g3 = RGBA.GetG(rgba);
                b3 = RGBA.GetB(rgba);
                al3 = RGBA.GetA(rgba);
            } else {
                incomplete = true;
                a3 = 0.0;
            }
        } else {
            incomplete = true;
            a3 = 0.0;
            a2 = 0.0;
        }
        int r4 = 0;
        int g4 = 0;
        int b4 = 0;
        int al4 = 0;
        if (sx + 1 < this.width_) {
            rgba = this.image_[index + 1];
            r4 = RGBA.GetR(rgba);
            g4 = RGBA.GetG(rgba);
            b4 = RGBA.GetB(rgba);
            al4 = RGBA.GetA(rgba);
        } else {
            incomplete = true;
            a4 = 0.0;
        }
        if (incomplete) {
            double sum = a1 + a2 + a3 + a4;
            double factor = 1.0 / sum;
            a1 *= factor;
            a2 *= factor;
            a3 *= factor;
            a4 *= factor;
        }
        int R = (int)Math.round(a1 * (double)r1 + a2 * (double)r2 + a3 * (double)r3 + a4 * (double)r4);
        int G = (int)Math.round(a1 * (double)g1 + a2 * (double)g2 + a3 * (double)g3 + a4 * (double)g4);
        int B = (int)Math.round(a1 * (double)b1 + a2 * (double)b2 + a3 * (double)b3 + a4 * (double)b4);
        int A = (int)Math.round(a1 * (double)al1 + (double)(al2 * al2) + a3 * (double)al3 + a4 * (double)al4);
        if (R < 0 || R > 255 || G < 0 || G > 255 || B < 0 || B > 255) {
            System.out.println("BAD COLOR RGB=" + R + "," + G + "," + B);
            System.out.println(" ry=" + _ry + " sy=" + sy);
            System.out.println(" rx=" + _rx + " sx=" + sx);
            System.out.println(" dx=" + dx + " dy=" + dy);
            System.out.println(" a1=" + a1 + " a2=" + a2 + " a3=" + a3 + " a4=" + a4 + " sum=" + (a1 + a2 + a3 + a4) + " incomplete=" + incomplete);
            System.out.println(" r1=" + r1 + " r2=" + r2 + " r3=" + r3 + " r4=" + r4);
            System.out.println(" g1=" + r1 + " g2=" + r2 + " g3=" + r3 + " g4=" + r4);
            System.out.println(" b1=" + r1 + " b2=" + r2 + " b3=" + r3 + " b4=" + r4);
        }
        return RGBA.Get(R, G, B, A);
    }

    protected static int rotateX(double cos, double sin, int x, int y) {
        return (int)Math.round(cos * (double)x + sin * (double)y);
    }

    protected static int rotateY(double cos, double sin, int x, int y) {
        return (int)Math.round(-sin * (double)x + cos * (double)y);
    }

    protected RGBAImage rotateImageAny(int angle, int new_pixel, boolean antialiased) {
        double a = Radian.D2R(angle);
        double c = Math.cos(a);
        double s = Math.sin(a);
        int X = this.width_ - 1;
        int Y = this.height_ - 1;
        int rx0 = RGBAImage.rotateX(c, s, 0, 0);
        int ry0 = RGBAImage.rotateY(c, s, 0, 0);
        int rx1 = RGBAImage.rotateX(c, s, X, 0);
        int ry1 = RGBAImage.rotateY(c, s, X, 0);
        int rx2 = RGBAImage.rotateX(c, s, X, Y);
        int ry2 = RGBAImage.rotateY(c, s, X, Y);
        int rx3 = RGBAImage.rotateX(c, s, 0, Y);
        int ry3 = RGBAImage.rotateY(c, s, 0, Y);
        int rxmin = Math.min(rx0, Math.min(rx1, Math.min(rx2, rx3)));
        int rxmax = Math.max(rx0, Math.max(rx1, Math.max(rx2, rx3)));
        int rymin = Math.min(ry0, Math.min(ry1, Math.min(ry2, ry3)));
        int rymax = Math.max(ry0, Math.max(ry1, Math.max(ry2, ry3)));
        int destX = rxmax - rxmin;
        int destY = rymax - rymin;
        RGBAImage dest = new RGBAImage(destX + 1, destY + 1);
        int[] dst = dest.image_;
        int dx = 0;
        int dy = 0;
        int ix = 0;
        int iy = 0;
        try {
            int y = 0 + rymin;
            double sy = s * (double)y;
            double cy = c * (double)y;
            int iw = 0;
            dy = 0;
            while (dy <= destY) {
                int x = 0 + rxmin;
                double cx = c * (double)x;
                double sx = s * (double)x;
                dx = 0;
                while (dx <= destX) {
                    double fiy;
                    double fix = cx - sy;
                    ix = (int)Math.round(fix);
                    dst[iw] = ix >= 0 && ix <= X ? ((iy = (int)Math.round(fiy = sx + cy)) >= 0 && iy <= Y ? (antialiased ? this.antialiased(fix, fiy) : this.image_[iy * this.width_ + ix]) : new_pixel) : new_pixel;
                    ++dx;
                    ++x;
                    cx += c;
                    sx += s;
                    ++iw;
                }
                ++dy;
                ++y;
                sy += s;
                cy += c;
            }
        }
        catch (IllegalArgumentException exx) {
            System.err.println("rotateImageDataAny/ ix=" + ix + " iy=" + iy + " dx=" + dx + " dy=" + dy + " np_index=" + new_pixel + " image=" + dest.width_ + "x" + dest.height_);
            throw exx;
        }
        return dest;
    }

    public static Size rotateImageSize(int width, int height, double angle) {
        int angle_degree = Radian.iR2D(angle);
        switch (angle_degree % 360) {
            case 0: 
            case 180: {
                return new Size(width, height);
            }
            case 90: 
            case 270: {
                return new Size(height, width);
            }
        }
        double crot = Math.cos(angle);
        double srot = Math.sin(angle);
        int X = width - 1;
        int Y = height - 1;
        int rx0 = RGBAImage.rotateX(crot, srot, 0, 0);
        int ry0 = RGBAImage.rotateY(crot, srot, 0, 0);
        int rx1 = RGBAImage.rotateX(crot, srot, X, 0);
        int ry1 = RGBAImage.rotateY(crot, srot, X, 0);
        int rx2 = RGBAImage.rotateX(crot, srot, X, Y);
        int ry2 = RGBAImage.rotateY(crot, srot, X, Y);
        int rx3 = RGBAImage.rotateX(crot, srot, 0, Y);
        int ry3 = RGBAImage.rotateY(crot, srot, 0, Y);
        int rxmin = Math.min(rx0, Math.min(rx1, Math.min(rx2, rx3)));
        int rxmax = Math.max(rx0, Math.max(rx1, Math.max(rx2, rx3)));
        int rymin = Math.min(ry0, Math.min(ry1, Math.min(ry2, ry3)));
        int rymax = Math.max(ry0, Math.max(ry1, Math.max(ry2, ry3)));
        return new Size(rxmax - rxmin + 1, rymax - rymin + 1);
    }

    public static Polygon rotateImageBounds(int x, int y, int width, int height, double angle) {
        int deg_angle = Radian.iR2D(Radian.normalize(angle));
        switch (deg_angle) {
            case 0: {
                int xx = x + width - 1;
                int yx = y + height - 1;
                return new Polygon(new int[]{x, y, xx, y, xx, yx, x, yx});
            }
            case 90: {
                int yt = y - width + 1;
                int xx = x + height - 1;
                return new Polygon(new int[]{x, y, x, yt, xx, yt, xx, y});
            }
            case 180: {
                int xl = x - width + 1;
                int yt = y - height + 1;
                return new Polygon(new int[]{x, y, xl, y, xl, yt, x, yt});
            }
            case 270: {
                int xl = x - height + 1;
                int yx = y + width - 1;
                return new Polygon(new int[]{x, y, x, yx, xl, yx, xl, y});
            }
        }
        int xx = x + width - 1;
        int yx = y + height - 1;
        int[] xy = new int[]{x, y, xx, y, xx, yx, x, yx};
        Polygon p = new Polygon(xy);
        p.rotate(x, y, angle);
        return p;
    }

    public RGBAImage rotateImage(double angle, int new_pixel_rgba, boolean antialiased) {
        int deg_angle = Radian.iR2D(Radian.normalize(angle));
        switch (deg_angle % 360) {
            case 0: {
                return this;
            }
            case 90: {
                RGBAImage r = new RGBAImage(this.height_, this.width_);
                int[] dst = r.image_;
                int dx = 0;
                int ir = 0;
                int sy = 0;
                while (sy < this.height_) {
                    int iw = (r.height_ - 1) * r.width_ + dx;
                    int sx = 0;
                    while (sx < this.width_) {
                        dst[iw] = this.image_[ir];
                        ++sx;
                        iw -= r.width_;
                        ++ir;
                    }
                    ++sy;
                    ++dx;
                }
                return r;
            }
            case 270: {
                RGBAImage r = new RGBAImage(this.height_, this.width_);
                int[] dst = r.getImage();
                int dst_width = r.width_;
                int dx = this.height_ - 1;
                int ir = 0;
                int sy = 0;
                while (sy < this.height_) {
                    int iw = dx;
                    int sx = 0;
                    while (sx < this.width_) {
                        dst[iw] = this.image_[ir++];
                        ++sx;
                        iw += dst_width;
                    }
                    ++sy;
                    --dx;
                }
                return r;
            }
            case 180: {
                RGBAImage r = new RGBAImage(this.width_, this.height_);
                int[] dst = r.image_;
                int size = this.width_ * this.height_;
                int iw = size - 1;
                int ir = 0;
                while (ir < size) {
                    dst[iw] = this.image_[ir];
                    ++ir;
                    --iw;
                }
                return r;
            }
        }
        return this.rotateImageAny(deg_angle, new_pixel_rgba, antialiased);
    }
}

