/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Point;
import org.eclipse.tptp.platform.report.igc.util.internal.Segment;

public class Rect
implements IRect,
IPath {
    protected int x_;
    protected int y_;
    protected int w_;
    protected int h_;
    protected int dx_;
    protected int dy_;
    protected int dX_;
    protected int dY_;
    protected int pe_;
    protected Segment segment_;

    public Rect() {
        this.h_ = 0;
        this.w_ = 0;
        this.y_ = 0;
        this.x_ = 0;
    }

    public Rect(int _x, int _y, int _w, int _h) {
        this.x_ = _x;
        this.y_ = _y;
        this.w_ = _w;
        this.h_ = _h;
    }

    public Rect(IRect _r) {
        this.setRect(_r);
    }

    public Rect(IRect _r, int _grow) {
        this.setRect(_r, _grow);
    }

    public IRect getBounds() {
        return this;
    }

    public IShape copyShape() {
        return new Rect(this);
    }

    public int x() {
        return this.x_;
    }

    public int y() {
        return this.y_;
    }

    public int w() {
        return this.w_;
    }

    public int h() {
        return this.h_;
    }

    public int getX() {
        return this.x_;
    }

    public int getY() {
        return this.y_;
    }

    public int getW() {
        return this.w_;
    }

    public int getH() {
        return this.h_;
    }

    public int left() {
        if (this.w_ >= 0) {
            return this.x_;
        }
        return this.x_ + this.w_;
    }

    public int right() {
        if (this.w_ >= 0) {
            return this.x_ + this.w_;
        }
        return this.x_;
    }

    public int top() {
        if (this.h_ >= 0) {
            return this.y_;
        }
        return this.y_ + this.h_;
    }

    public int bottom() {
        if (this.h_ >= 0) {
            return this.y_ + this.h_;
        }
        return this.y_;
    }

    public Point center() {
        return new Point(this.centerX(), this.centerY());
    }

    public int centerX() {
        return this.x_ + (this.w_ >> 1);
    }

    public int centerY() {
        return this.y_ + (this.h_ >> 1);
    }

    public void setX(int _x) {
        this.x_ = _x;
    }

    public void setY(int _y) {
        this.y_ = _y;
    }

    public void setWidth(int _w) {
        this.w_ = _w;
    }

    public void setHeight(int _h) {
        this.h_ = _h;
    }

    public void setSize(int _w, int _h) {
        this.w_ = _w;
        this.h_ = _h;
    }

    public final void setSize(IPoint _size) {
        this.setSize(_size.getX(), _size.getY());
    }

    public final void setSize(ISize _size) {
        this.setSize(_size.getW(), _size.getH());
    }

    public void setLocation(int _x, int _y) {
        this.x_ = _x;
        this.y_ = _y;
    }

    public final void setLocation(IPoint _p) {
        this.setLocation(_p.getX(), _p.getY());
    }

    public void setLeft(int _l) {
        int r = this.right();
        this.x_ = _l;
        this.w_ = r - _l;
    }

    public void setRight(int _r) {
        int l;
        this.x_ = l = this.left();
        this.w_ = _r - l;
    }

    public void setTop(int _t) {
        int b = this.bottom();
        this.y_ = _t;
        this.h_ = b - _t;
    }

    public void setBottom(int _b) {
        int t;
        this.y_ = t = this.top();
        this.h_ = _b - t;
    }

    public void grow(int _amount) {
        this.x_ -= _amount;
        this.w_ += 2 * _amount;
        this.y_ -= _amount;
        this.h_ += 2 * _amount;
    }

    public void shrink(int _amount) {
        this.x_ += _amount;
        this.w_ -= 2 * _amount;
        this.y_ += _amount;
        this.h_ -= 2 * _amount;
    }

    public static boolean Contains(int _lx, int _ty, int _w, int _h, int _px, int _py) {
        if (_px < _lx) {
            return false;
        }
        if (_px > _lx + _w) {
            return false;
        }
        if (_py < _ty) {
            return false;
        }
        return _py <= _ty + _h;
    }

    public static boolean Contains(IRect _r, int _px, int _py) {
        if (_px < _r.getX()) {
            return false;
        }
        if (_px > _r.getX() + _r.getW()) {
            return false;
        }
        if (_py < _r.getY()) {
            return false;
        }
        return _py <= _r.getY() + _r.getH();
    }

    public boolean contains(int _px, int _py) {
        if (_px <= this.left()) {
            return false;
        }
        if (_px >= this.right()) {
            return false;
        }
        if (_py <= this.top()) {
            return false;
        }
        return _py < this.bottom();
    }

    public final boolean contains(IPoint _p) {
        if (_p == null) {
            return false;
        }
        return this.contains(_p.getX(), _p.getY());
    }

    public void setRect(int _x, int _y, int _w, int _h) {
        this.x_ = _x;
        this.y_ = _y;
        this.w_ = _w;
        this.h_ = _h;
    }

    public void setRect(IRect _r) {
        if (_r == null) {
            this.h_ = 0;
            this.w_ = 0;
            this.y_ = 0;
            this.x_ = 0;
        } else {
            this.x_ = _r.getX();
            this.y_ = _r.getY();
            this.w_ = _r.getW();
            this.h_ = _r.getH();
        }
    }

    public void setRect(IRect _r, int _grow) {
        this.setRect(_r);
        this.grow(_grow);
    }

    public Rect normalize() {
        if (this.w_ < 0) {
            this.x_ += this.w_;
            this.w_ = -this.w_;
        }
        if (this.h_ < 0) {
            this.y_ += this.h_;
            this.h_ = -this.h_;
        }
        return this;
    }

    public void moveTo(int _x, int _y) {
        this.x_ = _x;
        this.y_ = _y;
    }

    public void moveBy(int _dx, int _dy) {
        this.x_ += _dx;
        this.y_ += _dy;
    }

    public void moveCenter(int _cx, int _cy) {
        this.x_ = _cx - (this.w_ >> 1);
        this.y_ = _cy - (this.h_ >> 1);
    }

    public final void moveCenter(IPoint _p) {
        this.moveCenter(_p.getX(), _p.getY());
    }

    public Rect intersection(IRect _r) {
        Rect r = new Rect(_r);
        int left = Math.max(this.left(), r.left());
        int top = Math.max(this.top(), r.top());
        int right = Math.min(this.right(), r.right());
        int bottom = Math.min(this.bottom(), r.bottom());
        this.x_ = left;
        this.y_ = top;
        this.w_ = Math.max(0, right - left);
        this.h_ = Math.max(0, bottom - top);
        return this;
    }

    public Rect union(IRect _r) {
        Rect r = new Rect(_r);
        int left = Math.min(this.left(), r.left());
        int top = Math.min(this.top(), r.top());
        int right = Math.max(this.right(), r.right());
        int bottom = Math.max(this.bottom(), r.bottom());
        this.x_ = left;
        this.y_ = top;
        this.w_ = Math.max(0, right - left);
        this.h_ = Math.max(0, bottom - top);
        return this;
    }

    public static Rect Intersection(Rect _r1, Rect _r2) {
        Rect r = new Rect(_r1);
        return r.intersection(_r2);
    }

    public static Rect Intersection(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int b2;
        int t2;
        int r2;
        int l2;
        int b1;
        int t1;
        int r1;
        int l1;
        if (w1 >= 0) {
            l1 = x1;
            r1 = x1 + w1;
        } else {
            l1 = x1 + w1;
            r1 = x1;
        }
        if (h1 >= 0) {
            t1 = y1;
            b1 = y1 + h1;
        } else {
            t1 = y1 + h1;
            b1 = y1;
        }
        if (w2 >= 0) {
            l2 = x2;
            r2 = x2 + w2;
        } else {
            l2 = x2 + w2;
            r2 = x2;
        }
        if (h2 >= 0) {
            t2 = y2;
            b2 = y2 + h2;
        } else {
            t2 = y2 + h2;
            b2 = y2;
        }
        int left = Math.max(l1, l2);
        int right = Math.min(r1, r2);
        int w = right - left;
        if (w < 0) {
            return null;
        }
        int top = Math.max(t1, t2);
        int bottom = Math.min(b1, b2);
        int h = bottom - top;
        if (h < 0) {
            return null;
        }
        return new Rect(left, top, w, h);
    }

    public static Rect Union(Rect _r1, Rect _r2) {
        Rect r = new Rect(_r1);
        return r.union(_r2);
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + "{" + this.x_ + "," + this.y_ + "," + this.w_ + "x" + this.h_ + "}";
        return s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IRect) {
            Rect or = (Rect)o;
            return or.getX() == this.x_ && or.getY() == this.y_ && or.getH() == this.h_ && or.getW() == this.w_;
        }
        return false;
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.dx_ = gd.devX(this.x_);
        this.dy_ = gd.devY(this.y_);
        this.dX_ = this.dx_ + gd.devX(this.w_);
        this.dY_ = this.dy_ + gd.devY(this.h_);
        this.pe_ = 0;
        this.segment_ = new Segment();
        return true;
    }

    public void pathEnd() {
        this.segment_ = null;
    }

    public IPathElement nextPathElement() {
        switch (this.pe_) {
            case 0: {
                this.segment_.setLine(this.dx_, this.dy_, this.dX_, this.dy_);
                this.pe_ = 1;
                return this.segment_;
            }
            case 1: {
                this.segment_.setLine(this.dX_, this.dy_ + 1, this.dX_, this.dY_ - 1);
                this.pe_ = 2;
                return this.segment_;
            }
            case 2: {
                this.segment_.setLine(this.dX_, this.dY_, this.dx_, this.dY_);
                this.pe_ = 3;
                return this.segment_;
            }
            case 3: {
                this.segment_.setLine(this.dx_, this.dY_ - 1, this.dx_, this.dy_ + 1);
                this.pe_ = 4;
                return this.segment_;
            }
        }
        return null;
    }

    public static int CenterX(IRect r) {
        return r.getX() + r.getW() / 2;
    }

    public static int CenterY(IRect r) {
        return r.getY() + r.getH() / 2;
    }

    public static int Right(IRect r) {
        int x = r.getX();
        return Math.max(x, x + r.getW());
    }

    public static int Left(IRect r) {
        int x = r.getX();
        return Math.min(x, x + r.getW());
    }

    public static int Top(IRect r) {
        int y = r.getY();
        return Math.min(y, y + r.getH());
    }

    public static int Bottom(IRect r) {
        int y = r.getY();
        return Math.max(y, y + r.getH());
    }
}

