/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IVector;

public class Segment
extends LineAlg
implements IPath,
IPathElement {
    protected double tgx_;
    protected double tgy_;

    public Segment(int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
    }

    public Segment(Segment s) {
        super(s.x1_, s.y1_, s.x2_, s.y2_);
    }

    public Segment() {
    }

    public IPathElement copyPathElement() {
        return new Segment(this);
    }

    public void setLine(int x1, int y1, int x2, int y2) {
        super.setLine(x1, y1, x2, y2);
        this.tgx_ = x2 - x1;
        this.tgy_ = y2 - y1;
        double n = Math.sqrt(this.tgx_ * this.tgx_ + this.tgy_ * this.tgy_);
        if (n != 1.0 && n != 0.0) {
            this.tgx_ /= n;
            this.tgy_ /= n;
        }
    }

    public boolean pathElementBegin(IGC gc, IGCDirect gd) {
        this.restart();
        return true;
    }

    public void pathElementEnd() {
    }

    public void backTangent(IVector vector) {
        vector.setVector(this.tgx_, this.tgy_);
    }

    public void frontTangent(IVector vector) {
        vector.setVector(this.tgx_, this.tgy_);
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.restart();
        return true;
    }

    public void pathEnd() {
    }

    public IPathElement nextPathElement() {
        return this.state_ == this.S_NOTSTARTED ? this : null;
    }

    public void translate(int tx, int ty) {
        this.x1_ += tx;
        this.x2_ += tx;
        this.y1_ += ty;
        this.y2_ += ty;
    }
}

