/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTImage;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.tools.internal.AbstractIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;

public class AWTIImageProvider
extends AbstractIImageProvider {
    protected IImage createBrokenImage() {
        try {
            int l;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            BufferedInputStream bis = new BufferedInputStream(IDIImageProvider.class.getResourceAsStream("brokenImage.gif"));
            byte[] buf = new byte[4096];
            while ((l = bis.read(buf)) > 0) {
                bos.write(buf, 0, l);
            }
            Image image = Toolkit.getDefaultToolkit().createImage(bos.toByteArray());
            if (this.waitLoadImage(image)) {
                return new AWTImage(image, null);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Cannot load image brokenImage.gif");
        }
        BufferedImage bi = new BufferedImage(30, 30, 1);
        Graphics g = bi.getGraphics();
        g.setColor(new Color(255, 0, 0));
        g.fillRect(0, 0, 30, 30);
        return new AWTImage((Image)bi, null);
    }

    public void setBrokenImage(IImage image) {
        if (this.brokenImage instanceof AWTImage) {
            ((AWTImage)this.brokenImage).disposeImage();
        }
        this.brokenImage = image;
    }

    protected IImage createImageFromFile(String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        Image img = null;
        try {
            img = Toolkit.getDefaultToolkit().createImage(filename);
            if (this.waitLoadImage(img)) {
                return new AWTImage(img, null);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }

    protected IImage createImageFromInputStream(InputStream input_stream) {
        if (input_stream == null) {
            return null;
        }
        Image img = null;
        try {
            int l;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            BufferedInputStream bis = new BufferedInputStream(input_stream);
            byte[] buf = new byte[4096];
            while ((l = bis.read(buf)) > 0) {
                bos.write(buf, 0, l);
            }
            img = Toolkit.getDefaultToolkit().createImage(bos.toByteArray());
            if (this.waitLoadImage(img)) {
                return new AWTImage(img, null);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }

    protected void disposeImage(IImage image) {
        if (image instanceof AWTImage) {
            ((AWTImage)image).disposeImage();
        }
    }

    private boolean waitLoadImage(Image img) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk.prepareImage(img, -1, -1, null)) {
            return true;
        }
        int st;
        while (((st = tk.checkImage(img, -1, -1, null)) & 0x40) == 0) {
            if ((st & 0x20) != 0) {
                return true;
            }
            if ((st & 0x80) != 0) {
                return false;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return false;
    }
}

