/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;

public abstract class AbstractIImageProvider
implements IDIImageProvider {
    protected IImage brokenImage;
    private ArrayList search_path;
    private ArrayList classes_resources;
    private Hashtable imagePool;

    protected abstract IImage createBrokenImage();

    protected abstract IImage createImageFromFile(String var1);

    protected abstract IImage createImageFromInputStream(InputStream var1);

    protected abstract void disposeImage(IImage var1);

    public IImage getBrokenImage() {
        if (this.brokenImage != null) {
            return this.brokenImage;
        }
        this.brokenImage = this.createBrokenImage();
        return this.brokenImage;
    }

    public void setBrokenImage(IImage image) {
        this.brokenImage = image;
    }

    private IImage getImageFromSearchPath(String name) {
        String imgfilename = this.searchImage(name);
        if (imgfilename != null) {
            IImage img = this.createImageFromFile(imgfilename);
            return img;
        }
        return null;
    }

    private IImage getImageViaHttp(URL url) {
        try {
            InputStream is = url.openStream();
            IImage img = this.createImageFromInputStream(is);
            is.close();
            if (img != null) {
                return img;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getBrokenImage();
    }

    private IImage getImageFromClassResources(String res_name) {
        if (this.classes_resources == null) {
            return null;
        }
        for (Class clazz : this.classes_resources) {
            try {
                return this.createImageFromInputStream(clazz.getResourceAsStream(res_name));
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public IImage getImage(String name) {
        String real_name;
        IImage img;
        IImage iImage = img = this.imagePool != null ? (IImage)this.imagePool.get(name) : null;
        if (img != null) {
            return img;
        }
        try {
            URL url = new URL(name);
            InputStream is = url.openStream();
            try {
                img = this.createImageFromInputStream(is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception exception) {}
        if (img == null) {
            img = this.getImageFromClassResources(name);
        }
        if (img == null && (real_name = this.searchImage(name)) != null) {
            img = this.createImageFromFile(real_name);
        }
        if (img == null) {
            try {
                img = this.createImageFromFile(name);
            }
            catch (Exception exception) {}
        }
        if (img == null) {
            img = this.getBrokenImage();
        }
        if (this.imagePool == null) {
            this.imagePool = new Hashtable();
        }
        this.imagePool.put(name, img);
        return img;
    }

    public IImage takeImage(String name) {
        if (name == null || this.imagePool == null) {
            return null;
        }
        IImage img = (IImage)this.imagePool.remove(name);
        return img;
    }

    public String searchImage(String ip) {
        if (this.search_path == null) {
            return null;
        }
        String retval = null;
        int i = 0;
        while (i < this.search_path.size()) {
            String si = this.search_path.get(i) + File.separator + ip;
            File f = new File(si);
            if (f.exists()) {
                retval = si;
                break;
            }
            ++i;
        }
        return retval;
    }

    public void dispose() {
        if (this.imagePool != null) {
            Enumeration e = this.imagePool.elements();
            while (e.hasMoreElements()) {
                IImage img = (IImage)e.nextElement();
                if (img == null || img == this.brokenImage) continue;
                this.disposeImage(img);
                Object var2_2 = null;
            }
            this.imagePool.clear();
            this.imagePool = null;
        }
        if (this.brokenImage != null) {
            this.disposeImage(this.brokenImage);
            this.brokenImage = null;
        }
    }

    public void clear() {
        this.dispose();
        this.search_path.clear();
        this.search_path = null;
        this.classes_resources.clear();
        this.classes_resources = null;
    }

    public void setImageSearchPath(String[] paths) {
        if (this.search_path == null) {
            this.search_path = new ArrayList();
        }
        this.search_path.clear();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                this.addImageSearchPath(paths[i]);
                ++i;
            }
        }
    }

    public void clearImageSearchPath() {
        this.search_path.clear();
        this.search_path = null;
    }

    public void addImageSearchPath(String path) {
        if (path == null) {
            return;
        }
        if (this.search_path == null) {
            this.search_path = new ArrayList();
        } else {
            for (String p : this.search_path) {
                if (!path.equals(p)) continue;
                return;
            }
        }
        this.search_path.add(path);
    }

    public void removeImageSearchPath(String path) {
        if (path == null || this.search_path == null) {
            return;
        }
        this.search_path.remove(path);
    }

    public void addResourceClass(Class c) {
        if (c == null) {
            return;
        }
        if (this.classes_resources == null) {
            this.classes_resources = new ArrayList();
        } else {
            for (Class clazz : this.classes_resources) {
                if (c != clazz) continue;
                return;
            }
        }
        this.classes_resources.add(c);
    }

    public boolean removeResourceClass(Class c) {
        if (this.classes_resources == null) {
            return false;
        }
        return this.classes_resources.remove(c);
    }

    public void setImage(String name, IImage image) {
        this.imagePool.put(name, image);
    }
}

