/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.w3c.dom.Node;

public class DAlignment
implements IDAlignment,
IDXmlSerializable {
    protected int align_;
    private static String[] bits_name = new String[]{"LEFT", "RIGHT", "HCENTER", "TOP", "BOTTOM", "VCENTER", "VERTICAL", "ROTCCW90", "ROTCW90"};

    public DAlignment() {
        this.align_ = 9;
    }

    public DAlignment(int _align) {
        this.align_ = _align;
    }

    public DAlignment(DAlignment _align) {
        this.align_ = _align.getAlignment();
    }

    public int getAlignment() {
        return this.align_;
    }

    public int getAlignment(int _alignment_mask) {
        return this.align_ & _alignment_mask;
    }

    public void setAlignment(int _align) {
        this.align_ = _align;
    }

    public void addAlignment(int _align) {
        this.align_ |= _align;
    }

    public void removeAlignment(int _align) {
        this.align_ &= ~_align;
    }

    public boolean haveAlignment(int _alignment) {
        return (this.getAlignment() & _alignment) == _alignment;
    }

    public boolean haveOneOfAlignment(int _alignment) {
        return (this.getAlignment() & _alignment) != 0;
    }

    public static String AlignmentToString(int a) {
        String s = null;
        int bit = 0;
        int mask = 1;
        while (mask <= 256) {
            if (DAlignment.HaveAlignment(a, mask)) {
                s = s == null ? bits_name[bit] : String.valueOf(s) + "|" + bits_name[bit];
            }
            ++bit;
            mask <<= 1;
        }
        return s;
    }

    public static int StringToAlignment(String s) {
        int align = 0;
        String[] list = s.split("\\|");
        int i = 0;
        while (i < list.length) {
            String al = list[i];
            int b = 0;
            while (b < bits_name.length) {
                if (bits_name[b].compareTo(al) == 0) {
                    align |= 1 << b;
                }
                ++b;
            }
            ++i;
        }
        return align;
    }

    public static boolean HaveAlignment(int _alignment, int _mask) {
        return (_alignment & _mask) == _mask;
    }

    public static int AddAlignment(int _alignment, int _add_alignment) {
        return _alignment | _add_alignment;
    }

    public static int RemoveAlignment(int _alignment, int _remove_alignment) {
        return _alignment & ~_remove_alignment;
    }

    public String writeXml() {
        return DAlignment.AlignmentToString(this.align_);
    }

    public void readXml(Node node) {
        int align = DAlignment.StringToAlignment(DXmlReader.getNodeText(node));
        this.setAlignment(align);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DAlignment)) {
            return false;
        }
        DAlignment oa = (DAlignment)o;
        return oa.align_ == this.align_;
    }
}

