/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.chart.internal.DXYSurface;
import org.eclipse.tptp.platform.report.chart.internal.IXYSurfaceColorizer;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DItemContainer;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;
import org.eclipse.tptp.platform.report.tools.internal.IPalette;
import org.eclipse.tptp.platform.report.tools.internal.Palette;

public class DChartCreator {
    public static final int W_DEFAULT = 0;
    public static final int W_NONE = 1;
    public static final int W_TOP_LEFT = 2;
    public static final int W_TOP_CENTER = 3;
    public static final int W_TOP_RIGHT = 4;
    public static final int W_LEFT_TOP = 5;
    public static final int W_LEFT_CENTER = 6;
    public static final int W_LEFT_BOTTOM = 7;
    public static final int W_RIGHT_TOP = 8;
    public static final int W_RIGHT_CENTER = 9;
    public static final int W_RIGHT_BOTTOM = 10;
    public static final int W_BOTTOM_LEFT = 11;
    public static final int W_BOTTOM_CENTER = 12;
    public static final int W_BOTTOM_RIGHT = 13;

    public static DGraphic Histogram(String title, double[] values) {
        return DChartCreator.Histogram(title, values, true, false, Palette.PAL_DEFAULT);
    }

    public static DGraphic Histogram(String title, double[] values, boolean _3d, boolean _thinbar) {
        return DChartCreator.Histogram(title, values, _3d, _thinbar, Palette.PAL_DEFAULT);
    }

    public static DGraphic Histogram(String title, double[] values, boolean _3d, boolean _thinbar, IPalette palette) {
        DGraphic g = DChartCreator.OneAxisChart("T_HISTOGRAM.DGraphic.core.jscrib", title, null, new double[][]{values}, palette);
        if (_3d) {
            g.getProperties().store("P_3D.DGraphic.core.jscrib", true);
        }
        if (_thinbar) {
            g.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
        }
        return g;
    }

    public static DGraphic Histogram(String title, String[] names, double[][] values, boolean _3d, boolean _thinbar, IPalette pal) {
        DGraphic g = DChartCreator.OneAxisChart("T_HISTOGRAM_IM.DGraphic.core.jscrib", title, names, values, pal);
        if (_3d) {
            g.getProperties().store("P_3D.DGraphic.core.jscrib", true);
        }
        if (_thinbar) {
            g.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
        }
        return g;
    }

    public static DGraphic StackBars(String title, String[] names, double[][] values, boolean _3d, boolean _thinbar, IPalette pal) {
        if (pal == null) {
            pal = Palette.PAL_DEFAULT;
        }
        DGraphic g = new DGraphic();
        g.setTitle(title);
        g.setRenderableId("T_STACKBARS.DGraphic.core.jscrib");
        if (_3d) {
            g.getProperties().store("P_3D.DGraphic.core.jscrib", true);
        }
        if (_thinbar) {
            g.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
        }
        DAxis axis = new DAxis("v");
        g.addChild(axis);
        if (names == null) {
            g.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", false);
        }
        DItemContainer last_g_child = axis;
        int nc = pal.getNumColors();
        int nbar = 0;
        int icrv = 0;
        while (icrv < values.length) {
            int size = values[icrv].length;
            if (size > nbar) {
                nbar = size;
            }
            ++icrv;
        }
        double[] stacked_value = new double[nbar];
        int icrv2 = 0;
        while (icrv2 < values.length) {
            DCurve crv = new DCurve();
            if (names != null) {
                crv.setName(names[icrv2]);
            }
            DStyle s_crv = new DStyle();
            crv.setStyle(s_crv);
            g.insertChild(crv, last_g_child);
            last_g_child = crv;
            s_crv.setBackColor(pal.getColor(icrv2 % nc));
            int size = values[icrv2].length;
            DPoint last_p = null;
            int i = 0;
            while (i < size) {
                int n = i;
                stacked_value[n] = stacked_value[n] + values[icrv2][i];
                DPoint p = new DPoint();
                crv.insertChild(p, last_p);
                p.addChild(new DCoord(axis, values[icrv2][i]));
                if (values.length == 1) {
                    DStyle ps = new DStyle();
                    ps.setBackColor(pal.getColor(i % nc));
                    p.setStyle(ps);
                }
                last_p = p;
                ++i;
            }
            ++icrv2;
        }
        double min = stacked_value[0];
        double max = stacked_value[0];
        int ib = 1;
        while (ib < nbar) {
            if (stacked_value[ib] < min) {
                min = stacked_value[ib];
            } else if (stacked_value[ib] > max) {
                max = stacked_value[ib];
            }
            ++ib;
        }
        min = min >= 0.0 ? 0.0 : (min *= 1.1);
        if (max != 0.0) {
            if (max == min) {
                max *= 1.1;
            }
        } else {
            max = min + 1.0;
        }
        int m = 1;
        if (min < 0.0 && max > 0.0) {
            m = 2;
        }
        DPropertyStore props = axis.getProperties();
        props.store("P_MIN.DAxis.core.jscrib", min);
        props.store("P_MAX.DAxis.core.jscrib", max);
        props.store("P_STEP_LINE.DAxis.core.jscrib", (max - min) / (double)(4 * m));
        props.store("P_STEP_UNIT.DAxis.core.jscrib", (max - min) / (double)(4 * m));
        props.store("P_STEP_DOT.DAxis.core.jscrib", (max - min) / (double)(10 * m));
        return g;
    }

    public static DGraphic PieChart(String title, double[] values, boolean _3d, IPalette palette) {
        return DChartCreator.PieChart(title, null, values, _3d, palette);
    }

    public static DGraphic PieChart(String title, double[] values) {
        return DChartCreator.PieChart(title, null, values, true, null);
    }

    public static DGraphic PieChart(String title, String[] names, double[] values, boolean _3d, IPalette palette) {
        Object nval = null;
        if (names != null) {
            nval = new double[values.length][];
            int i = 0;
            while (i < values.length) {
                nval[i] = new double[]{values[i]};
                ++i;
            }
        } else {
            nval = new double[][]{values};
        }
        return DChartCreator.OneAxisChart(_3d ? "T_SECTORS3D.DGraphic.core.jscrib" : "T_SECTORS.DGraphic.core.jscrib", title, names, nval, palette);
    }

    protected static DGraphic OneAxisChart(String type, String title, String[] curve_name, double[][] values, IPalette pal) {
        if (pal == null) {
            pal = Palette.PAL_DEFAULT;
        }
        DGraphic g = new DGraphic();
        g.setTitle(title);
        g.setRenderableId(type);
        DAxis axis = new DAxis("v");
        g.addChild(axis);
        if (curve_name == null) {
            g.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", false);
        }
        DItemContainer last_g_child = axis;
        int nc = pal.getNumColors();
        double min = 0.0;
        double max = 0.0;
        int icrv = 0;
        while (icrv < values.length) {
            DCurve crv = new DCurve();
            if (curve_name != null && icrv < curve_name.length) {
                crv.setName(curve_name[icrv]);
            }
            DStyle s_crv = new DStyle();
            crv.setStyle(s_crv);
            g.insertChild(crv, last_g_child);
            last_g_child = crv;
            s_crv.setBackColor(pal.getColor(icrv % nc));
            int size = values[icrv].length;
            DPoint last_p = null;
            int i = 0;
            while (i < size) {
                if (i == 0 && icrv == 0) {
                    min = max = values[icrv][i];
                } else if (values[icrv][i] < min) {
                    min = values[icrv][i];
                } else if (values[icrv][i] > max) {
                    max = values[icrv][i];
                }
                DPoint p = new DPoint();
                crv.insertChild(p, last_p);
                p.addChild(new DCoord(axis, values[icrv][i]));
                if (values.length == 1) {
                    DStyle ps = new DStyle();
                    ps.setBackColor(pal.getColor(i % nc));
                    p.setStyle(ps);
                }
                last_p = p;
                ++i;
            }
            ++icrv;
        }
        min = min >= 0.0 ? 0.0 : (min *= 1.1);
        max = max != 0.0 ? (max *= 1.1) : min + 1.0;
        int m = 1;
        if (min < 0.0 && max > 0.0) {
            m = 2;
        }
        DPropertyStore props = axis.getProperties();
        props.store("P_MIN.DAxis.core.jscrib", min);
        props.store("P_MAX.DAxis.core.jscrib", max);
        props.store("P_STEP_LINE.DAxis.core.jscrib", (max - min) / (double)(4 * m));
        props.store("P_STEP_UNIT.DAxis.core.jscrib", (max - min) / (double)(4 * m));
        props.store("P_STEP_DOT.DAxis.core.jscrib", (max - min) / (double)(10 * m));
        return g;
    }

    public static DGraphic XYCurvesOneX(String title, String[] curve_name, double[][] values, boolean use_symbol, IPalette pal) {
        return DChartCreator.XYCurves(title, curve_name, values, true, use_symbol, pal);
    }

    public static DGraphic XYCurves(String title, String[] curve_name, double[][] values, boolean one_x, boolean use_symbol, IPalette pal) {
        return DChartCreator.XYCurves(title, curve_name, values, one_x, use_symbol, false, false, pal);
    }

    public static DGraphic XYArea(String title, String[] curve_name, double[][] values, boolean one_x, boolean use_symbol, IPalette pal) {
        return DChartCreator.XYCurves(title, curve_name, values, one_x, use_symbol, true, false, pal);
    }

    public static DGraphic XYStackedArea(String title, String[] curve_name, double[][] values, boolean one_x, boolean use_symbol, IPalette pal) {
        return DChartCreator.XYCurves(title, curve_name, values, one_x, use_symbol, true, true, pal);
    }

    public static DGraphic XYCurves(String title, String[] curve_name, double[][] values, boolean one_x, boolean use_symbol, boolean use_area, boolean use_stacked, IPalette pal) {
        if (curve_name == null && values == null) {
            return null;
        }
        if (pal == null) {
            pal = Palette.PAL_DEFAULT;
        }
        DGraphic g = new DGraphic();
        g.setTitle(title);
        g.setRenderableId("T_XY.DGraphic.core.jscrib");
        DAxis x_axis = new DAxis("x");
        DAxis y_axis = new DAxis("y");
        g.addChild(x_axis);
        g.addChild(y_axis);
        if (curve_name == null) {
            g.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", false);
        }
        DItemContainer last_g_child = y_axis;
        int nc = pal.getNumColors();
        double x_min = 0.0;
        double x_max = 0.0;
        double y_min = 0.0;
        double y_max = 0.0;
        boolean init_minmax = true;
        int n_curve = one_x ? values.length - 1 : values.length / 2;
        n_curve = n_curve;
        String curve_type = "LINE.DCurve.core.jscrib";
        curve_type = use_stacked ? (use_area ? (use_symbol ? "STACKED_AREA_LINE_POINTS.DCurve.core.jscrib" : "STACKED_AREA_LINE.DCurve.core.jscrib") : (use_symbol ? "STACKED_LINE_POINTS.DCurve.core.jscrib" : "STACKED_LINE.DCurve.core.jscrib")) : (use_area ? (use_symbol ? "AREA_LINE_POINTS.DCurve.core.jscrib" : "AREA_LINE.DCurve.core.jscrib") : (use_symbol ? "LINE_POINT.DCurve.core.jscrib" : "LINE.DCurve.core.jscrib"));
        int icrv = 0;
        while (icrv < n_curve) {
            int size_y;
            int size_x;
            int ix = one_x ? 0 : 2 * icrv;
            int iy = one_x ? icrv + 1 : ix + 1;
            DCurve crv = new DCurve();
            if (curve_name != null && icrv < curve_name.length) {
                crv.setName(curve_name[icrv]);
            }
            DStyle s_crv = new DStyle();
            crv.setStyle(s_crv);
            g.insertChild(crv, last_g_child);
            last_g_child = crv;
            s_crv.setBackColor(pal.getColor(icrv % nc));
            crv.setType(curve_type);
            if (use_symbol) {
                crv.getProperties().store("SYMBOL.DCurve.core.jscrib", DChartCreator.GetSymbolId(icrv));
            }
            int size = (size_x = values[ix].length) < (size_y = values[iy].length) ? size_x : size_y;
            DPoint last_p = null;
            int i = 0;
            while (i < size) {
                double vx = values[ix][i];
                double vy = values[iy][i];
                if (init_minmax) {
                    x_min = x_max = vx;
                    y_min = y_max = vy;
                    init_minmax = false;
                } else {
                    if (vx < x_min) {
                        x_min = vx;
                    } else if (vx > x_max) {
                        x_max = vx;
                    }
                    if (vy < y_min) {
                        y_min = vy;
                    } else if (vy > y_max) {
                        y_max = vy;
                    }
                }
                DPoint p = new DPoint();
                crv.insertChild(p, last_p);
                p.addChild(new DCoord(x_axis, vx));
                p.addChild(new DCoord(y_axis, vy));
                last_p = p;
                ++i;
            }
            ++icrv;
        }
        if (x_min == x_max) {
            if (x_min == 0.0) {
                x_min = -1.0;
                x_max = 1.0;
            } else {
                x_min *= 0.9;
                x_max *= 1.1;
            }
        }
        x_axis.getProperties().store("P_MIN.DAxis.core.jscrib", x_min);
        x_axis.getProperties().store("P_MAX.DAxis.core.jscrib", x_max);
        x_axis.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", 0.125 * (x_max - x_min));
        x_axis.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 0.25 * (x_max - x_min));
        if (!use_stacked) {
            if (y_min == y_max) {
                if (y_min == 0.0) {
                    y_min = -1.0;
                    y_max = 1.0;
                } else {
                    y_min *= 0.9;
                    y_max *= 1.1;
                }
            }
            y_axis.getProperties().store("P_MIN.DAxis.core.jscrib", y_min);
            y_axis.getProperties().store("P_MAX.DAxis.core.jscrib", y_max);
            y_axis.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", 0.125 * (y_max - y_min));
            y_axis.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 0.25 * (y_max - y_min));
        }
        return g;
    }

    private static String GetSymbolId(int index) {
        switch (index %= 13) {
            case 0: {
                return DSymbolRegistry.GetSquare().getId();
            }
            case 1: {
                return DSymbolRegistry.GetOval().getId();
            }
            case 2: {
                return DSymbolRegistry.GetUp().getId();
            }
            case 3: {
                return DSymbolRegistry.GetDown().getId();
            }
            case 4: {
                return DSymbolRegistry.GetLeft().getId();
            }
            case 5: {
                return DSymbolRegistry.GetRight().getId();
            }
            case 6: {
                return DSymbolRegistry.GetPlus().getId();
            }
            case 7: {
                return DSymbolRegistry.GetMinus().getId();
            }
            case 8: {
                return DSymbolRegistry.GetDiamond().getId();
            }
            case 9: {
                return DSymbolRegistry.GetMoonDown().getId();
            }
            case 10: {
                return DSymbolRegistry.GetMoonUp().getId();
            }
            case 11: {
                return DSymbolRegistry.GetMoonLeft().getId();
            }
            case 12: {
                return DSymbolRegistry.GetMoonRight().getId();
            }
        }
        return null;
    }

    public static DGraphic XYZCurves(String title, String[] curve_name, double[][] values, IPalette pal) {
        if (curve_name == null && values == null) {
            return null;
        }
        if (pal == null) {
            pal = Palette.PAL_DEFAULT;
        }
        DGraphic g = new DGraphic();
        g.setTitle(title);
        g.setRenderableId("T_XYZ.DGraphic.core.jscrib");
        DAxis x_axis = new DAxis("x");
        DAxis y_axis = new DAxis("y");
        DAxis z_axis = new DAxis("z");
        g.addChild(x_axis);
        g.addChild(y_axis);
        g.addChild(z_axis);
        if (curve_name == null) {
            g.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", false);
        }
        DItemContainer last_g_child = z_axis;
        int nc = pal.getNumColors();
        double x_min = 0.0;
        double x_max = 0.0;
        double y_min = 0.0;
        double y_max = 0.0;
        double z_min = 0.0;
        double z_max = 0.0;
        boolean init_minmax = true;
        int n_curve = values.length / 3;
        int icrv = 0;
        while (icrv < n_curve) {
            int ix = 3 * icrv;
            int iy = ix + 1;
            int iz = iy + 1;
            DCurve crv = new DCurve();
            if (curve_name != null && icrv < curve_name.length) {
                crv.setName(curve_name[icrv]);
            }
            DStyle s_crv = new DStyle();
            crv.setStyle(s_crv);
            g.insertChild(crv, last_g_child);
            last_g_child = crv;
            s_crv.setBackColor(pal.getColor(icrv % nc));
            crv.setType("LINE.DCurve.core.jscrib");
            int size_x = values[ix].length;
            int size_y = values[iy].length;
            int size_z = values[iz].length;
            int size = Math.min(size_x, Math.min(size_y, size_z));
            DPoint last_p = null;
            int i = 0;
            while (i < size) {
                double vx = values[ix][i];
                double vy = values[iy][i];
                double vz = values[iz][i];
                if (init_minmax) {
                    x_min = x_max = vx;
                    y_min = y_max = vy;
                    z_min = z_max = vz;
                    init_minmax = false;
                } else {
                    if (vx < x_min) {
                        x_min = vx;
                    } else if (vx > x_max) {
                        x_max = vx;
                    }
                    if (vy < y_min) {
                        y_min = vy;
                    } else if (vy > y_max) {
                        y_max = vy;
                    }
                    if (vz < z_min) {
                        z_min = vz;
                    } else if (vz > z_max) {
                        z_max = vz;
                    }
                }
                DPoint p = new DPoint();
                crv.insertChild(p, last_p);
                p.addChild(new DCoord(x_axis, vx));
                p.addChild(new DCoord(y_axis, vy));
                p.addChild(new DCoord(z_axis, vz));
                last_p = p;
                ++i;
            }
            ++icrv;
        }
        if (x_min == x_max) {
            if (x_min == 0.0) {
                x_min = -1.0;
                x_max = 1.0;
            } else {
                x_min *= 0.9;
                x_max *= 1.1;
            }
        }
        if (y_min == y_max) {
            if (y_min == 0.0) {
                y_min = -1.0;
                y_max = 1.0;
            } else {
                y_min *= 0.9;
                y_max *= 1.1;
            }
        }
        if (z_min == z_max) {
            if (z_min == 0.0) {
                z_min = -1.0;
                z_max = 1.0;
            } else {
                z_min *= 0.9;
                z_max *= 1.1;
            }
        }
        x_axis.getProperties().store("P_MIN.DAxis.core.jscrib", x_min);
        x_axis.getProperties().store("P_MAX.DAxis.core.jscrib", x_max);
        y_axis.getProperties().store("P_MIN.DAxis.core.jscrib", y_min);
        y_axis.getProperties().store("P_MIN.DAxis.core.jscrib", y_min);
        z_axis.getProperties().store("P_MAX.DAxis.core.jscrib", z_max);
        z_axis.getProperties().store("P_MAX.DAxis.core.jscrib", z_max);
        x_axis.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", 0.125 * (x_max - x_min));
        y_axis.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", 0.125 * (y_max - y_min));
        z_axis.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", 0.125 * (z_max - z_min));
        x_axis.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 0.25 * (x_max - x_min));
        y_axis.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 0.25 * (y_max - y_min));
        z_axis.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 0.25 * (z_max - z_min));
        return g;
    }

    public static int encodeColor(DColor _color) {
        int r = _color.getRed();
        int g = _color.getGreen();
        int b = _color.getBlue();
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static DGraphic Meter(String title, String axis_title, double value) {
        return DChartCreator.Meter(title, axis_title, value, 0.0, 0.0, null, null, null);
    }

    public static DGraphic Meter(String title, String axis_title, double value, double min, double max) {
        return DChartCreator.Meter(title, axis_title, value, min, max, null, null, null);
    }

    public static DGraphic Meter(String title, String axis_title, double value, double min, double max, double[] regions, String[] regions_names, IPalette palette) {
        if (palette == null) {
            palette = Palette.PAL_DEFAULT;
        }
        DGraphic g = new DGraphic();
        g.setTitle(title);
        g.setRenderableId("T_METER.DGraphic.core.jscrib");
        DAxis axis = new DAxis("v");
        axis.setTitle(axis_title);
        g.addChild(axis);
        g.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", false);
        DCurve cneedle = new DCurve();
        g.addChild(cneedle);
        DPoint needle = new DPoint();
        cneedle.addChild(needle);
        needle.addChild(new DCoord(axis, value));
        double max_region_value = value;
        boolean have_max_region_value = false;
        if (regions != null && regions.length > 0) {
            DCurve last = cneedle;
            int i = 0;
            while (i < regions.length) {
                DCurve cregion = new DCurve();
                if (regions_names != null && i < regions_names.length) {
                    cregion.setName(regions_names[i]);
                }
                DPoint pregion = new DPoint();
                cregion.addChild(pregion);
                pregion.addChild(new DCoord(axis, regions[i]));
                g.insertChild(cregion, last);
                last = cregion;
                DStyle sty = new DStyle();
                sty.setBackColor(palette.getColor(i));
                cregion.setStyle(sty);
                if (regions[i] > max_region_value) {
                    max_region_value = regions[i];
                    have_max_region_value = true;
                }
                ++i;
            }
        }
        boolean default_minmax = false;
        if (min == max) {
            if (value < 0.0 || value > 100.0) {
                min = 0.9 * value;
                max = 1.1 * value;
            } else {
                default_minmax = true;
            }
        } else {
            if (value < min) {
                min = 0.9 * value;
            }
            if (value > max) {
                max = 1.1 * value;
            }
        }
        if (have_max_region_value && max_region_value > max) {
            max = max_region_value;
        }
        if (!default_minmax) {
            axis.getProperties().store("P_MIN.DAxis.core.jscrib", min);
            axis.getProperties().store("P_MAX.DAxis.core.jscrib", max);
        } else {
            min = 0.0;
            max = 100.0;
        }
        axis.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", 0.1 * (max - min));
        axis.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 0.25 * (max - min));
        return g;
    }

    public static void ConfigureTitle(DGraphic _graphic, int _where) {
        if (_graphic == null) {
            return;
        }
        _graphic.getProperties().remove("P_SHOW_TITLED.DGraphic.core.jscrib");
        _graphic.getProperties().remove("P_TITLE_LAYOUT.DGraphic.core.jscrib");
        switch (_where) {
            case 0: {
                break;
            }
            case 1: {
                _graphic.getProperties().store("P_SHOW_TITLED.DGraphic.core.jscrib", false);
                break;
            }
            default: {
                _graphic.getProperties().store("P_TITLE_LAYOUT.DGraphic.core.jscrib", DChartCreator.ToAlignmentPair(_where, true));
            }
        }
    }

    public static void ConfigureLegend(DGraphic _graphic, int _where) {
        if (_graphic == null) {
            return;
        }
        _graphic.getProperties().remove("P_SHOW_LEGEND.DGraphic.core.jscrib");
        _graphic.getProperties().remove("P_LEGEND_LAYOUT.DGraphic.core.jscrib");
        switch (_where) {
            case 0: {
                break;
            }
            case 1: {
                _graphic.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", false);
                break;
            }
            default: {
                _graphic.getProperties().store("P_LEGEND_LAYOUT.DGraphic.core.jscrib", DChartCreator.ToAlignmentPair(_where, false));
            }
        }
    }

    private static DAlignmentPair ToAlignmentPair(int _where, boolean _rot) {
        switch (_where) {
            default: {
                return new DAlignmentPair(8, 1);
            }
            case 3: {
                return new DAlignmentPair(8, 36);
            }
            case 4: {
                return new DAlignmentPair(8, 2);
            }
            case 5: {
                return new DAlignmentPair(1, 8 | (_rot ? 128 : 0));
            }
            case 6: {
                return new DAlignmentPair(1, 0x24 | (_rot ? 128 : 0));
            }
            case 7: {
                return new DAlignmentPair(1, 0x10 | (_rot ? 128 : 0));
            }
            case 8: {
                return new DAlignmentPair(2, 8 | (_rot ? 256 : 0));
            }
            case 9: {
                return new DAlignmentPair(2, 0x24 | (_rot ? 256 : 0));
            }
            case 10: {
                return new DAlignmentPair(2, 0x10 | (_rot ? 256 : 0));
            }
            case 11: {
                return new DAlignmentPair(16, 1);
            }
            case 12: {
                return new DAlignmentPair(16, 36);
            }
            case 13: 
        }
        return new DAlignmentPair(16, 2);
    }

    public static DGraphic Series3D(String title, String[] names, double[][] values, boolean _thinbar, IPalette pal, String curve_type) {
        if (pal == null) {
            pal = Palette.PAL_DEFAULT;
        }
        if (values.length == 1) {
            pal = new Palette(pal.getColor(0));
        }
        DGraphic g = DChartCreator.OneAxisChart("T_SERIES3D.DGraphic.core.jscrib", title, names, values, pal);
        if (!_thinbar) {
            g.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", false);
        }
        if (curve_type != null && !"LINE.DCurve.core.jscrib".equals(curve_type)) {
            IDItem it = g.getFirstChild();
            while (it != null) {
                if (it instanceof DCurve) {
                    ((DCurve)it).setType(curve_type);
                }
                it = it.getNext();
            }
        }
        return g;
    }

    public static DGraphic Series3D(String title, String name, double[] values, boolean _thinbar, IPalette pal, String curve_type) {
        if (pal == null) {
            pal = Palette.PAL_DEFAULT;
        }
        pal = new Palette(pal.getColor(0));
        DGraphic g = DChartCreator.OneAxisChart("T_SERIES3D.DGraphic.core.jscrib", title, new String[]{name}, new double[][]{values}, pal);
        if (!_thinbar) {
            g.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", false);
        }
        if (curve_type != null && !"LINE.DCurve.core.jscrib".equals(curve_type)) {
            IDItem it = g.getFirstChild();
            while (it != null) {
                if (it instanceof DCurve) {
                    ((DCurve)it).setType(curve_type);
                }
                it = it.getNext();
            }
        }
        return g;
    }

    public static void Series3DAddCurve(DGraphic graphic, String name, double[] values, IPalette pal, String curve_type) {
        if (graphic == null) {
            return;
        }
        int ncurve = 0;
        DAxis gaxis = null;
        IDItem it = graphic.getFirstChild();
        while (it != null) {
            if (it instanceof DAxis) {
                gaxis = (DAxis)it;
            } else if (it instanceof DCurve) {
                ++ncurve;
            }
            it = it.getNext();
        }
        if (pal == null) {
            pal = Palette.PAL_DEFAULT;
        }
        pal = new Palette(pal.getColor(ncurve));
        DGraphic g = DChartCreator.OneAxisChart("T_SERIES3D.DGraphic.core.jscrib", null, new String[]{name}, new double[][]{values}, pal);
        DItem curve = null;
        DAxis axis = null;
        IDItem it2 = g.getFirstChild();
        while (it2 != null) {
            if (curve == null && it2 instanceof DCurve) {
                curve = (DCurve)it2;
                ((DCurve)curve).setType(curve_type);
            } else if (axis == null && it2 instanceof DAxis) {
                axis = (DAxis)it2;
            }
            it2 = it2.getNext();
        }
        graphic.addChild(curve);
        curve.setParent(graphic);
        ((DCurve)curve).setType(curve_type);
        it2 = ((DItemContainer)curve).getFirstChild();
        while (it2 != null) {
            if (it2 instanceof DPoint) {
                IDItem ic = it2.getFirstChild();
                while (ic != null) {
                    if (ic instanceof IDCoord) {
                        ((IDCoord)((Object)ic)).setAxis(gaxis);
                    }
                    ic = ic.getNext();
                }
            }
            it2 = it2.getNext();
        }
        DPropertyStore p1 = axis.getProperties();
        DPropertyStore p2 = gaxis.getProperties();
        double min = Math.min(p1.get("P_MIN.DAxis.core.jscrib", 0.0), 1.1 * p2.get("P_MIN.DAxis.core.jscrib", 0.0));
        double max = Math.max(p1.get("P_MAX.DAxis.core.jscrib", 0.0), 1.1 * p2.get("P_MAX.DAxis.core.jscrib", 0.0));
        if (min >= 0.0) {
            min = 0.0;
        }
        if (max == 0.0) {
            max = min + 1.0;
        }
        int m = 1;
        if (min < 0.0 && max > 0.0) {
            m = 2;
        }
        p2.store("P_MIN.DAxis.core.jscrib", min);
        p2.store("P_MAX.DAxis.core.jscrib", max);
        p2.store("P_STEP_LINE.DAxis.core.jscrib", (max - min) / (double)(4 * m));
        p2.store("P_STEP_UNIT.DAxis.core.jscrib", (max - min) / (double)(4 * m));
        p2.store("P_STEP_DOT.DAxis.core.jscrib", (max - min) / (double)(10 * m));
    }

    public static DGraphic Pie3D(String title, double[] values, IPalette pal) {
        DGraphic g = DChartCreator.OneAxisChart("T_PIE3D.DGraphic.core.jscrib", title, null, new double[][]{values}, pal);
        return g;
    }

    public static DGraphic Pie3D(String title, String[] names, double[] values, boolean[] shifted, IPalette pal) {
        return DChartCreator.Pie3D(title, names, values, shifted, pal, true);
    }

    public static DGraphic Torus3D(String title, double[] values, IPalette pal) {
        DGraphic g = DChartCreator.OneAxisChart("T_TORUS3D.DGraphic.core.jscrib", title, null, new double[][]{values}, pal);
        return g;
    }

    public static DGraphic Torus3D(String title, String[] names, double[] values, boolean[] shifted, IPalette pal) {
        return DChartCreator.Pie3D(title, names, values, shifted, pal, false);
    }

    private static DGraphic Pie3D(String title, String[] names, double[] values, boolean[] shifted, IPalette pal, boolean pie3D) {
        if (shifted == null && names == null) {
            return DChartCreator.Pie3D(title, values, pal);
        }
        double[][] val = new double[values.length][1];
        int i = 0;
        while (i < values.length) {
            val[i][0] = values[i];
            ++i;
        }
        DGraphic g = DChartCreator.OneAxisChart(pie3D ? "T_PIE3D.DGraphic.core.jscrib" : "T_TORUS3D.DGraphic.core.jscrib", title, names, val, pal);
        IDItem it = g.getFirstChild();
        while (it != null && !(it instanceof DCurve)) {
            it = it.getNext();
        }
        if (it != null) {
            int i2 = 0;
            while (i2 < shifted.length) {
                if (shifted[i2]) {
                    ((DCurve)it).getProperties().store("SHIFT_SECTOR.DCurve.core.jscrib", 0.3f);
                }
                it = it.getNext();
                while (it != null && !(it instanceof DCurve)) {
                    it = it.getNext();
                }
                if (it == null) break;
                ++i2;
            }
        }
        return g;
    }

    public static DGraphic XYSurface(String title, int sizex, int sizey, double[] values, boolean z_axis, IXYSurfaceColorizer clr) {
        DGraphic gph = new DGraphic();
        gph.setRenderableId("T_XY_SURFACE.DGraphic.core.jscrib");
        gph.setTitle(title);
        if (clr != null) {
            gph.getProperties().store("P_XYS_COLORIZER.DGraphic.core.jscrib", clr);
        }
        DXYSurface surf = new DXYSurface(sizex, sizey, values, 0.0, 0.0);
        surf.updateZMinMax();
        gph.addChild(surf);
        if (z_axis) {
            DAxis axis = new DAxis("z");
            gph.addChild(axis);
            DPropertyStore store = axis.getProperties();
            store.store("P_MIN.DAxis.core.jscrib", surf.getZMin());
            store.store("P_MAX.DAxis.core.jscrib", surf.getZMin());
            store.store("P_STEP_UNIT.DAxis.core.jscrib", (surf.getZMax() - surf.getZMin()) / 4.0);
            store.store("P_STEP_DOT.DAxis.core.jscrib", (surf.getZMax() - surf.getZMin()) / 10.0);
        }
        return gph;
    }

    public static void XYSurfaceContour(DGraphic gph, double delta_z, int rgba) {
        if (gph == null) {
            return;
        }
        if (!gph.isRenderableId("T_XY_SURFACE.DGraphic.core.jscrib")) {
            return;
        }
        gph.getProperties().store("P_XYS_CONTOUR_LINE.DGraphic.core.jscrib", delta_z);
        gph.getProperties().store("P_XYS_CONTOUR_LINE_COLOR.DGraphic.core.jscrib", rgba);
    }

    public static void XYSurfaceContour(DGraphic gph, double delta_z, IDColor clr) {
        if (gph == null) {
            return;
        }
        if (!gph.isRenderableId("T_XY_SURFACE.DGraphic.core.jscrib")) {
            return;
        }
        gph.getProperties().store("P_XYS_CONTOUR_LINE.DGraphic.core.jscrib", delta_z);
        gph.getProperties().store("P_XYS_CONTOUR_LINE_COLOR.DGraphic.core.jscrib", clr);
    }

    public static void XYSurfaceContour(DGraphic gph, double delta_z, IXYSurfaceColorizer clr) {
        if (gph == null) {
            return;
        }
        if (!gph.isRenderableId("T_XY_SURFACE.DGraphic.core.jscrib")) {
            return;
        }
        gph.getProperties().store("P_XYS_CONTOUR_LINE.DGraphic.core.jscrib", delta_z);
        gph.getProperties().store("P_XYS_CONTOUR_LINE_COLOR.DGraphic.core.jscrib", clr);
    }
}

