/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import com.ibm.icu.text.UFormat;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider;

public class DResultSetContentProvider
implements IDTableContentProvider {
    ResultSet content;
    UFormat[] formats;

    public DResultSetContentProvider(ResultSet rset) {
        this.setContent(rset);
    }

    public int getColumnCount() {
        try {
            ResultSetMetaData rsmd = this.content.getMetaData();
            return rsmd.getColumnCount();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getRowCount() {
        try {
            this.content.last();
            return this.content.getRow();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public String getText(int row, int column) {
        try {
            this.content.getMetaData();
            this.content.absolute(row + 1);
            if (this.formats[column] != null) {
                return this.formats[column].format(this.content.getObject(column));
            }
            return this.content.getObject(column).toString();
        }
        catch (SQLException sQLException) {
            return "SQLException: e.getMessage()";
        }
    }

    public ResultSet getContent() {
        return this.content;
    }

    public void setContent(ResultSet content) {
        this.content = content;
        this.formats = new UFormat[this.getColumnCount()];
    }

    public void setColumnFormat(int column, UFormat f) {
        this.formats[column] = f;
    }
}

