/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.tptp.platform.report.core.internal.DChildrenController;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

public class DStackCreator {
    private IDItem current;
    private IDItem last_child;
    private Stack parents;

    public IDItem get() {
        return this.current;
    }

    public IDItem getTop() {
        if (this.parents != null && !this.parents.empty() && ((Parent)this.parents.lastElement()).getCurrent() != null) {
            return ((Parent)this.parents.lastElement()).getCurrent();
        }
        return this.current;
    }

    public IDItem getLast() {
        return this.last_child;
    }

    public IDItem push(IDItem a) {
        if (a == null) {
            System.err.println(this.getClass() + ": push(null)");
            throw new Error();
        }
        if (this.parents == null) {
            this.parents = new Stack();
        } else {
            this.add(a);
        }
        this.parents.push(new Parent(this.current, this.last_child));
        this.current = a;
        if (a.getFirstChild() == null) {
            this.last_child = null;
        }
        this.last_child = a.getFirstChild();
        while (this.last_child != null && this.last_child.getNext() != null) {
            this.last_child = this.last_child.getNext();
        }
        return a;
    }

    public IDItem pop() {
        Parent parent = null;
        try {
            parent = (Parent)this.parents.pop();
        }
        catch (EmptyStackException emptyStackException) {}
        if (parent == null) {
            System.err.println(this.getClass() + ": pop() = null");
            throw new Error();
        }
        this.current = parent.getCurrent();
        this.last_child = parent.getLastChild();
        return this.current;
    }

    public IDItem add(IDItem a) {
        if (this.current == null) {
            System.err.println(this.getClass() + ": add(IDItem) = null (no current IDItem; call push() before)");
            throw new Error();
        }
        if (!DChildrenController.acceptChild(this.current, a)) {
            System.err.println(this.getClass() + ": add(IDItem) = null (" + this.current.getClass().getName() + " does not accept " + a.getClass().getName() + " childs)");
            throw new Error();
        }
        if (this.last_child == null) {
            this.current.addChild(a);
        } else {
            this.current.insertChild(a, this.last_child);
        }
        this.last_child = a;
        return a;
    }

    private class Parent {
        private IDItem current;
        private IDItem last_child;

        public Parent(IDItem c, IDItem l) {
            this.current = c;
            this.last_child = l;
        }

        public IDItem getCurrent() {
            return this.current;
        }

        public IDItem getLastChild() {
            return this.last_child;
        }
    }
}

