/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.tools.internal.DStackCreator;
import org.eclipse.tptp.platform.report.tools.internal.IDTableContentProvider;

public class DTableCreator {
    public static final int FIRST_LEFT_OTHERS_RIGHT = 0;
    public static final int ALL_LEFT = 1;
    public static final int ALL_RIGHT = 2;

    public static DTable SimpleTable(IDTableContentProvider data, DStyle cellStyle) {
        DStyle[] rs = new DStyle[]{cellStyle};
        return DTableCreator.FreeAlignmentLinedTable(data, null, null, rs, null);
    }

    public static DTable TableWithHeader(IDTableContentProvider data, String[] header, DStyle headerStyle, DStyle cellStyle) {
        DStyle[] rs = new DStyle[]{cellStyle};
        return DTableCreator.FreeAlignmentLinedTable(data, header, headerStyle, rs, null);
    }

    public static DTable LinedTableWithAlignment(IDTableContentProvider data, String[] header, DStyle headerStyle, DStyle rowPaired, DStyle rowUnPaired, int colAlign) {
        DStyle[] rs = new DStyle[]{rowPaired, rowUnPaired};
        int[] colal = new int[data.getColumnCount()];
        switch (colAlign) {
            case 0: {
                colal[0] = 1;
                int i = 1;
                while (i < colal.length) {
                    colal[i] = 2;
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < colal.length) {
                    colal[i] = 2;
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < colal.length) {
                    colal[i] = 1;
                    ++i;
                }
                break;
            }
        }
        return DTableCreator.FreeAlignmentLinedTable(data, header, headerStyle, rs, colal);
    }

    public static DTable FreeAlignmentLinedTable(IDTableContentProvider data, String[] header, DStyle headerStyle, DStyle[] rowStyles, int[] colAlign) {
        int i;
        DStackCreator s = new DStackCreator();
        DTable table = new DTable();
        s.push(table);
        if (header != null) {
            s.push(new DRow());
            i = 0;
            while (i < header.length && i < data.getColumnCount()) {
                s.add(new DCellText(header[i]));
                if (headerStyle != null) {
                    s.getLast().setStyle(headerStyle);
                }
                ((DCellText)s.getLast()).setAlignment(36);
                ++i;
            }
            while (i < data.getColumnCount()) {
                s.add(new DCell());
                if (headerStyle != null) {
                    s.getLast().setStyle(headerStyle);
                }
                ((DCellText)s.getLast()).setAlignment(36);
                ++i;
            }
            s.pop();
        }
        i = 0;
        while (i < data.getRowCount()) {
            s.push(new DRow());
            int j = 0;
            while (j < data.getColumnCount()) {
                s.add(new DCellText(data.getText(i, j)));
                if (rowStyles != null) {
                    s.getLast().setStyle(rowStyles[i % rowStyles.length]);
                }
                if (colAlign != null) {
                    ((DCellText)s.getLast()).setAlignment(colAlign[j]);
                }
                ++j;
            }
            s.pop();
            ++i;
        }
        return table;
    }
}

