/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.tools.internal.IPalette;

public class FullGradientPalette
implements IPalette {
    int[] colors;

    public FullGradientPalette(int _num_colors) {
        this.colors = new int[_num_colors];
    }

    public void setGradient(int from_index, int from_color, int to_index, int to_color) {
        if (from_index < 0) {
            from_index = 0;
        } else if (from_index >= this.colors.length) {
            from_index = this.colors.length - 1;
        }
        if (to_index < from_index) {
            to_index = from_index;
        } else if (to_index >= this.colors.length) {
            to_index = this.colors.length - 1;
        }
        int r0 = from_color >> 16 & 0xFF;
        int g0 = from_color >> 8 & 0xFF;
        int b0 = from_color & 0xFF;
        int r1 = (to_color >> 16 & 0xFF) - r0;
        int g1 = (to_color >> 8 & 0xFF) - g0;
        int b1 = (to_color & 0xFF) - b0;
        double k = 1.0 / (double)(to_index - from_index);
        int i = from_index;
        while (i <= to_index) {
            int r = (int)((double)r0 + (double)((i - from_index) * r1) * k);
            int g = (int)((double)g0 + (double)((i - from_index) * g1) * k);
            int b = (int)((double)b0 + (double)((i - from_index) * b1) * k);
            this.colors[i] = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            ++i;
        }
    }

    public int getNumColors() {
        return this.colors.length;
    }

    public DColor getColor(int index) {
        int r = this.colors[index %= this.colors.length] >> 16 & 0xFF;
        int g = this.colors[index] >> 8 & 0xFF;
        int b = this.colors[index] & 0xFF;
        return new DColor(r, g, b);
    }

    public int getRGBA(int index) {
        int r = this.colors[index %= this.colors.length] >> 16 & 0xFF;
        int g = this.colors[index] >> 8 & 0xFF;
        int b = this.colors[index] & 0xFF;
        return RGBA.Get(r, g, b);
    }
}

