/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.tools.internal.IPalette;

public class Palette
implements IPalette {
    private static int R__ = 0xFF0000;
    private static int _G_ = 65280;
    private static int __B = 255;
    private static int RG_ = 0xFFFF00;
    private static int _GB = 65535;
    private static int R_B = 0xFF00FF;
    private static int r__ = 0xA00000;
    private static int _g_ = 40960;
    private static int __b = 160;
    private static int rg_ = 0xA0A000;
    private static int _gb = 41120;
    private static int r_b = 0xA000A0;
    private static int[] C_Light6 = new int[]{R__, RG_, _G_, _GB, __B, R_B};
    private static int[] C_Dark6 = new int[]{r__, rg_, _g_, _gb, __b, r_b};
    private static int[] C_LightDark12 = new int[]{R__, RG_, _G_, _GB, __B, R_B, r__, rg_, _g_, _gb, __b, r_b};
    private static int[] C_BW;
    private static int[] C_GRAY;
    public static final Palette PAL_DEFAULT;
    public static final Palette PAL_DARK6;
    public static final Palette PAL_LIGHT6;
    public static final Palette PAL_BW;
    public static final Palette PAL_GRAY;
    int[] palette;

    static {
        int[] nArray = new int[8];
        nArray[0] = 0xFFFFFF;
        nArray[1] = 0xCCCCCC;
        nArray[2] = 0xAAAAAA;
        nArray[3] = 0x888888;
        nArray[4] = 0x777777;
        nArray[5] = 0x555555;
        nArray[6] = 0x333333;
        C_BW = nArray;
        C_GRAY = new int[]{0xCCCCCC, 0xAAAAAA, 0x888888, 0x777777, 0x555555, 0x333333};
        PAL_DEFAULT = new Palette(C_LightDark12);
        PAL_DARK6 = new Palette(C_Dark6);
        PAL_LIGHT6 = new Palette(C_Light6);
        PAL_BW = new Palette(C_BW);
        PAL_GRAY = new Palette(C_GRAY);
    }

    public Palette(int color) {
        this.palette = new int[]{color};
    }

    public Palette(IDColor color) {
        this((color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF);
    }

    public Palette(int[] p) {
        this.palette = p;
    }

    public int getNumColors() {
        return this.palette.length;
    }

    public int getRGBA(int index) {
        int clr = this.palette[index %= this.palette.length];
        return clr << 8 | 0xFF;
    }

    public DColor getColor(int index) {
        int c = this.palette[index %= this.palette.length];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        return new DColor(r, g, b);
    }
}

