/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.printer.internal;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.report.core.internal.DAbstractParagraph;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.printer.internal.DPrinterPainter;
import org.eclipse.tptp.platform.report.drivers.printer.internal.TPageSplitter;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTPainter;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellParagraph;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;
import org.eclipse.tptp.platform.report.tools.internal.SWTIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.SimpleProgressMonitor;

public class DPrinterWriter
implements Runnable {
    IDItem contentItem;
    String jobTitle;
    Printer printer;
    Rectangle clientArea;
    int pageWidth;
    int pageHeight;
    private Shell shell;
    private PrinterData printerData;
    private IDIImageProvider iimage_provider;
    private IDProgressMonitor progressMonitor = new SimpleProgressMonitor();

    public DPrinterWriter(Shell _parent) {
        this.shell = _parent;
        this.printerData = Printer.getDefaultPrinterData();
    }

    void dispose() {
        if (this.iimage_provider != null) {
            this.iimage_provider.dispose();
            this.iimage_provider = null;
        }
    }

    private void print() {
        Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
        Point dpi = this.printer.getDPI();
        this.clientArea = this.printer.getClientArea();
        this.pageWidth = this.clientArea.width;
        this.pageHeight = this.clientArea.height;
        GC gc = new GC((Drawable)this.printer);
        SWTGC swtgc = new SWTGC((Device)this.printer, gc);
        int align = this.contentItem instanceof DAbstractParagraph ? ((DAbstractParagraph)this.contentItem).getAlignment() : 1;
        int mh = (dpi.x + trim.x) / 8;
        int mv = (dpi.y + trim.y) / 8;
        TCellParagraph contentCell = new TCellParagraph(this.contentItem, null, align);
        contentCell.setMargin(mh, mh, mv, mv);
        Display disp = Display.getDefault();
        contentCell.fillContent(this.contentItem, (IGC)swtgc, this.getImageProvider(), this.getProgressMonitor(), new DTitleLevel(), new DListLevel(), false);
        contentCell.computeSize(this.pageWidth * disp.getDPI().x / dpi.x, -1, 1.0f, (IGC)swtgc, this.getProgressMonitor());
        contentCell.layout(1.0f, 0, this.getProgressMonitor());
        TPageSplitter sp = new TPageSplitter();
        sp.setPageSize(this.pageWidth, this.pageHeight);
        sp.split(contentCell, 1.0f, (IGC)swtgc, this.getImageProvider(), this.getProgressMonitor(), new DTitleLevel(), new DListLevel(), false, 0);
        DPrinterPainter painter = new DPrinterPainter();
        int y0 = sp.getPageCount() > 0 ? sp.getPageAt((int)0).y : 0;
        int nupage = 0;
        while (nupage < sp.getPageCount()) {
            if (this.printerData.scope == 1) {
                if (nupage + 1 >= this.printer.getPrinterData().startPage) {
                    if (nupage + 1 > this.printer.getPrinterData().endPage) break;
                }
            } else {
                SWTPainter.PainterEvent pe;
                TPageSplitter.Page page = sp.getPageAt(nupage);
                if (!this.printer.startPage()) break;
                int ypos = 0;
                if (page.header != null) {
                    pe = new SWTPainter.PainterEvent((IGC)swtgc, page.header, 1.0f, this.getImageProvider(), null, false, false, 0, 0, 0, 0, this.clientArea.x, this.clientArea.y, page.header.getWidth(), page.header.getHeight(), 0, 0, page.header.getWidth(), page.header.getHeight());
                    ((SWTPainter)painter).drawCell(pe);
                    ypos += page.header.getHeight();
                }
                pe = new SWTPainter.PainterEvent((IGC)swtgc, contentCell, 1.0f, this.getImageProvider(), null, false, false, 0, 0, 0, 0, page.x, page.y - ypos + y0 - 1, page.w, page.h + ypos, 0, page.y, page.w, page.h);
                ((SWTPainter)painter).drawCell(pe);
                if (page.footer != null) {
                    pe = new SWTPainter.PainterEvent((IGC)swtgc, page.footer, 1.0f, this.getImageProvider(), null, false, false, 0, 0, 0, 0, this.clientArea.x, -this.clientArea.height + page.footer.getHeight(), page.footer.getWidth(), page.footer.getHeight(), 0, 0, page.footer.getWidth(), page.footer.getHeight());
                    ((SWTPainter)painter).drawCell(pe);
                }
                this.printer.endPage();
            }
            ++nupage;
        }
        contentCell.dispose();
        gc.dispose();
        swtgc.dispose();
    }

    public IDIImageProvider getImageProvider() {
        if (this.iimage_provider == null) {
            this.iimage_provider = new SWTIImageProvider((Device)Display.getCurrent());
        }
        return this.iimage_provider;
    }

    public void run() {
        if (this.contentItem == null) {
            return;
        }
        PrintDialog d = new PrintDialog(this.shell);
        this.printerData = d.open();
        if (this.printerData == null) {
            return;
        }
        String jobName = "Printing " + (this.jobTitle == null ? "Unamed Document" : this.jobTitle);
        this.printer = new Printer(this.printerData);
        if (this.printer.startJob(jobName)) {
            this.print();
            this.dispose();
            this.printer.endJob();
        }
    }

    public IDItem getContentItem() {
        return this.contentItem;
    }

    public void setContentItem(IDItem rootItem) {
        this.contentItem = rootItem;
        if (this.contentItem instanceof IDDocument) {
            this.jobTitle = ((IDDocument)this.contentItem).getTitle();
        }
    }

    public void setDocument(IDDocument document) {
        this.setContentItem((IDItem)document);
    }

    public void setImageProvider(IDIImageProvider provider) {
        this.iimage_provider = provider;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public IDProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(IDProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

