/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.printer.internal;

import java.util.LinkedList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DPageBreak;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.IMarginLayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellParagraph;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TPageSplitter {
    LinkedList pages = new LinkedList();
    int pageWidth = -1;
    int pageHeight = -1;

    void pagesChildren(TAbstractCell cell, TAbstractCell start, int ypos, int h, int nupage, EndPageInfo info) {
        info.empty = true;
        TAbstractCell c = start.getParent() == cell ? start : cell.getChild();
        while (c != null) {
            if (c.getY() + c.getHeight() >= ypos && c.getY() <= ypos + h) {
                if (c.getItem() instanceof DSection && info.section != c.getItem()) {
                    info.section = (DSection)c.getItem();
                    info.start = c.getNext();
                    info.ymax = c.getY();
                    info.ymin = c.getY();
                    return;
                }
                if (c.getChild() != null) {
                    int oldy = info.ymax;
                    int oldymin = info.ymin;
                    int yp = 0;
                    int nh = 0;
                    if (ypos >= c.getY()) {
                        yp = ypos - c.getY();
                        nh = h;
                    } else {
                        yp = 0;
                        nh = ypos + h - c.getY();
                    }
                    info.ymin = nh;
                    info.ymax = 0;
                    this.pagesChildren(c, c.getChild(), yp, nh, nupage, info);
                    info.ymax = Math.max(info.ymax + c.getY(), oldy);
                    info.ymin = Math.min(info.ymin + c.getY(), oldymin);
                } else {
                    if (c.getY() + c.getHeight() >= ypos + h) {
                        info.start = info.start == null ? c : info.start;
                        info.ymin = c instanceof TCellText ? c.getY() : ypos + h;
                        return;
                    }
                    info.ymax = Math.max(c.getY() + c.getHeight(), info.ymax);
                    info.empty = false;
                    if (c.getItem() instanceof DPageCounter) {
                        ((TCellText)c).setText(String.valueOf(nupage));
                    } else if (c.getItem() instanceof DPageBreak) {
                        info.start = c.getNext();
                        info.ymax = c.getY();
                        return;
                    }
                }
            }
            c = c.getNext();
        }
        if (info.start == null) {
            info.ymax = Math.min(cell.getHeight() - ypos, h);
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.getPageCount()) {
            Page p = this.getPageAt(i);
            p.footer.dispose();
            p.header.dispose();
            ++i;
        }
        this.pages.clear();
    }

    public void split(TAbstractCellContainer cell, float zoom, IGC gc, IDIImageProvider pm, IDProgressMonitor monitor, DTitleLevel tl, DListLevel ll, boolean flatpopup, int char_pos) {
        this.clear();
        this.pageWidth = cell.getWidth();
        int ypos = 0;
        EndPageInfo info = new EndPageInfo();
        DSection currentSection = null;
        DHeader header = null;
        DFooter footer = null;
        int nupage = 1;
        int tm = 0;
        int lm = 0;
        int rm = 0;
        int bm = 0;
        if (cell.getLayout() instanceof IMarginLayout) {
            tm = ((IMarginLayout)cell.getLayout()).getTopMargin();
            lm = ((IMarginLayout)cell.getLayout()).getLeftMargin();
            rm = ((IMarginLayout)cell.getLayout()).getRightMargin();
            bm = ((IMarginLayout)cell.getLayout()).getBottomMargin();
        }
        while (ypos < cell.getHeight()) {
            Page currentPage = new Page();
            int bodyHeight = this.pageHeight;
            if (header != null) {
                currentPage.header = new TCellParagraph((IDItem)header, null, header.getAlignment());
                currentPage.header.setMargin(lm, rm, tm, bm);
                currentPage.header.fillContent((IDItem)header, gc, pm, monitor, tl, ll, flatpopup);
                currentPage.header.computeSize(this.pageWidth, -1, zoom, gc, monitor);
                char_pos = currentPage.header.layout(zoom, char_pos, monitor);
                this.pagesChildren(currentPage.header, currentPage.header.getChild(), 0, this.pageHeight, nupage, info);
                bodyHeight -= currentPage.header.getHeight();
            }
            if (footer != null) {
                currentPage.footer = new TCellParagraph((IDItem)footer, null, footer.getAlignment());
                currentPage.footer.setMargin(lm, rm, tm, bm);
                currentPage.footer.fillContent((IDItem)footer, gc, pm, monitor, tl, ll, flatpopup);
                currentPage.footer.computeSize(this.pageWidth, -1, zoom, gc, monitor);
                char_pos = currentPage.footer.layout(zoom, char_pos, monitor);
                bodyHeight -= currentPage.footer.getHeight();
            }
            TAbstractCell start = info.start;
            info.ymax = 0;
            info.ymin = Integer.MAX_VALUE;
            info.start = null;
            this.pagesChildren(cell, start == null ? cell.getChild() : start, ypos, bodyHeight, nupage, info);
            currentPage.y = ypos;
            currentPage.h = ypos + info.ymax;
            currentPage.w = this.pageWidth;
            currentPage.x = 0;
            ypos += info.ymin;
            if (currentPage.footer != null) {
                this.pagesChildren(currentPage.footer, currentPage.footer.getChild(), 0, this.pageHeight - currentPage.footer.getHeight() - bodyHeight, nupage, info);
            }
            if (info.section != null && info.section != currentSection) {
                header = info.section.getHeader();
                footer = info.section.getFooter();
                currentSection = info.section;
            }
            if (info.empty) continue;
            this.pages.addLast(currentPage);
            ++nupage;
        }
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public Page getPageAt(int i) {
        return (Page)this.pages.get(i);
    }

    public Page getLastPage() {
        return (Page)this.pages.getLast();
    }

    public void setPageSize(int w, int h) {
        this.pageWidth = w;
        this.pageHeight = h;
    }

    public Point getPageSize() {
        return new Point(this.pageWidth, this.pageHeight);
    }

    class EndPageInfo {
        int ymax;
        int ymin = Integer.MAX_VALUE;
        TAbstractCell start;
        DSection section;
        boolean empty;

        EndPageInfo() {
        }
    }

    public class Page {
        public int y;
        public int x;
        public int w;
        public int h;
        public TCellParagraph header;
        public TCellParagraph footer;
    }
}

