/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.IContentProvider;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public abstract class TAbstractCellContainer
extends TAbstractCell {
    private TAbstractCell child;
    private TAbstractCell last;
    boolean fixedSize = false;

    public abstract ILayout getLayout();

    public abstract IContentProvider getContentProvider();

    public TAbstractCellContainer(IDItem i) {
        super(i);
    }

    public TAbstractCell addCell(TAbstractCell c) {
        if (this.child == null) {
            this.setChild(c);
            c.setPrevious(null);
        } else {
            this.last.setNext(c);
            c.setPrevious(this.last);
        }
        c.setParent(this);
        c.setNext(null);
        this.last = c;
        return c;
    }

    public void removeCell(TAbstractCell c) {
        if (c.getPrevious() != null) {
            c.getPrevious().setNext(c.getNext());
        } else {
            this.last = this.child = c.getNext();
        }
        if (c.getNext() != null) {
            c.getNext().setPrevious(c.getPrevious());
        } else {
            this.last = c.getPrevious();
        }
        c.setParent(null);
        c.setNext(null);
        c.setPrevious(null);
    }

    public boolean hasCell(TAbstractCell c) {
        TAbstractCell s = this.getChild();
        while (s != null) {
            if (s == c) {
                return true;
            }
            s = s.getNext();
        }
        return false;
    }

    public TAbstractCell insertCell(TAbstractCell c, TAbstractCell previous) {
        if (previous != null) {
            if (previous.getNext() != null) {
                previous.getNext().setPrevious(c);
            } else {
                this.last = c;
            }
            c.setNext(previous.getNext());
            previous.setNext(c);
        } else {
            c.setNext(this.getChild());
            this.getChild().setPrevious(c);
        }
        c.setParent(this);
        c.setPrevious(previous);
        return c;
    }

    public void fillContent(IDItem item, IGC gc, IDIImageProvider pm, IDProgressMonitor monitor, DTitleLevel titleLevel, DListLevel listLevel, boolean flatpopup) {
        this.getContentProvider().fillContent(this, item, gc, pm, monitor, titleLevel, listLevel, flatpopup);
    }

    public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor) {
        this.getLayout().computeSize(this, hintW, hintH, zoom, gc, monitor);
    }

    public int layout(float zoom, int charpos, IDProgressMonitor monitor) {
        return this.getLayout().layout(this, zoom, charpos, monitor);
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public void setFixedSize(boolean fixedSize) {
        this.fixedSize = fixedSize;
    }

    public TAbstractCell getChild() {
        return this.child;
    }

    public void setChild(TAbstractCell aChild) {
        this.child = aChild;
    }

    public void dispose() {
        TAbstractCell c = this.getChild();
        while (c != null) {
            c.dispose();
            c = c.getNext();
        }
    }

    public TAbstractCell getLast() {
        return this.last;
    }

    public int getChildCount() {
        int nbchild = 0;
        TAbstractCell c = this.getChild();
        while (c != null) {
            ++nbchild;
            c = c.getNext();
        }
        return nbchild;
    }
}

