/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TExtensibleContentProvider;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TMLayoutContentCellContainer;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TCellTable
extends TMLayoutContentCellContainer {
    TMLayoutContentCellContainer[][] items;
    int nbCol;
    int nbRow;
    int border;
    float[] columnWidth = null;
    private int[] maxC = new int[this.nbCol];

    public TCellTable(IDItem i, int row, int col, float[] _columnWidth, int _border) {
        super(i);
        this.items = new TMLayoutContentCellContainer[row][col];
        this.columnWidth = _columnWidth;
        this.nbCol = col;
        this.nbRow = row;
        this.border = _border;
    }

    public void fillContent(TAbstractCellContainer cell, IDItem item, IGC _gc, IDIImageProvider _pm, IDProgressMonitor monitor, DTitleLevel tl, DListLevel ll, boolean flatpopup) {
        Info d = new Info();
        d.cell = cell;
        d.gc = _gc;
        d.imageProvider = _pm;
        d.rowSpans = new int[this.nbCol];
        d.nuRow = 0;
        d.nuCol = 0;
        d.listLevel = ll;
        d.titleLevel = tl;
        d.flatPopup = flatpopup;
        d.pm = monitor;
        TExtensibleContentProvider.getInstance().doChildrenItem(item, (DExtensible)TExtensibleContentProvider.getInstance(), d);
    }

    public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float zoom, IGC _gc, IDProgressMonitor monitor) {
        int w;
        if (this.items == null) {
            return;
        }
        if (this.nbRow == 0) {
            return;
        }
        this.setSpacing((int)((float)this.getBorder() * zoom));
        int[] hintWs = new int[this.items[this.nbRow - 1].length];
        int r = w = hintW - this.getSpacing() * (this.nbCol + 1);
        int i = 0;
        while (i < hintWs.length - 1) {
            hintWs[i] = this.columnWidth != null && i < this.columnWidth.length ? (int)((float)w * this.columnWidth[i]) : w / this.nbCol;
            r -= hintWs[i];
            ++i;
        }
        hintWs[hintWs.length - 1] = this.columnWidth != null && this.columnWidth.length > hintWs.length - 1 ? (int)((float)w * this.columnWidth[hintWs.length - 1]) : r;
        int[] maxR = new int[this.nbRow];
        this.maxC = new int[this.nbCol];
        this.setFixedSize(true);
        boolean[] sizeable = new boolean[this.nbCol];
        int m = (int)(2.0f * zoom);
        int i2 = 0;
        while (i2 < this.nbRow) {
            DCell cli;
            TMLayoutContentCellContainer c;
            int j = 0;
            while (j < this.nbCol) {
                c = this.items[i2][j];
                if (c != null) {
                    c.setMargin(m, m, m, m);
                    cli = (DCell)c.getItem();
                    int s = hintWs[j];
                    int k = 0;
                    while (k < cli.getColSpan() && j + k + 1 < this.nbCol) {
                        s += hintWs[j + k + 1];
                        ++k;
                    }
                    c.computeSize(s, -1, zoom, _gc, monitor);
                    boolean bl = sizeable[j] = c.getWidth() <= s;
                    if (cli.getColSpan() == 0) {
                        this.maxC[j] = Math.max(c.getWidth(), this.maxC[j]);
                    }
                    if (cli.getRowSpan() == 0) {
                        maxR[i2] = Math.max(c.getHeight(), maxR[i2]);
                    }
                }
                ++j;
            }
            int k = 0;
            while (k < this.nbCol) {
                c = this.items[i2][k];
                if (c != null && (cli = (DCell)c.getItem()).getRowSpan() > 0) {
                    int r2 = 0;
                    int l = 0;
                    while (l < cli.getRowSpan() && i2 + l < this.nbRow) {
                        r2 += maxR[i2 + l];
                        ++l;
                    }
                    int nurow = i2 + cli.getRowSpan() < this.nbRow ? i2 + cli.getRowSpan() : this.nbRow - 1;
                    maxR[nurow] = Math.max(maxR[nurow], c.getHeight() - r2);
                }
                ++k;
            }
            ++i2;
        }
        int nbs = 0;
        int wt = 0;
        int j = 0;
        while (j < this.nbCol) {
            if (sizeable[j]) {
                ++nbs;
            }
            wt += this.maxC[j];
            ++j;
        }
        if (nbs < this.nbCol) {
            j = 0;
            while (j < this.nbCol) {
                if (sizeable[j]) {
                    int n = j;
                    this.maxC[n] = this.maxC[n] - (wt - w) / nbs;
                }
                ++j;
            }
        }
        monitor.setTotalWorks(monitor.getTotalWorks() + this.nbCol * this.nbRow);
        int i3 = 0;
        while (i3 < this.nbRow) {
            int j2 = 0;
            while (j2 < this.nbCol) {
                TMLayoutContentCellContainer c = this.items[i3][j2];
                if (c == null) {
                    monitor.worked(monitor.getWorkCount() + 1);
                } else {
                    DCell cli = (DCell)c.getItem();
                    int wcell = this.maxC[j2];
                    int hcell = maxR[i3];
                    int k = 0;
                    while (k < cli.getColSpan() && k + j2 + 1 < this.nbCol) {
                        wcell += this.maxC[k + j2 + 1] + (int)((float)this.getSpacing() * zoom);
                        ++k;
                    }
                    int l = 0;
                    while (l < cli.getRowSpan() && l + i3 + 1 < this.nbRow) {
                        hcell += maxR[l + i3 + 1] + (int)((float)this.getSpacing() * zoom);
                        ++l;
                    }
                    c.computeSize(wcell, hcell, zoom, _gc, monitor);
                    if (!c.isFixedSize()) {
                        this.setFixedSize(false);
                    }
                    monitor.worked(monitor.getWorkCount() + 1);
                }
                ++j2;
            }
            ++i3;
        }
        int retx = 0;
        int rety = 0;
        int i4 = 0;
        while (i4 < this.nbCol) {
            retx += this.maxC[i4];
            ++i4;
        }
        i4 = 0;
        while (i4 < this.nbRow) {
            rety += maxR[i4];
            ++i4;
        }
        cell.setSize(retx += (int)((float)this.getSpacing() * zoom) * (this.nbCol + 1), rety += (int)((float)this.getSpacing() * zoom) * (this.nbRow + 1));
    }

    public int layout(TAbstractCellContainer cell, float zoom, int charpos, IDProgressMonitor monitor) {
        int z_spacing;
        boolean r = this.isReversed();
        int currentY = z_spacing = Math.round((float)this.getSpacing() * zoom);
        int pos = charpos;
        monitor.setTotalWorks(monitor.getTotalWorks() + this.nbCol * this.nbRow);
        int i = 0;
        while (i < this.nbRow) {
            int h = 0;
            int currentX = r ? cell.getWidth() : z_spacing;
            int j = 0;
            while (j < this.nbCol) {
                TMLayoutContentCellContainer c = this.items[i][j];
                int dec = this.maxC[j] + 1;
                while (j + 1 < this.nbCol && this.items[i][j + 1] == null) {
                    dec += this.maxC[++j] + 1;
                }
                monitor.worked(monitor.getWorkCount() + 1);
                if (j != this.nbCol) {
                    if (c == null) {
                        currentX += r ? -dec : dec;
                    } else {
                        pos = c.layout(zoom, pos, monitor);
                        if (r) {
                            currentX -= dec;
                        }
                        c.setXY(currentX, currentY);
                        if (!r) {
                            currentX += dec;
                        }
                        h = c.getHeight();
                    }
                }
                ++j;
            }
            currentY += h + z_spacing;
            ++i;
        }
        return pos;
    }

    public float[] getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(float[] columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    private class Info
    implements TExtensibleContentProvider.IArg {
        TAbstractCellContainer cell;
        TAbstractCell currentCell;
        IGC gc;
        IDIImageProvider imageProvider;
        IDProgressMonitor pm;
        int hintW;
        int hintH;
        float zoom;
        DListLevel listLevel;
        DTitleLevel titleLevel;
        boolean flatPopup;
        int[] rowSpans;
        int nuRow;
        int nuCol;

        private Info() {
        }

        public IGC getGc() {
            return this.gc;
        }

        public IDIImageProvider getImageProvider() {
            return this.imageProvider;
        }

        public DListLevel getListLevel() {
            return this.listLevel;
        }

        public DTitleLevel getTitleLevel() {
            return this.titleLevel;
        }

        public boolean isDrawPopup() {
            return false;
        }

        public boolean isFlatPopup() {
            return this.flatPopup;
        }

        public void setDrawPopup(boolean v) {
        }

        public TAbstractCellContainer getContainer() {
            return this.cell;
        }

        public TAbstractCell getCell() {
            return this.currentCell;
        }

        public ILayout getLayout() {
            return TCellTable.this;
        }

        public IDProgressMonitor getProgressMonitor() {
            return this.pm;
        }

        public void addReturnValue(TAbstractCell c) {
            if (!(c instanceof TMLayoutContentCellContainer)) {
                return;
            }
            if (!(c.getItem() instanceof DCell)) {
                return;
            }
            DCell ci = (DCell)c.getItem();
            if (this.nuRow > 0 && c.getItem() instanceof DCell) {
                int i = this.nuCol;
                while (i < TCellTable.this.nbCol) {
                    if (this.rowSpans[this.nuCol] <= 0) break;
                    int n = this.nuCol++;
                    this.rowSpans[n] = this.rowSpans[n] - 1;
                    ++i;
                }
            }
            this.cell.addCell(c);
            TCellTable.this.items[this.nuRow][this.nuCol] = (TMLayoutContentCellContainer)c;
            this.rowSpans[this.nuCol] = ci.getRowSpan();
            this.nuCol += 1 + ci.getColSpan();
            if (ci.getNext() == null) {
                this.nuCol = 0;
                ++this.nuRow;
            }
        }
    }
}

