/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TCellText
extends TAbstractCell {
    protected String text;
    protected int start;
    protected int len;
    protected int descent;

    public TCellText(IDItem i, String t) {
        super(i);
        this.setText(t, 0, t.length(), 0);
    }

    public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor) {
        if (this.getText() == null) {
            return;
        }
        Font sfont = IGCDStyle.GetFont((IDItem)this.getItem(), (float)zoom);
        IFont oldFont = gc.setFont((IFont)sfont);
        String qs = this.getText().substring(this.start, this.start + this.len);
        ISize p = gc.textExtent(qs);
        gc.setFont(oldFont);
        this.setSize(p.getW(), p.getH());
    }

    public String getText() {
        return this.text;
    }

    public boolean isText() {
        return true;
    }

    public TCellText(IDItem i) {
        super(i);
    }

    public int getLen() {
        return this.len;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public void setLen(int aLen) {
        this.len = aLen;
    }

    public void setText(String s, int st, int l, int dsc) {
        this.text = s;
        this.start = st;
        this.len = l;
        this.descent = dsc;
    }

    public void setText(String s) {
        this.text = s;
        this.start = 0;
        this.len = this.text.length();
        this.descent = 0;
    }

    public void clear() {
        this.text = null;
        this.start = 0;
        this.len = 0;
        this.position = 0;
        this.descent = 0;
    }

    public int getDescent() {
        return this.descent;
    }

    public void setDescent(int descent) {
        this.descent = descent;
    }

    public TAbstractCell mapPositionToCell(int pos) {
        if (this.getPosition() <= pos && pos <= this.getPosition() + this.getLen()) {
            return this;
        }
        return null;
    }

    public void dump(int level) {
        int i = 0;
        while (i < level) {
            System.out.print("  ");
            ++i;
        }
        System.out.print("<cell x=\"" + this.getX() + "\" y=\"" + this.getY() + "\" w=\"" + this.getWidth() + "\" h=\"" + this.getHeight() + "\"");
        TCellText ct = this;
        System.out.print(" type=\"text\">");
        String s = ct.getText();
        if (s != null) {
            System.out.print(s.substring(ct.getStart(), ct.getStart() + ct.getLen()));
        }
        System.out.println("</cell>");
    }
}

