/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.dialogs.internal;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.tptp.platform.report.ui.dialogs.internal.JScribDialog;
import org.eclipse.tptp.platform.report.ui.swt.widgets.internal.ScreenPreview;

public class ZoomEditorDialog
extends JScribDialog {
    float zoomFactor = 1.0f;
    boolean maintainRatio = true;
    boolean fontPreviewEnabled = true;
    int viewW = 100;
    int viewH = 100;
    int contentsW = 100;
    int contentsH = 100;
    String previewText = ReportCorePlugin.translate((String)"PREVIEW_STRING");
    String previewFontName = ReportCorePlugin.translate((String)"PREVIEW_FONT_NAME");
    int previewFontSize = 10;
    float maxZoomFactor = 10.0f;
    float minZoomFactor = 0.1f;
    ZoomFactorWidget fw;
    ZoomPreviewWidget preview;
    public Signal zoomChanged = new Signal("zoomChanged(Float)");
    public Signal ratioEnabled = new Signal("ratioEnabled(Boolean)");

    public ZoomEditorDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout g = new GridLayout();
        g.numColumns = 2;
        g.horizontalSpacing = 10;
        composite.setLayout((Layout)g);
        this.fw = new ZoomFactorWidget(composite, 0);
        this.fw.setZoomFactor(new Float(this.zoomFactor));
        this.fw.setLayoutData(new GridData(514));
        this.preview = new ZoomPreviewWidget(composite, 0);
        this.zoomChanged.connect((Object)this.preview, "setZoomFactor(Float)");
        this.preview.setZoomFactor(new Float(this.zoomFactor));
        this.preview.setLayoutData(new GridData(514));
        this.getShell().setText(ReportCorePlugin.translate((String)"ZOOM"));
        return composite;
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public boolean isFontPreviewEnabled() {
        return this.fontPreviewEnabled;
    }

    public void setFontPreviewEnabled(boolean fontZoom) {
        this.fontPreviewEnabled = fontZoom;
    }

    public void setData(int _contentsW, int _contentsH, int _viewW, int _viewH, float _zoomFactor) {
        this.contentsW = (int)((float)_contentsW / _zoomFactor);
        this.contentsH = (int)((float)_contentsH / _zoomFactor);
        this.viewW = _viewW;
        this.viewH = _viewH;
        this.zoomFactor = _zoomFactor;
    }

    public void setPreviewText(String sampleText) {
        this.previewText = sampleText;
    }

    public void setPreviewFont(String fontName, int size) {
        this.previewFontName = fontName;
        this.previewFontSize = size;
    }

    public float getMaxZoomFactor() {
        return this.maxZoomFactor;
    }

    public void setMaxZoomFactor(float maxZoomFactor) {
        this.maxZoomFactor = maxZoomFactor;
    }

    public float getMinZoomFactor() {
        return this.minZoomFactor;
    }

    public void setMinZoomFactor(float minZoomfactor) {
        this.minZoomFactor = minZoomfactor;
    }

    public boolean isMaintainRatio() {
        return this.maintainRatio;
    }

    public void setMaintainRatio(boolean maintainRatio) {
        this.maintainRatio = maintainRatio;
    }

    public class ZoomFactorWidget
    extends Composite {
        private Scale custom;
        private Label label;

        private void createButton(Composite parent, String t, float v) {
            final float value = v;
            Button b = new Button(parent, 16);
            b.setText(t);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ZoomFactorWidget)ZoomFactorWidget.this).ZoomEditorDialog.this.zoomChanged.emit((Object)new Float(value));
                }
            });
        }

        public ZoomFactorWidget(Composite parent, int style) {
            super(parent, style);
            FillLayout l = new FillLayout();
            this.setLayout((Layout)l);
            Group gb = new Group((Composite)this, 0);
            RowLayout rowLayout = new RowLayout(512);
            gb.setLayout((Layout)rowLayout);
            gb.setText(ReportCorePlugin.translate((String)"ZOOM_FACTOR"));
            this.createButton((Composite)gb, ReportCorePlugin.translate((String)"200_PERCENT"), 2.0f);
            this.createButton((Composite)gb, ReportCorePlugin.translate((String)"100_PERCENT"), 1.0f);
            this.createButton((Composite)gb, ReportCorePlugin.translate((String)"75_PERCENT"), 0.75f);
            this.createButton((Composite)gb, ReportCorePlugin.translate((String)"PAGE_WIDTH"), (float)ZoomEditorDialog.this.viewW / (float)ZoomEditorDialog.this.contentsW);
            this.createButton((Composite)gb, ReportCorePlugin.translate((String)"ENSURE_VISIBLE"), (float)ZoomEditorDialog.this.viewH / (float)ZoomEditorDialog.this.contentsH);
            Composite s = new Composite((Composite)gb, 0);
            RowLayout pLayout = new RowLayout(512);
            s.setLayout((Layout)pLayout);
            this.label = new Label(s, 16384);
            this.label.setText(ReportCorePlugin.translate((String)"CUSTOM"));
            this.custom = new Scale((Composite)gb, 256);
            this.custom.setMinimum((int)(ZoomEditorDialog.this.minZoomFactor * 100.0f));
            this.custom.setMaximum((int)(ZoomEditorDialog.this.maxZoomFactor * 100.0f));
            this.custom.setPageIncrement((int)((ZoomEditorDialog.this.maxZoomFactor - ZoomEditorDialog.this.minZoomFactor) / 10.0f * 100.0f));
            this.custom.setSelection((int)ZoomEditorDialog.this.zoomFactor * 100);
            this.custom.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ZoomFactorWidget)ZoomFactorWidget.this).ZoomEditorDialog.this.zoomChanged.emit((Object)new Float((float)ZoomFactorWidget.this.custom.getSelection() / 100.0f));
                }
            });
            Button b_aspectRatio = new Button((Composite)gb, 32);
            b_aspectRatio.setSelection(ZoomEditorDialog.this.maintainRatio);
            b_aspectRatio.setText(ReportCorePlugin.translate((String)"MAINTAIN_RATIO"));
            b_aspectRatio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ZoomFactorWidget)ZoomFactorWidget.this).ZoomEditorDialog.this.maintainRatio = !((ZoomFactorWidget)ZoomFactorWidget.this).ZoomEditorDialog.this.maintainRatio;
                    ((ZoomFactorWidget)ZoomFactorWidget.this).ZoomEditorDialog.this.ratioEnabled.emit((Object)new Boolean(((ZoomFactorWidget)ZoomFactorWidget.this).ZoomEditorDialog.this.maintainRatio));
                }
            });
            ZoomEditorDialog.this.zoomChanged.connect((Object)this, "setZoomFactor(Float)");
            ZoomEditorDialog.this.ratioEnabled.connect((Object)this, "setRatioEnabled(Boolean)");
            this.setZoomFactor(new Float(ZoomEditorDialog.this.zoomFactor));
            this.custom.setFocus();
        }

        public void setZoomFactor(Float v) {
            int percent = (int)(v.floatValue() * 100.0f);
            this.custom.setSelection(percent);
            ZoomEditorDialog.this.zoomFactor = v.floatValue();
            this.label.setText(String.valueOf(ReportCorePlugin.translate((String)"CUSTOM_AT")) + percent + ReportCorePlugin.translate((String)"PERCENT"));
        }
    }

    public class ZoomPreviewWidget
    extends Composite {
        private Font font;
        private Text f_text;
        private ScreenPreview s;

        public ZoomPreviewWidget(Composite parent, int style) {
            super(parent, style | 0x40000);
            this.setLayout((Layout)new FillLayout(512));
            Group gb1 = new Group((Composite)this, 0);
            RowLayout rowLayout1 = new RowLayout(512);
            rowLayout1.justify = true;
            gb1.setText(ReportCorePlugin.translate((String)"PREVIEW"));
            gb1.setLayout((Layout)rowLayout1);
            this.s = new ScreenPreview((Composite)gb1, 0x1000000);
            Group gb2 = new Group((Composite)gb1, 0);
            gb2.setLayoutData((Object)new RowData(200, 50));
            gb2.setLayout((Layout)new FillLayout(512));
            gb2.setText(String.valueOf(ZoomEditorDialog.this.previewFontSize) + ReportCorePlugin.translate((String)"POINT") + ZoomEditorDialog.this.previewFontName);
            gb2.setEnabled(ZoomEditorDialog.this.fontPreviewEnabled);
            this.f_text = new Text((Composite)gb2, 2);
            this.font = new Font((Device)this.getDisplay(), ZoomEditorDialog.this.previewFontName, ZoomEditorDialog.this.previewFontSize, 0);
            this.f_text.setFont(this.font);
            this.f_text.setEnabled(ZoomEditorDialog.this.fontPreviewEnabled);
            this.f_text.setEditable(false);
            this.f_text.setBackground(this.getDisplay().getSystemColor(25));
            this.f_text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ZoomPreviewWidget.this.font != null) {
                        ZoomPreviewWidget.this.font.dispose();
                    }
                }
            });
            if (ZoomEditorDialog.this.fontPreviewEnabled) {
                this.f_text.setText(ZoomEditorDialog.this.previewText);
            } else {
                this.f_text.setText(ReportCorePlugin.translate((String)"ZOOM_APPLIED"));
            }
        }

        public void setZoomFactor(Float zoom) {
            if (ZoomEditorDialog.this.fontPreviewEnabled) {
                Font fn = new Font((Device)this.getDisplay(), ZoomEditorDialog.this.previewFontName, (int)((float)ZoomEditorDialog.this.previewFontSize * zoom.floatValue()), 0);
                this.f_text.setFont(fn);
                if (this.font != null) {
                    this.font.dispose();
                }
                this.font = fn;
            }
            Rectangle rv = new Rectangle(300, 200, ZoomEditorDialog.this.viewW, ZoomEditorDialog.this.viewH);
            Rectangle rc = new Rectangle(2, 2, (int)((float)ZoomEditorDialog.this.contentsW * ZoomEditorDialog.this.zoomFactor), (int)((float)ZoomEditorDialog.this.contentsH * ZoomEditorDialog.this.zoomFactor));
            this.s.setRectangles(rv, rc);
        }
    }
}

