/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.editor.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDTaggedItem;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlDocumentReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlDocumentWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IXmlParser;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.SWTIImageProvider;
import org.eclipse.tptp.platform.report.ui.ReportUIPlugin;
import org.eclipse.tptp.platform.report.ui.editor.actions.internal.CopyAction;
import org.eclipse.tptp.platform.report.ui.editor.actions.internal.PrintAction;
import org.eclipse.tptp.platform.report.ui.editor.actions.internal.SelectAllAction;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.xsd.util.XSDParser;

public class ReportEditor
extends MultiPageEditorPart {
    private IPath amlFile = null;
    private DocViewer[] views;
    private DStyleRegistry styles = new DStyleRegistry();
    private int editorIndex;
    private static String html_browser = ReportUIPlugin.getString("ReportEditor.browserName");
    private SWTIImageProvider imgp;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        if (editorInput instanceof IPathEditorInput) {
            this.amlFile = ((IPathEditorInput)editorInput).getPath();
        } else if (editorInput instanceof ILocationProvider) {
            this.amlFile = ((ILocationProvider)editorInput).getPath((Object)editorInput);
        } else {
            throw new PartInitException(String.valueOf(ReportUIPlugin.getString("ReportEditor.BadFileType")) + editorInput.getClass().getName());
        }
    }

    public void openFile(String filename) {
        DDocument doc;
        IDObject[] objs;
        DXmlReader reader;
        if (filename.endsWith(ReportUIPlugin.getString("ReportEditor.jsmlExtension"))) {
            reader = new DXmlReader((IXmlParser)new XSDXmlParserAdapter(new XSDParser()));
            reader.setStyleRegistry(this.styles);
            try {
                objs = reader.read((InputStream)new FileInputStream(filename));
            }
            catch (Exception exception) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)ReportUIPlugin.getString("ReportEditor.ParsingError"), null, null);
                return;
            }
            catch (Error error) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)ReportUIPlugin.getString("ReportEditor.ParsingError"), null, null);
                return;
            }
        }
        reader = new DXmlDocumentReader((IXmlParser)new XSDXmlParserAdapter(new XSDParser()));
        reader.setStyleRegistry(this.styles);
        try {
            objs = reader.read((InputStream)new FileInputStream(filename));
        }
        catch (Exception e) {
            objs = new IDObject[1];
            doc = new DDocument();
            doc.addChild((IDItem)new DText(String.valueOf(ReportUIPlugin.getString("ReportEditor.FileError")) + filename + "'\n" + e.getMessage() + "\n"));
            objs[0] = doc;
        }
        catch (Error err) {
            objs = new IDObject[1];
            doc = new DDocument();
            doc.addChild((IDItem)new DText(String.valueOf(ReportUIPlugin.getString("ReportEditor.FileError")) + filename + "'\n" + err.getMessage() + "\n"));
            objs[0] = doc;
        }
        int nbdoc = 0;
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof IDDocument) {
                ++nbdoc;
            }
            ++i;
        }
        IDDocument[] documents = new IDDocument[nbdoc];
        if (nbdoc == 0) {
            objs = new IDObject[1];
            DDocument doc2 = new DDocument("error", ReportUIPlugin.getString("ReportEditor.errorDocTitle"));
            doc2.addChild((IDItem)new DText(String.valueOf(ReportUIPlugin.getString("ReportEditor.noDocument")) + filename + "'"));
            objs[0] = doc2;
            nbdoc = 1;
        }
        this.views = new DocViewer[nbdoc];
        int nudoc = 0;
        this.imgp = new SWTIImageProvider((Device)this.getSite().getShell().getDisplay());
        File info = new File(filename);
        this.imgp.addImageSearchPath(info.getParent());
        int i2 = 0;
        while (i2 < objs.length) {
            if (objs[i2] instanceof IDDocument) {
                this.views[nudoc] = new DocViewer();
                Composite composite = new Composite(this.getContainer(), 0);
                FillLayout layout = new FillLayout(512);
                composite.setLayout((Layout)layout);
                this.views[nudoc].document = (IDDocument)objs[i2];
                this.views[nudoc].viewer = new JSMLViewer(composite, 770);
                this.views[nudoc].viewer.setBackground(new Color((Device)composite.getDisplay(), 255, 255, 255));
                this.views[nudoc].viewer.setImageProvider((IDIImageProvider)this.imgp);
                this.views[nudoc].viewer.linkActivated.connect((Object)this, "linkActivated(java.lang.String, org.eclipse.tptp.platform.report.core.internal.IDLink)");
                this.views[nudoc].page = nudoc;
                int index = this.addPage((Control)composite);
                this.setPageText(index, this.views[nudoc].document.getTitle());
                this.views[nudoc].viewer.setContent(this.views[nudoc].document.getDocument());
                documents[nudoc] = this.views[nudoc].document;
                ++nudoc;
            }
            ++i2;
        }
        DLinkResolver.makeDocumentPool((IDDocument[])documents);
    }

    public void linkActivated(String str, IDLink link) {
        if (!DLinkUtil.isInternalLink((IDLink)link)) {
            String path = DLinkUtil.getPath((IDLink)link);
            if (DLinkUtil.getMethod((IDLink)link).equals("http")) {
                try {
                    Runtime.getRuntime().exec(new String[]{html_browser, str});
                }
                catch (IOException e) {
                    ErrorDialog err = new ErrorDialog(this.getEditorSite().getShell(), this.getTitle(), e.getMessage(), null, 0);
                    err.open();
                    return;
                }
            }
            if (DLinkUtil.getMethod((IDLink)link).equals("file")) {
                IWorkbench wb = ReportUIPlugin.getDefault().getWorkbench();
                IEditorDescriptor ed = wb.getEditorRegistry().getDefaultEditor(path);
                if (ed == null) {
                    ed = wb.getEditorRegistry().getDefaultEditor("foo.txt");
                }
                try {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
                    if (file != null) {
                        wb.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), ed.getId());
                    }
                }
                catch (PartInitException e) {
                    ErrorDialog err = new ErrorDialog(this.getEditorSite().getShell(), this.getTitle(), e.getMessage(), null, 0);
                    err.open();
                }
            }
        }
    }

    protected void createPages() {
        this.setPartName(this.amlFile.lastSegment());
        this.openFile(this.amlFile.toString());
        this.MakeAction();
    }

    private void MakeAction() {
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new PrintAction(this));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new CopyAction(this));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new SelectAllAction(this));
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editorIndex == -1) {
            return;
        }
        this.getEditor(this.editorIndex).doSave(monitor);
        this.reload();
    }

    public void doSaveAs() {
        FileDialog fd = new FileDialog(new Shell(Display.getDefault(), 2160), 8192);
        fd.setFilterNames(new String[]{ReportUIPlugin.getString("ReportEditor.rxmlFilter"), ReportUIPlugin.getString("ReportEditor.htmlFilter")});
        fd.setFilterExtensions(new String[]{"*.rxml", "*.html"});
        String filename = fd.open();
        if (filename == null) {
            return;
        }
        IDObject[] objs = new IDObject[this.views.length];
        int i = 0;
        while (i < objs.length) {
            objs[i] = this.views[i].document;
            ++i;
        }
        if (filename.lastIndexOf(".rxml") != -1) {
            DXmlDocumentWriter aw = new DXmlDocumentWriter();
            aw.setAutoIndentMode(true);
            try {
                aw.write((OutputStream)new FileOutputStream(filename), objs);
            }
            catch (Exception exception) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)(String.valueOf(filename) + ReportUIPlugin.getString("ReportEditor.saveError")), null, null);
            }
        } else if (filename.lastIndexOf(".html") != -1) {
            try {
                DHtmlWriter.write((String)filename, (IDObject[])objs, (String)"org.eclipse.tptp.platform.report.drivers.html.DHtmlGraphicSVG", (IDIImageProvider)this.imgp);
            }
            catch (DHtmlWriterException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)e.getMessage(), null, null);
            }
        }
    }

    public void reload() {
        this.openFile(this.amlFile.toString());
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public SWTViewer getActiveSWTViewer() {
        return this.views[this.getActivePage()].viewer;
    }

    public SWTViewer[] getSWTViewers() {
        SWTViewer[] swtv = new SWTViewer[this.views.length];
        int i = 0;
        while (i < swtv.length) {
            swtv[i] = this.views[i].viewer;
            ++i;
        }
        return swtv;
    }

    public DStyleRegistry getStyles() {
        return this.styles;
    }

    public void setActiveSWTViewer(int page) {
        this.setActivePage(page);
    }

    private static class DocViewer {
        public JSMLViewer viewer;
        public IDDocument document;
        public int page;

        private DocViewer() {
        }
    }

    private class JSMLViewer
    extends SWTViewer {
        public JSMLViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void activateLink(IDLink link, Point p) {
            if (DLinkUtil.isInternalLink((IDLink)link)) {
                DLinkResolver r = new DLinkResolver(link);
                r.resolve(null);
                IDItem doc = r.getDocument();
                IDTaggedItem item = r.getTaggedItem();
                int i = 0;
                while (i < ReportEditor.this.views.length) {
                    if (((ReportEditor)ReportEditor.this).views[i].document == doc) {
                        ReportEditor.this.setActivePage(((ReportEditor)ReportEditor.this).views[i].page);
                        ((ReportEditor)ReportEditor.this).views[i].viewer.scrollTo(item.getTag());
                        return;
                    }
                    ++i;
                }
            }
            super.activateLink(link, p);
        }
    }
}

