/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;

public class DSashLayout
extends Layout {
    private double default_rate;
    private int style = 256;
    private boolean first_layout = true;
    private int sash_width = 4;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(wHint, hHint);
    }

    private Point computeSize(Control control, boolean flushCache) {
        return control.computeSize(-1, -1, flushCache);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        Control[] children = composite.getChildren();
        this.verifyCompositeContents(composite);
        int count = children.length;
        this.setDefaultRate(count);
        this.style = ((Sash)children[2]).getStyle();
        if (this.style == 256) {
            this.layoutHorizontal(composite, true, clientArea, flushCache);
        } else {
            this.layoutVertical(composite, true, clientArea, flushCache);
        }
    }

    void layoutHorizontal(Composite composite, boolean move, Rectangle clientArea, boolean flushCache) {
        Sash sash;
        int height = clientArea.height;
        int width = clientArea.width;
        int posx = clientArea.x;
        int posy = clientArea.y;
        Control[] children = composite.getChildren();
        int count = children.length;
        int cfr_ignored_0 = (count - 1) / 2;
        if (this.first_layout) {
            int mid_width = 0;
            int i = 2;
            while (i < count) {
                sash = (Sash)children[i];
                Rectangle sash_rect = sash.getBounds();
                sash_rect.x = mid_width + width / ((count + 1) / 2);
                mid_width = sash_rect.x + this.sash_width;
                sash.setBounds(sash_rect.x, sash_rect.y, this.sash_width, height);
                i += 2;
            }
        }
        int j = 2;
        while (j < count) {
            SWTViewer viewer = (SWTViewer)children[j - 1];
            sash = (Sash)children[j];
            int w_viewer = sash.getBounds().x - posx;
            viewer.setBounds(posx, posy, w_viewer, height);
            posx = sash.getBounds().x + this.sash_width;
            width = posx + width - (sash.getBounds().x + this.sash_width + 1);
            if (j == count - 1) {
                SWTViewer viewer2 = (SWTViewer)children[j + 1];
                viewer2.setBounds(posx, posy, width, height);
            }
            j += 2;
        }
        this.first_layout = false;
    }

    void layoutVertical(Composite composite, boolean move, Rectangle clientArea, boolean flushCache) {
        Sash sash;
        int height = clientArea.height;
        int width = clientArea.width;
        int posx = clientArea.x;
        int posy = clientArea.y;
        Control[] children = composite.getChildren();
        int count = children.length;
        int cfr_ignored_0 = (count - 1) / 2;
        if (this.first_layout) {
            int mid_height = 0;
            int i = 2;
            while (i < count) {
                sash = (Sash)children[i];
                Rectangle sash_rect = sash.getBounds();
                sash_rect.y = mid_height + height / ((count + 1) / 2);
                mid_height = sash_rect.y + this.sash_width + 1;
                sash.setBounds(sash_rect.x, sash_rect.y, width, this.sash_width);
                i += 2;
            }
        }
        int j = 2;
        while (j < count) {
            SWTViewer viewer = (SWTViewer)children[j - 1];
            sash = (Sash)children[j];
            int h_viewer = sash.getBounds().y - posy;
            viewer.setBounds(posx, posy, width, h_viewer);
            posy = sash.getBounds().y + this.sash_width;
            height = posy + height - (sash.getBounds().y + this.sash_width + 1);
            if (j == count - 1) {
                SWTViewer viewer2 = (SWTViewer)children[j + 1];
                viewer2.setBounds(posx, posy, width, height);
            }
            j += 2;
        }
        this.first_layout = false;
    }

    private void verifyCompositeContents(Composite composite) {
        Control[] children = composite.getChildren();
        if (children == null) {
            throw new IllegalArgumentException("This layout should be composed of at least 3 children: a Viewer, a Sash and another Viewer");
        }
        int count = children.length;
        if (count < 3) {
            throw new IllegalArgumentException("This layout should be composed of at least 2 Controls and 1 Sash");
        }
        if (count % 2 != 0) {
            throw new IllegalArgumentException("This layout should be composed of a sequence [Control , (Sash , Control)+]");
        }
        Control child = children[0];
        if (!(child instanceof SWTViewer)) {
            throw new IllegalArgumentException("First child has to be an instance of SWTViewer");
        }
        int i = 1;
        while (i < count - 1) {
            child = children[i];
            if (!(child instanceof Sash)) {
                throw new IllegalArgumentException("This layout should be composed of a sequence [Control , (Sash , Control)+]");
            }
            child = children[i + 1];
            if (!(child instanceof SWTViewer)) {
                throw new IllegalArgumentException("This layout should be composed of a sequence [Control , (Sash , Control)+]");
            }
            i += 2;
        }
        if (count > 3) {
            int style = ((Sash)children[2]).getStyle();
            int j = 4;
            while (j < count) {
                if (((Sash)children[2]).getStyle() != style) {
                    throw new IllegalArgumentException("This layout should be composed of sashs with the same style");
                }
                j += 2;
            }
        }
    }

    public double getDefault_rate() {
        return this.default_rate;
    }

    public void setDefault_rate(double default_rate) {
        this.default_rate = default_rate;
    }

    private void setDefaultRate(int count) {
        this.default_rate = count < 3 ? 1.0 : (double)(1 / ((count + 1) / 2));
    }

    public int getSashWidth() {
        return this.sash_width;
    }

    public void setSashWidth(int sash_width) {
        this.sash_width = sash_width;
    }
}

