/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class NoOverviewScrollView
extends Canvas {
    public static final int AUTO = 0;
    public static final int ALWAYS_OFF = 2;
    public static final int ALWAYS_ON = 1;
    private int contents_height_ = 0;
    private int contents_width_ = 0;
    private int contents_x_ = 0;
    private int contents_y_ = 0;
    private int h_scrollbar_mode_ = 0;
    private int v_scrollbar_mode_ = 0;
    private int h_scrollbar_increment_ = 1;
    private int v_scrollbar_increment_ = 1;
    private boolean auto_scroll_enabled_ = true;
    private int auto_scroll_period_ = 75;
    private PaintListener localPaintListener = new PaintListener(){

        public void paintControl(PaintEvent event) {
            Rectangle r = NoOverviewScrollView.this.getClientArea();
            int cx = NoOverviewScrollView.this.viewToContentsX(r.x);
            int cy = NoOverviewScrollView.this.viewToContentsY(r.y);
            NoOverviewScrollView.this.drawContents(event.gc, cx, cy, r.width, r.height);
        }
    };
    private MouseMoveListener localMouseMoveListener = null;
    private MouseListener localMouseListener = null;
    private ControlListener localControlListener = null;
    private KeyListener localKeyListener = null;
    private int mouse_down_x_;
    private int mouse_down_y_;
    private AutoScroll auto_scroll_ = null;
    private Timer auto_scroll_timer_ = null;

    public NoOverviewScrollView(Composite c, int style) {
        super(c, style | 0x100 | 0x200);
        this.addPaintListener(this.localPaintListener);
        this.localMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = NoOverviewScrollView.this.viewToContentsX(e.x);
                e.y = NoOverviewScrollView.this.viewToContentsY(e.y);
                NoOverviewScrollView.this.contentsMouseMoveEvent(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.addMouseMoveListener(this.localMouseMoveListener);
        this.localMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = NoOverviewScrollView.this.viewToContentsX(e.x);
                e.y = NoOverviewScrollView.this.viewToContentsY(e.y);
                NoOverviewScrollView.this.contentsMouseDoubleClickEvent(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseDown(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = NoOverviewScrollView.this.viewToContentsX(e.x);
                e.y = NoOverviewScrollView.this.viewToContentsY(e.y);
                NoOverviewScrollView.this.contentsMouseDownEvent(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseUp(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = NoOverviewScrollView.this.viewToContentsX(e.x);
                e.y = NoOverviewScrollView.this.viewToContentsY(e.y);
                NoOverviewScrollView.this.contentsMouseUpEvent(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.addMouseListener(this.localMouseListener);
        this.localControlListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                NoOverviewScrollView.this.viewResizeEvent(e);
            }
        };
        this.addControlListener(this.localControlListener);
        this.localKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                NoOverviewScrollView.this.keyPressedEvent(e);
            }

            public void keyReleased(KeyEvent e) {
                NoOverviewScrollView.this.keyReleasedEvent(e);
            }
        };
        this.addKeyListener(this.localKeyListener);
        this.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NoOverviewScrollView.this.setContentsPos(NoOverviewScrollView.this.contents_x_, NoOverviewScrollView.this.getVerticalBar().getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getHorizontalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NoOverviewScrollView.this.setContentsPos(NoOverviewScrollView.this.getHorizontalBar().getSelection(), NoOverviewScrollView.this.contents_y_);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateScrollBars();
    }

    public void dispose() {
        if (this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
    }

    public void replaceControlListener(ControlListener nlistener) {
        if (this.localControlListener != null) {
            this.removeControlListener(this.localControlListener);
            this.localControlListener = null;
        }
        this.addControlListener(nlistener);
    }

    public void replaceKeyListener(KeyListener nlistener) {
        if (this.localKeyListener != null) {
            this.removeKeyListener(this.localKeyListener);
            this.localKeyListener = null;
        }
        this.addKeyListener(nlistener);
    }

    public void replaceMouseListener(MouseListener nlistener) {
        if (this.localMouseListener != null) {
            this.removeMouseListener(this.localMouseListener);
            this.localMouseListener = null;
        }
        this.addMouseListener(nlistener);
    }

    public void replaceMouseMoveListener(MouseMoveListener nlistener) {
        if (this.localMouseMoveListener != null) {
            this.removeMouseMoveListener(this.localMouseMoveListener);
            this.localMouseMoveListener = null;
        }
        this.addMouseMoveListener(nlistener);
    }

    public void replacePaintListener(PaintListener nlistener) {
        if (this.localPaintListener != null) {
            this.removePaintListener(this.localPaintListener);
            this.localPaintListener = null;
        }
        this.addPaintListener(nlistener);
    }

    public int getContentsHeight() {
        return this.contents_height_;
    }

    public int getContentsWidth() {
        return this.contents_width_;
    }

    public int getContentsX() {
        return this.contents_x_;
    }

    public int getContentsY() {
        return this.contents_y_;
    }

    public boolean getDragAutoScroll() {
        return this.auto_scroll_enabled_;
    }

    public void setDragAutoScroll(boolean aDragAutoScroll) {
        this.auto_scroll_enabled_ = aDragAutoScroll;
        if (!this.auto_scroll_enabled_ && this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
    }

    public void setDragAutoScrollPeriod(int _period) {
        this.auto_scroll_period_ = Math.max(0, _period);
    }

    public int getDragAutoScrollPeriod() {
        return this.auto_scroll_period_;
    }

    public int getHScrollBarMode() {
        return this.h_scrollbar_mode_;
    }

    public void setHScrollBarMode(int aHScrollBarMode) {
        this.h_scrollbar_mode_ = aHScrollBarMode;
    }

    public int getVScrollBarMode() {
        return this.v_scrollbar_mode_;
    }

    public void setVScrollBarMode(int aVScrollBarMode) {
        this.v_scrollbar_mode_ = aVScrollBarMode;
    }

    public int getHScrollBarIncrement() {
        return this.h_scrollbar_increment_;
    }

    public int getVScrollBarIncrement() {
        return this.v_scrollbar_increment_;
    }

    public void setHScrollBarIncrement(int _inc) {
        this.h_scrollbar_increment_ = Math.max(1, _inc);
    }

    public void setVScrollBarIncrement(int _inc) {
        this.v_scrollbar_increment_ = Math.max(1, _inc);
    }

    protected void contentsMouseDoubleClickEvent(MouseEvent e) {
    }

    protected void contentsMouseDownEvent(MouseEvent e) {
        this.mouse_down_x_ = e.x;
        this.mouse_down_y_ = e.y;
    }

    protected void contentsMouseMoveEvent(MouseEvent _event) {
        if ((_event.stateMask & SWT.BUTTON_MASK) != 0) {
            if (!this.auto_scroll_enabled_) {
                this.scrollBy(-(_event.x - this.mouse_down_x_), -(_event.y - this.mouse_down_y_));
                return;
            }
            int sx = 0;
            int sy = 0;
            int v_right = this.getContentsX() + this.getVisibleWidth();
            int v_bottom = this.getContentsY() + this.getVisibleHeight();
            if (_event.x < this.getContentsX()) {
                sx = -(this.getContentsX() - _event.x);
                this.mouse_down_x_ = this.getContentsX();
            } else if (_event.x > v_right) {
                sx = _event.x - v_right;
                this.mouse_down_x_ = v_right;
            }
            if (_event.y < this.getContentsY()) {
                sy = -(this.getContentsY() - _event.y);
                this.mouse_down_y_ = this.getContentsY();
            } else if (_event.y > v_bottom) {
                sy = _event.y - v_bottom;
                this.mouse_down_y_ = v_bottom;
            }
            if (sx != 0 || sy != 0) {
                if (this.auto_scroll_ == null) {
                    if (this.auto_scroll_timer_ == null) {
                        this.auto_scroll_timer_ = new Timer(true);
                    }
                    this.auto_scroll_ = new AutoScroll(this, sx, sy);
                    this.auto_scroll_timer_.schedule((TimerTask)this.auto_scroll_, 0L, (long)this.auto_scroll_period_);
                } else {
                    this.auto_scroll_.dx_ = sx;
                    this.auto_scroll_.dy_ = sy;
                }
            } else {
                if (this.auto_scroll_ != null) {
                    this.auto_scroll_.cancel();
                    this.auto_scroll_ = null;
                }
                this.scrollBy(-(_event.x - this.mouse_down_x_), -(_event.y - this.mouse_down_y_));
            }
        }
    }

    protected void contentsMouseUpEvent(MouseEvent _event) {
        if (this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
    }

    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
    }

    public void resizeContents(int _w, int _h) {
        int s;
        if (_w < 0) {
            _w = 0;
        }
        if (_h < 0) {
            _h = 0;
        }
        int oldW = this.contents_width_;
        int oldH = this.contents_height_;
        if (_w == oldW && _h == oldH) {
            return;
        }
        this.contents_width_ = _w;
        this.contents_height_ = _h;
        if (oldW > _w) {
            s = _w;
            _w = oldW;
            oldW = s;
        }
        if (oldW < this.getVisibleWidth()) {
            if (_w > this.getVisibleWidth()) {
                _w = this.getVisibleWidth();
            }
            this.redraw(this.getContentsX() + oldW, 0, _w - oldW, this.getVisibleHeight(), true);
        }
        if (oldH > _h) {
            s = _h;
            _h = oldH;
            oldH = s;
        }
        if (oldH < this.getVisibleHeight()) {
            if (_h > this.getVisibleHeight()) {
                _h = this.getVisibleHeight();
            }
            this.redraw(0, this.getContentsY() + oldH, this.getVisibleWidth(), _h - oldH, true);
        }
        this.updateScrollBars();
    }

    public void scrollBy(int _dx, int _dy) {
        this.setContentsPos(this.getContentsX() + _dx, this.getContentsY() + _dy);
    }

    public void ensureVisible(int _px, int _py) {
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth();
        int bottom = this.getContentsY() + this.getVisibleHeight();
        if (_px < this.getContentsX()) {
            cx = _px;
        } else if (_px > right) {
            cx = _px - this.getVisibleWidth();
        }
        if (_py < this.getContentsY()) {
            cy = _py;
        } else if (_py > bottom) {
            cy = _py - this.getVisibleHeight();
        }
        this.setContentsPos(cx, cy);
    }

    public void ensureVisible(int _x, int _y, int _w, int _h, int _align) {
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth();
        int bottom = this.getContentsY() + this.getVisibleHeight();
        boolean align_h = false;
        boolean align_v = false;
        if (_x < this.getContentsX()) {
            cx = _x;
            if (cx + _w > right) {
                align_h = true;
            }
        } else if (_x + _w > right && _x < (cx = right - _w)) {
            align_h = true;
        }
        if (_y < this.getContentsY()) {
            cy = _y;
            if (cy + _h > bottom) {
                align_h = true;
            }
        } else if (_y + _h > bottom && _y < (cy = bottom - _h)) {
            align_v = true;
        }
        if (align_h) {
            cx = (_align & 0x4000) != 0 ? _x : ((_align & 0x20000) != 0 ? right - _w : _x + (_w - this.getVisibleWidth()) / 2);
        }
        if (align_v) {
            cy = (_align & 0x80) != 0 ? _y : ((_align & 0x400) != 0 ? bottom - _h : _y + (_h - this.getVisibleHeight()) / 2);
        }
    }

    public boolean isVisible(int _px, int _py) {
        if (_px < this.getContentsX()) {
            return false;
        }
        if (_py < this.getContentsY()) {
            return false;
        }
        if (_px > this.getContentsX() + this.getVisibleWidth()) {
            return false;
        }
        return _py <= this.getContentsY() + this.getVisibleHeight();
    }

    public boolean isVisible(int _x, int _y, int _w, int _h) {
        if (_x + _w < this.getContentsX()) {
            return false;
        }
        if (_y + _h < this.getContentsY()) {
            return false;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (_x > vr) {
            return false;
        }
        return _y <= vb;
    }

    public Rectangle getVisiblePart(int _x, int _y, int _w, int _h) {
        if (_x + _w < this.getContentsX()) {
            return null;
        }
        if (_y + _h < this.getContentsY()) {
            return null;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (_x > vr) {
            return null;
        }
        if (_y > vb) {
            return null;
        }
        int rr = _x + _w;
        int rb = _y + _h;
        int nl = Math.max(_x, this.getContentsX());
        int nt = Math.max(_y, this.getContentsY());
        int nr = Math.min(rr, vr);
        int nb = Math.min(rb, vb);
        Rectangle c = new Rectangle(nl, nt, nr - nl, nb - nt);
        return c;
    }

    public final Rectangle getVisiblePart(Rectangle _r) {
        if (_r == null) {
            return null;
        }
        return this.getVisiblePart(_r.x, _r.y, _r.width, _r.height);
    }

    public void setContentsPos(int _x, int _y) {
        int nx = _x;
        int ny = _y;
        if (this.getVisibleWidth() >= this.getContentsWidth()) {
            nx = 0;
        } else if (_x < 0) {
            nx = 0;
        } else if (_x + this.getVisibleWidth() > this.getContentsWidth()) {
            nx = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (this.getVisibleHeight() >= this.getContentsHeight()) {
            ny = 0;
        } else if (_y <= 0) {
            ny = 0;
        } else if (_y + this.getVisibleHeight() > this.getContentsHeight()) {
            ny = this.getContentsHeight() - this.getVisibleHeight();
        }
        if (nx == this.contents_x_ && ny == this.contents_y_) {
            return;
        }
        this.contents_x_ = nx;
        this.contents_y_ = ny;
        this.updateScrollBars();
        this.redraw();
    }

    public void updateScrollBars() {
        block33: {
            ScrollBar b;
            block32: {
                block31: {
                    block30: {
                        b = this.getVerticalBar();
                        b.setMinimum(0);
                        b.setMaximum(this.getContentsHeight());
                        b.setThumb(this.getVisibleHeight());
                        b.setPageIncrement(this.getVisibleHeight());
                        b.setIncrement(this.v_scrollbar_increment_);
                        b.setSelection(this.getContentsY());
                        if (this.getContentsHeight() > this.getVisibleHeight()) break block30;
                        switch (this.v_scrollbar_mode_) {
                            case 0: {
                                if (b.isVisible()) {
                                    b.setVisible(false);
                                    break;
                                }
                                break block31;
                            }
                            case 2: {
                                if (b.isVisible()) {
                                    b.setVisible(false);
                                    break;
                                }
                                break block31;
                            }
                            case 1: {
                                if (b.isVisible()) break block31;
                                b.setVisible(true);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block31;
                    }
                    switch (this.v_scrollbar_mode_) {
                        case 0: {
                            if (b.isVisible()) break;
                            b.setVisible(true);
                            break;
                        }
                        case 2: {
                            if (!b.isVisible()) break;
                            b.setVisible(false);
                            break;
                        }
                        case 1: {
                            if (b.isVisible()) break;
                            b.setVisible(true);
                        }
                    }
                }
                b = this.getHorizontalBar();
                b.setMaximum(this.getContentsWidth());
                b.setThumb(this.getVisibleWidth());
                b.setSelection(this.getContentsX());
                b.setPageIncrement(this.getVisibleWidth());
                b.setIncrement(this.h_scrollbar_increment_);
                if (this.getContentsWidth() > this.getVisibleWidth()) break block32;
                switch (this.h_scrollbar_mode_) {
                    case 0: {
                        if (b.isVisible()) {
                            b.setVisible(false);
                            break;
                        }
                        break block33;
                    }
                    case 2: {
                        if (b.isVisible()) {
                            b.setVisible(false);
                            break;
                        }
                        break block33;
                    }
                    case 1: {
                        if (b.isVisible()) break block33;
                        b.setVisible(true);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block33;
            }
            switch (this.h_scrollbar_mode_) {
                case 0: {
                    if (b.isVisible()) break;
                    b.setVisible(true);
                    break;
                }
                case 2: {
                    if (!b.isVisible()) break;
                    b.setVisible(false);
                    break;
                }
                case 1: {
                    if (b.isVisible()) break;
                    b.setVisible(true);
                }
            }
        }
    }

    public final Point viewToContents(int _x, int _y) {
        Point p = new Point(this.viewToContentsX(_x), this.viewToContentsY(_y));
        return p;
    }

    public int viewToContentsX(int _x) {
        return this.contents_x_ + _x;
    }

    public int viewToContentsY(int _y) {
        return this.contents_y_ + _y;
    }

    public final Point contentsToView(int _x, int _y) {
        Point p = new Point(this.contentsToViewX(_x), this.contentsToViewY(_y));
        return p;
    }

    public int contentsToViewX(int _x) {
        return _x - this.contents_x_;
    }

    public int contentsToViewY(int _y) {
        return _y - this.contents_y_;
    }

    public int getVisibleHeight() {
        Rectangle r = this.getClientArea();
        return r.height;
    }

    public int getVisibleWidth() {
        Rectangle r = this.getClientArea();
        return r.width;
    }

    protected void keyPressedEvent(KeyEvent _e) {
        switch (_e.keyCode) {
            case 0x1000001: {
                this.scrollBy(0, -this.getVisibleHeight());
                break;
            }
            case 0x1000002: {
                this.scrollBy(0, this.getVisibleHeight());
                break;
            }
            case 0x1000003: {
                this.scrollBy(-this.getVisibleWidth(), 0);
                break;
            }
            case 0x1000004: {
                this.scrollBy(this.getVisibleWidth(), 0);
            }
        }
    }

    protected void keyReleasedEvent(KeyEvent _e) {
    }

    protected void viewResizeEvent(ControlEvent _event) {
        int ocx = this.getContentsX();
        int ocy = this.getContentsY();
        this.setContentsPos(ocx, ocy);
        if (ocx == this.getContentsX() && ocy == this.getContentsY()) {
            this.updateScrollBars();
        }
    }

    public static void main(String[] argv) {
        Display disp = Display.getDefault();
        Shell shell = new Shell(disp, 2160);
        final Image img = new Image(null, "C:\\manometer.png");
        NoOverviewScrollView sv = new NoOverviewScrollView((Composite)shell, 262144){

            public void drawContents(GC _gc, int _x, int _y, int _w, int _h) {
                Rectangle r = this.getClientArea();
                _gc.setBackground(new Color(null, 255, 255, 255));
                _gc.fillRectangle(r.x, r.y, r.width, r.height);
                _gc.setForeground(new Color(null, 255, 0, 0));
                Point cpl = this.contentsToView(0, 0);
                Point cpr = this.contentsToView(this.getContentsWidth(), this.getContentsHeight());
                _gc.drawLine(cpl.x, cpl.y, cpr.x, cpr.y);
                _gc.drawLine(cpl.x, cpr.y, cpr.x, cpl.y);
                _gc.setForeground(new Color(null, 0, 255, 0));
                _gc.drawLine(0, 0, r.width, r.height);
                _gc.drawLine(0, r.height, r.width, 0);
                _gc.setForeground(new Color(null, 0, 0, 255));
                _gc.setBackground(new Color(null, 0, 0, 255));
                if (this.isVisible(100, 200, 100, 50)) {
                    _gc.fillRectangle(this.contentsToViewX(100), this.contentsToViewY(200), 100, 50);
                }
                Rectangle rimg = img.getBounds();
                if (this.isVisible(500, 500, rimg.width, rimg.height)) {
                    _gc.drawImage(img, this.contentsToViewX(500), this.contentsToViewY(500));
                }
            }
        };
        sv.resizeContents(1000, 1000);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(400, 300);
        shell.open();
        while (!shell.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
    }

    private static class AutoScroll
    extends TimerTask {
        public int dx_;
        public int dy_;
        public NoOverviewScrollView sv_;

        public AutoScroll(NoOverviewScrollView _sv, int _dx, int _dy) {
            this.sv_ = _sv;
            this.dx_ = _dx;
            this.dy_ = _dy;
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AutoScroll.this.sv_.scrollBy(AutoScroll.this.dx_, AutoScroll.this.dy_);
                }
            });
        }
    }
}

