/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ScreenPreview
extends Canvas {
    public static final int SCREEN_W = 200;
    public static final int SCREEN_H = 100;
    Rectangle windowRect;
    Rectangle pageRect;

    public ScreenPreview(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ScreenPreview.this.paintEvent(event);
            }
        });
    }

    public void setRectangles(Rectangle wr, Rectangle pr) {
        this.windowRect = wr;
        this.pageRect = pr;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(201, 101);
    }

    protected void paintEvent(PaintEvent event) {
        event.gc.getClipping();
        Display disp = this.getDisplay();
        Color back = new Color((Device)disp, 176, 176, 176);
        Color pen = disp.getSystemColor(2);
        Color bpage = disp.getSystemColor(1);
        GC gc = event.gc;
        if (this.windowRect == null) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, 200, 100);
            gc.setForeground(pen);
            gc.drawRectangle(0, 0, 200, 100);
            return;
        }
        Rectangle cdr = disp.getBounds();
        int sw = cdr.width;
        int sh = cdr.height;
        int ww = (int)((float)this.windowRect.width / (float)sw * 200.0f);
        int wh = (int)((float)this.windowRect.height / (float)sh * 100.0f);
        int wx = 0;
        int wy = 0;
        if ((this.getStyle() & 0x1000000) != 0) {
            wx = (200 - ww) / 2;
            wy = (100 - wh) / 2;
        } else {
            wx = (int)((float)this.windowRect.x / (float)sw * 200.0f);
            wy = (int)((float)this.windowRect.y / (float)sh * 100.0f);
        }
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, wx, 100);
        gc.fillRectangle(wx + ww, 0, wx, 100);
        gc.fillRectangle(wx, 0, ww, wy);
        gc.fillRectangle(wx, wy + wh, ww, wy + 1);
        gc.drawRectangle(0, 0, 200, 100);
        gc.setBackground(back);
        gc.setForeground(pen);
        gc.fillRectangle(wx, wy, ww, wh);
        gc.drawRectangle(wx, wy, ww, wh);
        if (this.pageRect == null) {
            return;
        }
        int pw = Math.round((float)(this.pageRect.width * 200) / (float)sw);
        int ph = (int)((float)(this.pageRect.height * 100) / (float)sh);
        int px = wx;
        int py = wy;
        if ((this.getStyle() & 0x1000000) != 0) {
            px += (ww - pw) / 2;
        } else {
            px += Math.round((float)(this.pageRect.x * 200) / (float)sw + 1.0f);
            py += Math.round((float)(this.pageRect.y * 100) / (float)sh + 1.0f);
        }
        ph -= 2;
        if (pw > ww) {
            px = wx;
            pw = ww;
        }
        if (ph > wh) {
            ph = wh - 1;
        }
        gc.setBackground(bpage);
        gc.fillRectangle(px, py, pw, ph);
        gc.drawRectangle(px, py, pw, ph);
    }
}

