/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ToolTipRedrawer
implements PaintListener {
    protected Control parentControl = null;
    protected Shell toolTipShell = null;
    protected String toolTipText = null;

    public ToolTipRedrawer(Control _parent) {
        this.parentControl = _parent;
        this.toolTipShell = new Shell(this.parentControl.getShell(), 540672);
        this.toolTipShell.setLayout((Layout)new RowLayout());
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.toolTipShell.addPaintListener((PaintListener)this);
        this.toolTipShell.setSize(10, 10);
        this.toolTipShell.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 13;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ToolTipRedrawer.this.toolTipText;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 4;
            }
        });
    }

    public void showToolTip(String text) {
        if (text == null || text.equalsIgnoreCase("")) {
            this.toolTipShell.setVisible(false);
            return;
        }
        boolean repaint = false;
        if (this.toolTipShell.getVisible() && !text.equals(this.toolTipText)) {
            repaint = true;
        }
        this.toolTipText = text;
        int w = this.toolTipShell.getBounds().width;
        Point xy = Display.getDefault().getCursorLocation();
        int h_cursor = 32;
        int i = 0;
        while (i < Display.getDefault().getCursorSizes().length) {
            if (Display.getDefault().getCursorSizes()[i].y < h_cursor) {
                h_cursor = Display.getDefault().getCursorSizes()[i].y;
            }
            ++i;
        }
        if (xy.x + w > Display.getDefault().getBounds().width) {
            int tempX = xy.x + w - Display.getDefault().getBounds().width;
            if (tempX > Display.getDefault().getBounds().width) {
                xy.x = 0;
            }
            xy.x -= tempX;
        }
        this.toolTipShell.setLocation(xy.x, xy.y + h_cursor);
        if (repaint) {
            this.toolTipShell.setVisible(false);
        }
        this.toolTipShell.setVisible(true);
        this.toolTipShell.getAccessible().setFocus(this.parentControl.handle);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }

    public void paintControl(PaintEvent event) {
        Point xy = event.gc.textExtent(this.toolTipText);
        event.gc.drawText(this.toolTipText, 2, 0, true);
        this.toolTipShell.setSize(xy.x + 6, xy.y + 2);
    }
}

