/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;
import org.eclipse.hyades.test.tools.ui.common.internal.report.DescendingVisitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.ReportDataUtils;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.ReportGraphicUtils;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.StylesInitializer;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.TestSuiteVisitor;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

public class JscribWriter
extends DescendingVisitor {
    private DStyleRegistry styleRegistry = null;
    protected Map resultsByTestSuiteMap = new HashMap();
    protected Map resultsByExecutionMap = new HashMap();
    protected Map execsByTestSuiteMap = new HashMap();
    private int[] resultSet = new int[4];

    public DSection[] generate(Map executionsByTestsuiteMap_in, long startTime, long endTime, IProgressMonitor monitor) throws Exception {
        try {
            TreeMap executionsByTestsuiteMap = new TreeMap(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof TPFTestSuiteImpl && arg1 instanceof TPFTestSuiteImpl) {
                        String n1 = ((TPFTestSuiteImpl)arg0).getName();
                        String n2 = ((TPFTestSuiteImpl)arg1).getName();
                        return n1.compareTo(n2);
                    }
                    return 0;
                }
            });
            executionsByTestsuiteMap.putAll(executionsByTestsuiteMap_in);
            this.styleRegistry = StylesInitializer.getDefaultReportStyles();
            monitor.beginTask(SamplesPluginResourceBundle.JScribWriter_Message, 5);
            monitor.worked(1);
            DSection detailsDocument = this.createDetailsDocument(executionsByTestsuiteMap, startTime, endTime);
            monitor.worked(1);
            DSection graphicSection = new DSection("graphic_section");
            graphicSection.addChild((IDItem)ReportGraphicUtils.createTitle(SamplesPluginResourceBundle.JScribWriter_Overview, 1, this.getStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE1), null));
            DTable graphTable = new DTable();
            graphTable.setBorder(0);
            graphicSection.addChild((IDItem)graphTable);
            graphTable.addChild((IDItem)new DRow());
            DCell[] graphCell = new DCell[2];
            graphCell[0] = new DCell();
            graphTable.getFirstChild().addChild((IDItem)graphCell[0]);
            graphCell[1] = new DCell();
            graphTable.getFirstChild().addChild((IDItem)graphCell[1]);
            graphCell[0].addChild(this.createSummaryChart());
            monitor.worked(1);
            graphCell[1].addChild(this.createSummaryTable(executionsByTestsuiteMap, startTime, endTime));
            monitor.worked(1);
            DSection[] dSectionArray = new DSection[]{graphicSection, detailsDocument};
            return dSectionArray;
        }
        finally {
            monitor.done();
        }
    }

    private DSection createDetailsDocument(Map executionsByTestsuiteMap, long startTime, long endTime) throws Exception {
        DSection indexSection = new DSection("index");
        DItem title = ReportGraphicUtils.createTitle(SamplesPluginResourceBundle.JScribWriter_ResultsByTestSuite, 1, this.getStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE1), null);
        indexSection.addChild((IDItem)title);
        DParagraph paragraph = new DParagraph();
        indexSection.addChild((IDItem)paragraph);
        for (TPFTestSuite testSuite : executionsByTestsuiteMap.keySet()) {
            this.accept(new TestSuiteVisitor(executionsByTestsuiteMap, startTime, endTime), testSuite, (DItem)paragraph);
        }
        indexSection.insertChild(this.createByTestSuiteChart(), (IDItem)title);
        return indexSection;
    }

    private IDItem createSummaryTable(Map executionsByTestsuiteMap, long startTime, long endTime) {
        DParagraph p = new DParagraph();
        DTable table = new DTable();
        p.addChild((IDItem)table);
        this.createStatsSummary(table, executionsByTestsuiteMap, startTime, endTime);
        return p;
    }

    private void createStatsSummary(DTable table, Map executionsByTestsuiteMap, long startTime, long endTime) {
        this.createTestSuitesRow(table, executionsByTestsuiteMap.keySet());
        int verdict = ReportDataUtils.getVerdict(this.resultSet);
        this.createRow(table, SamplesPluginResourceBundle.JScribWriter_Verdict, this.getVerdictLabel(verdict), 1, this.getVerdictCellStyle(verdict));
        this.createRow(table, SamplesPluginResourceBundle.JScribWriter_CreationDate, EventUtil.getTime((long)Calendar.getInstance().getTimeInMillis()), 1);
        this.createRow(table, SamplesPluginResourceBundle.JScribWriter_StartTime, EventUtil.getTime((long)startTime), 1);
        this.createRow(table, SamplesPluginResourceBundle.JScribWriter_EndTime, EventUtil.getTime((long)endTime), 1);
        this.createVerdictRows(table);
    }

    private void createRow(DTable table, String headerText, String valueText, int colspan) {
        this.createRow(table, headerText, valueText, colspan, null);
    }

    private void createRow(DTable table, String headerText, String valueText, int colspan, IDStyle style) {
        DRow row = new DRow();
        DCell c1 = ReportGraphicUtils.createStyledCell(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL), 1, headerText);
        DCell c2 = ReportGraphicUtils.createStyledCell(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL), 1, valueText);
        c1.setColSpan(colspan);
        c2.setColSpan(colspan);
        if (style != null) {
            c2.setStyle(style);
        }
        row.addChild((IDItem)c1);
        row.insertChild((IDItem)c2, (IDItem)c1);
        table.addChild((IDItem)row);
    }

    private void createTestSuitesRow(DTable table, Collection testSuites) {
        DRow row1 = new DRow();
        DRow row2 = new DRow();
        DCell c1 = ReportGraphicUtils.createStyledCell(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL), 33, SamplesPluginResourceBundle.JScribWriter_TestSuites);
        DCell c2 = ReportGraphicUtils.createReportLinksCell(testSuites, this.getStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL), this.getStyle(SamplesPluginResourceBundle.StylesInitializer_LINK_CELL));
        c1.setColSpan(3);
        c2.setColSpan(3);
        row1.addChild((IDItem)c1);
        row2.addChild((IDItem)c2);
        table.addChild((IDItem)row1);
        table.addChild((IDItem)row2);
    }

    private void createVerdictRows(DTable table) {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] verdicts = nArray;
        DCell previous = null;
        int i = 0;
        int max = this.resultSet.length;
        while (i < max) {
            DRow row = new DRow();
            DCell c1 = ReportGraphicUtils.createStyledCell(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL), 1, this.getVerdictLabel(verdicts[i]));
            DCell c2 = ReportGraphicUtils.createStyledCell(this.getVerdictCellStyle(verdicts[i]), this.getVerdictCellTextStyle(verdicts[i]), 1, ReportDataUtils.normalize(this.resultSet[i]));
            if (previous == null) {
                row.addChild((IDItem)c1);
            } else {
                row.insertChild((IDItem)c1, previous);
            }
            row.insertChild((IDItem)c2, (IDItem)c1);
            table.addChild((IDItem)row);
            previous = null;
            if (i % 2 == 0) {
                previous = c2;
            }
            ++i;
        }
    }

    private IDItem createSummaryChart() {
        int total = this.resultSet[0] + this.resultSet[1] + this.resultSet[2] + this.resultSet[3];
        double passPercentage = this.getPercent(this.resultSet[0], total);
        double inconclusivePercentage = this.getPercent(this.resultSet[1], total);
        double failPercentage = this.getPercent(this.resultSet[2], total);
        double errorPercentage = this.getPercent(this.resultSet[3], total);
        if (passPercentage == 0.0 && inconclusivePercentage == 0.0 && failPercentage == 0.0 && errorPercentage == 0.0) {
            DParagraph p = new DParagraph(36);
            p.addChild((IDItem)new DText(SamplesPluginResourceBundle.JScribWriter_NO_CHART_VALUE));
            p.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_GENERATION_ERROR));
            return p;
        }
        DGraphic pieChart = new DGraphic();
        pieChart.setGraphicType("T_SECTORS3D.DGraphic.core.jscrib");
        pieChart.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_CHART_TITLE));
        pieChart.setTitle(SamplesPluginResourceBundle.JScribWriter_Title_ExecutionResultsRepartition);
        pieChart.getProperties().store("P_VALUE_FORMAT.DGraphic.core.jscrib", (Object)"##.##");
        pieChart.getProperties().store("P_SHOW_PERCENTAGE.DGraphic.core.jscrib", true);
        pieChart.getProperties().store("P_SHOW_VALUES.DGraphic.core.jscrib", false);
        DAxis axis = new DAxis("y", SamplesPluginResourceBundle.JScribWriter_Symbol_Percentage, SamplesPluginResourceBundle.JScribWriter_Values);
        axis.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", (Object)"number");
        axis.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", (Object)"##.##");
        pieChart.addChild((IDItem)axis);
        DAxis catAxis = new DAxis("x");
        DCategory category = new DCategory();
        category.setId("c1");
        category.setLabel(SamplesPluginResourceBundle.JScribWriter_Pass);
        catAxis.addChild((IDItem)category);
        category = new DCategory();
        category.setId("c2");
        category.setLabel(SamplesPluginResourceBundle.JScribWriter_Inconclusive);
        catAxis.addChild((IDItem)category);
        category = new DCategory();
        category.setId("c3");
        category.setLabel(SamplesPluginResourceBundle.JScribWriter_Fail);
        catAxis.addChild((IDItem)category);
        category = new DCategory();
        category.setId("c4");
        category.setLabel(SamplesPluginResourceBundle.JScribWriter_Error);
        catAxis.addChild((IDItem)category);
        pieChart.addChild((IDItem)catAxis);
        DCurve curvePass = new DCurve();
        curvePass.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_PASS));
        curvePass.setType("SECTOR.DCurve.core.jscrib");
        curvePass.setName(SamplesPluginResourceBundle.JScribWriter_Pass);
        DPoint pointPass = new DPoint();
        DCoord coordPass = new DCoord(axis, passPercentage);
        DCoordObject categoryCoord = new DCoordObject(catAxis, (Object)"c1");
        pointPass.addChild((IDItem)coordPass);
        pointPass.addChild((IDItem)categoryCoord);
        curvePass.addChild((IDItem)pointPass);
        pieChart.addChild((IDItem)curvePass);
        DCurve curveInconclusive = new DCurve();
        curveInconclusive.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE));
        curveInconclusive.setType("SECTOR.DCurve.core.jscrib");
        curveInconclusive.setName(SamplesPluginResourceBundle.JScribWriter_Inconclusive);
        DPoint pointInconclusive = new DPoint();
        DCoord coordInconclusive = new DCoord(axis, inconclusivePercentage);
        DCoordObject coordInconclusiveCategory = new DCoordObject(catAxis, (Object)"c2");
        pointInconclusive.addChild((IDItem)coordInconclusive);
        pointInconclusive.addChild((IDItem)coordInconclusiveCategory);
        curveInconclusive.addChild((IDItem)pointInconclusive);
        pieChart.addChild((IDItem)curveInconclusive);
        DCurve curveFail = new DCurve();
        curveFail.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL));
        curveFail.setType("SECTOR.DCurve.core.jscrib");
        curveFail.setName(SamplesPluginResourceBundle.JScribWriter_Fail);
        DPoint pointFail = new DPoint();
        DCoord coordFail = new DCoord(axis, failPercentage);
        DCoordObject coordFailCategory = new DCoordObject(catAxis, (Object)"c3");
        pointFail.addChild((IDItem)coordFailCategory);
        pointFail.addChild((IDItem)coordFail);
        curveFail.addChild((IDItem)pointFail);
        pieChart.addChild((IDItem)curveFail);
        DCurve curveError = new DCurve();
        curveError.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR));
        curveError.setType("SECTOR.DCurve.core.jscrib");
        curveError.setName(SamplesPluginResourceBundle.JScribWriter_Error);
        DPoint pointError = new DPoint();
        DCoord coordError = new DCoord(axis, errorPercentage);
        DCoordObject coordErrorCategory = new DCoordObject(catAxis, (Object)"c4");
        pointError.addChild((IDItem)coordErrorCategory);
        pointError.addChild((IDItem)coordError);
        curveError.addChild((IDItem)pointError);
        pieChart.addChild((IDItem)curveError);
        return pieChart;
    }

    public double getPercent(int iPart, int iWhole) {
        return iWhole == 0 ? 0.0 : (double)iPart / (double)iWhole * 100.0;
    }

    private IDItem createByTestSuiteChart() {
        HashMap<TPFTestSuite, int[]> validData = new HashMap<TPFTestSuite, int[]>();
        for (TPFTestSuite ts : this.resultsByTestSuiteMap.keySet()) {
            int[] res = (int[])this.resultsByTestSuiteMap.get(ts);
            if (res[0] == 0 && res[1] == 0 && res[2] == 0 && res[3] == 0) continue;
            validData.put(ts, res);
        }
        if (validData.size() == 0) {
            DParagraph p = new DParagraph(36);
            p.addChild((IDItem)new DText(SamplesPluginResourceBundle.JScribWriter_NO_CHART_VALUE));
            p.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_GENERATION_ERROR));
            return p;
        }
        DGraphic stackbar = new DGraphic();
        stackbar.setGraphicType("T_STACKBARS.DGraphic.core.jscrib");
        stackbar.setTitle(SamplesPluginResourceBundle.JScribWriter_Title_ExecutionResultsByTestSuite);
        stackbar.getProperties().store("P_3D.DGraphic.core.jscrib", true);
        stackbar.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
        int wHint = validData.size() * 20 > 500 ? validData.size() * 20 : 500;
        stackbar.getProperties().store("P_MAX_WIDTH.DGraphic.core.jscrib", wHint);
        stackbar.getProperties().store("P_MAX_HEIGHT.DGraphic.core.jscrib", wHint);
        stackbar.getProperties().store("P_MIN_WIDTH.DGraphic.core.jscrib", wHint);
        stackbar.getProperties().store("P_MIN_HEIGHT.DGraphic.core.jscrib", wHint);
        int max = 0;
        for (TPFTestSuite ts : validData.keySet()) {
            int[] res = (int[])validData.get(ts);
            int val = res[0] + res[1] + res[2] + res[3];
            max = Math.max(val, max);
        }
        if (max > 10) {
            max = (int)Math.ceil((double)max / 10.0) * 10;
        }
        DAxis axis_y = new DAxis("y", "", "");
        axis_y.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", max / 2);
        axis_y.getProperties().store("P_STEP_DOT.DAxis.core.jscrib", max / 4);
        axis_y.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL));
        axis_y.getProperties().store("P_MAJUNIT_VALUE.DAxis.core.jscrib", max / 2);
        axis_y.getProperties().store("P_MINUNIT_VALUE.DAxis.core.jscrib", max / 4);
        axis_y.getProperties().store("P_MAX.DAxis.core.jscrib", max);
        stackbar.addChild((IDItem)axis_y);
        DAxis axis_x = new DAxis("x", "", "");
        axis_x.getProperties().store("P_LABEL_ALIGNMENT.DAxis.core.jscrib", (Object)new DAlignment(8));
        axis_x.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL));
        stackbar.addChild((IDItem)axis_x);
        DCurve curvePass = new DCurve();
        curvePass.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_PASS));
        curvePass.setType("SECTOR.DCurve.core.jscrib");
        curvePass.setName(SamplesPluginResourceBundle.JScribWriter_Pass);
        DCurve curveInconclusive = new DCurve();
        curveInconclusive.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE));
        curveInconclusive.setType("SECTOR.DCurve.core.jscrib");
        curveInconclusive.setName(SamplesPluginResourceBundle.JScribWriter_Inconclusive);
        DCurve curveError = new DCurve();
        DCurve curveFail = new DCurve();
        curveFail.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL));
        curveFail.setType("SECTOR.DCurve.core.jscrib");
        curveFail.setName(SamplesPluginResourceBundle.JScribWriter_Fail);
        curveError.setStyle(this.getStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR));
        curveError.setType("SECTOR.DCurve.core.jscrib");
        curveError.setName(SamplesPluginResourceBundle.JScribWriter_Error);
        for (TPFTestSuite ts : validData.keySet()) {
            int[] res = (int[])validData.get(ts);
            DCategory cat = new DCategory();
            cat.setId(ts.getName());
            cat.setLabel(ts.getName());
            axis_x.addChild((IDItem)cat);
            DPoint pointPass = new DPoint();
            DCoord coordPass = new DCoord(axis_y, (double)res[0]);
            DText txt = new DText(ts.getName());
            pointPass.addChild((IDItem)coordPass);
            pointPass.addChild((IDItem)new DCoordObject(axis_x, (Object)ts.getName()));
            pointPass.addChild((IDItem)txt);
            curvePass.addChild((IDItem)pointPass);
            DPoint pointInconclusive = new DPoint();
            DCoord coordInconclusive = new DCoord(axis_y, (double)res[1]);
            pointInconclusive.addChild((IDItem)coordInconclusive);
            pointInconclusive.addChild((IDItem)new DCoordObject(axis_x, (Object)ts.getName()));
            curveInconclusive.addChild((IDItem)pointInconclusive);
            DPoint pointFail = new DPoint();
            DCoord coordFail = new DCoord(axis_y, (double)res[2]);
            pointFail.addChild((IDItem)coordFail);
            pointFail.addChild((IDItem)new DCoordObject(axis_x, (Object)ts.getName()));
            curveFail.addChild((IDItem)pointFail);
            DPoint pointError = new DPoint();
            DCoord coordError = new DCoord(axis_y, (double)res[3]);
            pointError.addChild((IDItem)coordError);
            pointError.addChild((IDItem)new DCoordObject(axis_x, (Object)ts.getName()));
            curveError.addChild((IDItem)pointError);
        }
        stackbar.addChild((IDItem)curvePass);
        stackbar.addChild((IDItem)curveInconclusive);
        stackbar.addChild((IDItem)curveFail);
        stackbar.addChild((IDItem)curveError);
        return stackbar;
    }

    public IDStyle getStyle(String styleName) {
        IDStyle ret = this.styleRegistry.getFirstStyle(styleName);
        return ret;
    }

    public DCellText generateRateCell(int numerator, int denominator, boolean increasingGradiant, IDStyle style) {
        double rate = 0.0;
        if (numerator > 0 && denominator > 0) {
            rate = (double)numerator / (double)denominator;
        }
        int green = 255;
        int blue = 255;
        if (rate > 0.0 && rate < 1.0 || rate == 0.0 && !increasingGradiant) {
            green = blue = Math.abs((increasingGradiant ? 225 : 0) - (int)(rate * 225.0));
        }
        NumberFormat numberFormatter = NumberFormat.getInstance();
        numberFormatter.setMaximumFractionDigits(2);
        String cellValue = String.valueOf(numberFormatter.format(rate * 100.0)) + "%";
        DCellText rateCell = new DCellText(cellValue);
        String styleName = NLS.bind((String)SamplesPluginResourceBundle.StylesInitializer_RATE_CELL, (Object)cellValue);
        IDStyle styleCell = this.getStyle(styleName);
        if (styleCell == null) {
            styleCell = new DStyle(styleName, style);
            this.styleRegistry.putStyle(styleCell);
        }
        styleCell.setBackColor((IDColor)new DColor(255, green, blue));
        rateCell.setStyle(styleCell);
        return rateCell;
    }

    public String getVerdictLabel(int verdict) {
        switch (verdict) {
            case 3: {
                return SamplesPluginResourceBundle.JScribWriter_Error;
            }
            case 2: {
                return SamplesPluginResourceBundle.JScribWriter_Fail;
            }
            case 0: {
                return SamplesPluginResourceBundle.JScribWriter_Inconclusive;
            }
            case 1: {
                return SamplesPluginResourceBundle.JScribWriter_Pass;
            }
        }
        return SamplesPluginResourceBundle.JScribWriter_NoVerdict;
    }

    public IDStyle getVerdictCellStyle(int verdict) {
        switch (verdict) {
            case 3: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR_CELL);
            }
            case 2: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL_CELL);
            }
            case 0: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE_CELL);
            }
            case 1: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_PASS_CELL);
            }
        }
        return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL);
    }

    public IDStyle getVerdictCellTextStyle(int verdict) {
        switch (verdict) {
            case 3: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR_CELL_TEXT);
            }
            case 2: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL_CELL_TEXT);
            }
            case 0: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE_CELL_TEXT);
            }
            case 1: {
                return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_PASS_CELL_TEXT);
            }
        }
        return this.getStyle(SamplesPluginResourceBundle.StylesInitializer_PASS_CELL_TEXT);
    }

    public void addToResults(int[] newResultSet) {
        int i = 0;
        int max = this.resultSet.length;
        while (i < max) {
            int n = i;
            this.resultSet[n] = this.resultSet[n] + newResultSet[i];
            ++i;
        }
    }
}

