/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.util.ExecutionUtil;

public class ReportDataUtils {
    public static String normalize(int i) {
        return NumberFormat.getInstance().format((long)i);
    }

    public static int getVerdict(int[] results) {
        if (results[3] > 0) {
            return 3;
        }
        if (results[2] > 0) {
            return 2;
        }
        if (results[1] > 0) {
            return 0;
        }
        if (results[0] > 0) {
            return 1;
        }
        return -1;
    }

    public static List getExecutionResultsForWindow(List executionResults, long startTime, long endTime) {
        ArrayList<TPFExecutionResult> executionResultsWithinWindow = new ArrayList<TPFExecutionResult>();
        TPFExecutionResult currentExecutionResult2 = null;
        long currentTimeStamp = 0L;
        EList executionEvents = null;
        for (TPFExecutionResult currentExecutionResult2 : executionResults) {
            executionEvents = currentExecutionResult2.getExecutionHistory().getExecutionEvents();
            if (executionEvents.size() <= 0 || (currentTimeStamp = ((TPFExecutionEvent)executionEvents.get(0)).getTimestamp()) < startTime || currentTimeStamp > endTime || (currentTimeStamp = ((TPFExecutionEvent)executionEvents.get(executionEvents.size() - 1)).getTimestamp()) < startTime || currentTimeStamp > endTime) continue;
            executionResultsWithinWindow.add(currentExecutionResult2);
        }
        return executionResultsWithinWindow;
    }

    public static int resolveTestCaseCount(TPFTestSuite testSuite) {
        int testCaseCount = 0;
        Iterator interactionFragmentsIterator = null;
        Iterator referencedSuitesIterator = ReportDataUtils.getReferencedTestSuites(testSuite).iterator();
        while (referencedSuitesIterator.hasNext()) {
            interactionFragmentsIterator = ((TPFTestSuite)referencedSuitesIterator.next()).getBehavior().getInteraction().getInteractionFragments().iterator();
            while (interactionFragmentsIterator.hasNext()) {
                testCaseCount += ReportDataUtils.resolveExecutionOccurrences((BVRInteractionFragment)interactionFragmentsIterator.next());
            }
        }
        return testCaseCount;
    }

    public static int resolveExecutionOccurrences(BVRInteractionFragment interactionFragment) {
        int executionOccurrences = 0;
        if (interactionFragment instanceof BVRExecutionOccurrence) {
            if (((BVRExecutionOccurrence)interactionFragment).getOtherBehavior().getResource() != null) {
                ++executionOccurrences;
            }
        } else if (interactionFragment instanceof BVRCombinedFragment) {
            Iterator interactionOperandsIterator = ((BVRCombinedFragment)interactionFragment).getInteractionOperands().iterator();
            Iterator interactionFragmentsIterator = null;
            BVRInteractionOperand interactionOperand = null;
            while (interactionOperandsIterator.hasNext()) {
                interactionOperand = (BVRInteractionOperand)interactionOperandsIterator.next();
                interactionFragmentsIterator = interactionOperand.getInteractionFragments().iterator();
                while (interactionFragmentsIterator.hasNext()) {
                    executionOccurrences += ReportDataUtils.resolveExecutionOccurrences((BVRInteractionFragment)interactionFragmentsIterator.next());
                }
                try {
                    executionOccurrences *= Integer.parseInt(interactionOperand.getInteractionConstraint().getConstraint());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return executionOccurrences;
    }

    public static EList getReferencedTestSuites(TPFTestSuite rootTestSuite) {
        BasicEList referencedTestSuites = new BasicEList();
        ExecutionUtil.addReferencedTestSuites((TPFTestSuite)rootTestSuite, (List)referencedTestSuites);
        return referencedTestSuites;
    }

    public static EList getReferencedTestSuites(EList rootTestSuites) {
        BasicEList referencedTestSuites = new BasicEList();
        Iterator rootTestSuitesIterator = rootTestSuites.iterator();
        while (rootTestSuitesIterator.hasNext()) {
            ExecutionUtil.addReferencedTestSuites((TPFTestSuite)((TPFTestSuite)rootTestSuitesIterator.next()), (List)referencedTestSuites);
        }
        return referencedTestSuites;
    }

    public static List findAllVerdictEvents(TPFExecutionHistory executionHistory) {
        return ReportDataUtils.findAllVerdicts((List)executionHistory.getExecutionEvents());
    }

    public static List findAllVerdicts(List tpfExecutionEvents) {
        ArrayList<TPFVerdict> verdicts = new ArrayList<TPFVerdict>();
        Iterator iterator = tpfExecutionEvents.iterator();
        while (iterator.hasNext()) {
            try {
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)iterator.next();
                if (executionEvent instanceof TPFInvocationEvent) {
                    TPFExecutionResult invokedExecutionResult = ((TPFInvocationEvent)executionEvent).getInvokedExecutionResult();
                    verdicts.add(invokedExecutionResult.getVerdict());
                }
                verdicts.addAll(ReportDataUtils.findAllVerdicts((List)executionEvent.getChildren()));
            }
            catch (ClassCastException classCastException) {}
        }
        return verdicts;
    }

    public static TPFVerdictEvent arbitrateVerdictEvent(List executionEvents) {
        TPFVerdictEvent verdictEvent = null;
        TPFVerdictEvent currentVerdictEvent = null;
        Iterator executionEventsIterator = executionEvents.iterator();
        block8: while (executionEventsIterator.hasNext()) {
            try {
                currentVerdictEvent = (TPFVerdictEvent)executionEventsIterator.next();
                switch (currentVerdictEvent.getVerdict().getValue()) {
                    case 3: {
                        return currentVerdictEvent;
                    }
                    case 2: {
                        verdictEvent = currentVerdictEvent;
                        break;
                    }
                    case 0: {
                        if (verdictEvent != null && (verdictEvent == null || verdictEvent.getVerdict().getValue() != 1)) continue block8;
                        verdictEvent = currentVerdictEvent;
                        break;
                    }
                    case 1: {
                        if (verdictEvent != null) continue block8;
                        verdictEvent = currentVerdictEvent;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return verdictEvent;
    }
}

