/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IXmlParser;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;
import org.eclipse.tptp.test.samples.SamplesPlugin;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;
import org.eclipse.xsd.util.XSDParser;

public class StylesInitializer {
    private static DStyleRegistry defaultRegistry = null;
    static DStyleRegistry graphicregistry = null;

    public static DStyleRegistry getDefaultReportStyles() {
        if (defaultRegistry == null) {
            defaultRegistry = new StylesInitializer().initStyles();
        }
        return defaultRegistry;
    }

    private DStyleRegistry initStyles() {
        DStyleRegistry registry = new DStyleRegistry();
        DColor white = new DColor(255, 255, 255);
        DColor black = new DColor(0, 0, 0);
        DColor gray = new DColor(220, 220, 220);
        DColor blue = new DColor(0, 128, 255);
        DColor colorPass = new DColor(TestUIConstants.COLOR_PASS.red, TestUIConstants.COLOR_PASS.green, TestUIConstants.COLOR_PASS.blue);
        DColor colorFail = new DColor(TestUIConstants.COLOR_FAIL.red, TestUIConstants.COLOR_FAIL.green, TestUIConstants.COLOR_FAIL.blue);
        DColor colorInconclusive = new DColor(TestUIConstants.COLOR_INCONCLUSIVE.red, TestUIConstants.COLOR_INCONCLUSIVE.green, TestUIConstants.COLOR_INCONCLUSIVE.blue);
        DColor colorError = new DColor(TestUIConstants.COLOR_ERROR.red, TestUIConstants.COLOR_ERROR.green, TestUIConstants.COLOR_ERROR.blue);
        int height = 10;
        try {
            Font font = JFaceResources.getTextFont();
            FontData dfont = font.getFontData()[0];
            height = dfont.getHeight();
        }
        catch (Throwable throwable) {}
        DFont title1Font = new DFont("title1Font", null, 20, 1);
        DFont title2Font = new DFont("title2Font", null, 16, 1);
        DFont title3Font = new DFont("title3Font", null, 12, 1);
        DFont normalFont = new DFont("normalFont", null, height, 0);
        DFont chartFont = new DFont("axisFont", null, height, 1);
        DFont linkFont = new DFont("linkFont", null, height, 4);
        DFont headerFont = new DFont("headerFont", null, height, 1);
        DFont gerrorFont = new DFont("gerrorFont", null, height, 3);
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE1, (IDFont)title1Font, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE2, (IDFont)title2Font, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE3, (IDFont)title3Font, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_PASS, (IDFont)normalFont, (IDColor)colorPass, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL, (IDFont)normalFont, (IDColor)colorFail, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE, (IDFont)normalFont, (IDColor)colorInconclusive, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR, (IDFont)normalFont, (IDColor)colorError, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_PASS_CELL, (IDFont)normalFont, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL_CELL, (IDFont)normalFont, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE_CELL, (IDFont)normalFont, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR_CELL, (IDFont)normalFont, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_PASS_CELL_TEXT, (IDFont)normalFont, (IDColor)colorPass, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL_CELL_TEXT, (IDFont)normalFont, (IDColor)colorFail, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE_CELL_TEXT, (IDFont)normalFont, (IDColor)colorInconclusive, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR_CELL_TEXT, (IDFont)normalFont, (IDColor)colorError, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_CHART_TITLE, (IDFont)chartFont, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL, (IDFont)headerFont, (IDColor)black, (IDColor)gray));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL, (IDFont)normalFont, (IDColor)black, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_LINK_CELL, (IDFont)linkFont, (IDColor)blue, (IDColor)white));
        registry.putStyle((IDStyle)new DStyle(SamplesPluginResourceBundle.StylesInitializer_GENERATION_ERROR, (IDFont)gerrorFont, (IDColor)colorError, (IDColor)white));
        return registry;
    }

    public static DStyleRegistry getCurrentReportStyles() {
        block7: {
            if (graphicregistry != null) {
                return graphicregistry;
            }
            graphicregistry = StylesInitializer.getDefaultReportStyles();
            String txt = SamplesPlugin.getDefault().getPreferenceStore().getString("ReportView.Preferences");
            if (txt != null && txt.length() > 0) {
                DXmlReader reader = new DXmlReader((IXmlParser)new XSDXmlParserAdapter(new XSDParser()));
                ByteArrayInputStream buf = new ByteArrayInputStream(txt.getBytes());
                try {
                    reader.read((InputStream)buf);
                    DStyleRegistry newregistry = reader.getStyleRegistry();
                    if (newregistry == null) break block7;
                    for (Object s : newregistry) {
                        if (!(s instanceof IDStyle)) continue;
                        List sol = graphicregistry.getStyles(((IDStyle)s).getName());
                        if (sol != null && sol.size() > 0) {
                            for (Object so : sol) {
                                if (!(so instanceof IDStyle)) continue;
                                ((IDStyle)so).setBackColor(((IDStyle)s).getBackColor());
                                ((IDStyle)so).setForeColor(((IDStyle)s).getForeColor());
                                ((IDStyle)so).setFont(((IDStyle)s).getFont());
                                ((IDStyle)so).setNumberingFormat(((IDStyle)s).getNumberingFormat());
                                ((IDStyle)so).setWallpaper(((IDStyle)s).getWallpaper());
                            }
                            continue;
                        }
                        graphicregistry.putStyle((IDStyle)s);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return graphicregistry;
    }

    public static void initializeDefaultPreferences(IPreferenceStore store) {
        DXmlWriter aw = new DXmlWriter();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            aw.write((OutputStream)buf, (IDObject)StylesInitializer.getDefaultReportStyles());
        }
        catch (Exception exception) {}
        store.setDefault("ReportView.Preferences", buf.toString());
    }
}

