/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.ui.common.internal.report.DescendingVisitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.ExecutionVisitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.JscribWriter;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.ReportDataUtils;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.ReportGraphicUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

public class TestSuiteVisitor
extends DescendingVisitor
implements Visitor {
    private TPFTestSuite testSuite;
    private DItem parentItem;
    private HashMap executionsByTestsuiteMap = new HashMap();
    private long startTime;
    private long endTime;
    private JscribWriter jscribWriter;
    private int[] resultSet;
    private List execList;

    public TestSuiteVisitor(Map executionsByTestsuiteMap, long startTime, long endTime) {
        this.executionsByTestsuiteMap.putAll(executionsByTestsuiteMap);
        this.startTime = startTime;
        this.endTime = endTime;
        this.resultSet = new int[4];
        this.execList = new LinkedList();
    }

    public void visit(DescendingVisitor dvisitor, Object data, DItem parent) throws Exception {
        if (!(data instanceof TPFTestSuite) || !(dvisitor instanceof JscribWriter)) {
            throw new Exception("TestSuiteVisitor: invalid object");
        }
        this.testSuite = (TPFTestSuite)data;
        this.parentItem = parent;
        this.jscribWriter = (JscribWriter)dvisitor;
        this.visit();
    }

    private void visit() throws Exception {
        DFolder folder = new DFolder(true);
        folder.setFolderModel(new DFolderModel(true, (ISymbol)new ISymbol.Minus(), (ISymbol)new ISymbol.Plus()));
        DParagraph paragraph = new DParagraph();
        DItem title = ReportGraphicUtils.createTitle(NLS.bind((String)SamplesPluginResourceBundle.TestSuiteVisitor_TestSuite, (Object)this.testSuite.getName()), 2, this.jscribWriter.getStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE2), null);
        DParagraph byExecutionParagraph = new DParagraph();
        DTable byExecutionTable = new DTable();
        DRow row = new DRow();
        DCellText previousCell = null;
        String[] headers = new String[]{SamplesPluginResourceBundle.TestSuiteVisitor_Execution, SamplesPluginResourceBundle.TestSuiteVisitor_Date, SamplesPluginResourceBundle.JScribWriter_Pass, SamplesPluginResourceBundle.JScribWriter_Inconclusive, SamplesPluginResourceBundle.JScribWriter_Fail, SamplesPluginResourceBundle.JScribWriter_Error, SamplesPluginResourceBundle.TestSuiteVisitor_Attempted, SamplesPluginResourceBundle.TestSuiteVisitor_PassRate};
        int i = 0;
        int max = headers.length;
        while (i < max) {
            DCellText cell = new DCellText(headers[i]);
            cell.setStyle(this.jscribWriter.getStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL));
            row.insertChild((IDItem)cell, previousCell);
            previousCell = cell;
            ++i;
        }
        byExecutionTable.addChild((IDItem)row);
        for (TPFExecutionResult executionResult : ReportDataUtils.getExecutionResultsForWindow((List)this.executionsByTestsuiteMap.get(this.testSuite), this.startTime, this.endTime)) {
            this.accept(new ExecutionVisitor(this.jscribWriter), executionResult, (DItem)byExecutionTable);
            this.execList.add(executionResult);
        }
        DParagraph verdictParagraph = new DParagraph();
        int verdict = ReportDataUtils.getVerdict(this.resultSet);
        verdictParagraph.setStyle(this.jscribWriter.getVerdictCellStyle(verdict));
        DText verdictText = new DText("\n" + NLS.bind((String)SamplesPluginResourceBundle.TestSuiteVisitor_Verdict, (Object)this.jscribWriter.getVerdictLabel(verdict)) + "\n");
        DText execText = new DText(String.valueOf(NLS.bind((String)SamplesPluginResourceBundle.TestSuiteVisitor_NumberOfTestLogs, (Object)ReportDataUtils.normalize(this.execList.size()))) + "\n\n");
        verdictParagraph.addChild((IDItem)verdictText);
        verdictParagraph.addChild((IDItem)execText);
        if (verdict == 1) {
            folder.setOpen(false);
        }
        paragraph.addChild((IDItem)verdictParagraph);
        byExecutionParagraph.addChild((IDItem)byExecutionTable);
        paragraph.addChild((IDItem)byExecutionParagraph);
        paragraph.addChild((IDItem)new DText("\n"));
        folder.addChild((IDItem)title);
        folder.addChild((IDItem)paragraph);
        this.parentItem.addChild((IDItem)folder);
    }

    public void postVisit() {
        this.jscribWriter.resultsByTestSuiteMap.put(this.testSuite, this.resultSet);
        this.jscribWriter.execsByTestSuiteMap.put(this.testSuite, this.execList);
        this.jscribWriter.addToResults(this.resultSet);
    }

    public void addToResults(int[] newResultSet) {
        int i = 0;
        int max = this.resultSet.length;
        while (i < max) {
            int n = i;
            this.resultSet[n] = this.resultSet[n] + newResultSet[i];
            ++i;
        }
    }
}

