/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.IReportGraphDataProvider;

public abstract class HttpAbstractReport {
    protected TPFExecutionResult result = null;
    protected ArrayList list = null;
    public static final String responseTimeMarker = "Time:";
    public static final String pageNameMarker = "ResponseURL:";
    public static final String sysOutTag = "System.out:\n";
    public static final String crlf = "\r\n";
    public static final String lf = "\n";

    public HttpAbstractReport(TPFExecutionResult result) {
        this.result = result;
    }

    public void generate() {
        this.list = new ArrayList();
        this.setupReport();
        if (this.result != null) {
            this.recurseGenerate(this.result.getExecutionHistory().getExecutionEvents());
        }
        this.finishReport();
    }

    protected void recurseGenerate(EList list) {
        for (Object tpfObject : list) {
            EList rList;
            if (tpfObject instanceof TPFMessageEvent) {
                this.processMessageEvent((TPFMessageEvent)tpfObject);
            } else if (tpfObject instanceof TPFTypedEvent) {
                this.processTypedEvent((TPFTypedEvent)tpfObject);
            }
            if (tpfObject instanceof TPFInvocationEvent) {
                rList = ((TPFInvocationEvent)tpfObject).getInvokedExecutionResult().getExecutionHistory().getExecutionEvents();
                if (rList.isEmpty()) continue;
                this.recurseGenerate(rList);
                continue;
            }
            if (!(tpfObject instanceof TPFExecutionEvent) || (rList = ((TPFExecutionEvent)tpfObject).getChildren()).isEmpty()) continue;
            this.recurseGenerate(rList);
        }
    }

    protected abstract void processMessageEvent(TPFMessageEvent var1);

    protected abstract void processTypedEvent(TPFTypedEvent var1);

    protected abstract void setupReport();

    protected abstract void finishReport();

    public ArrayList getList() {
        return this.list;
    }

    protected IReportGraphDataProvider findPage(String pageName) {
        for (IReportGraphDataProvider foo : this.list) {
            if (!foo.getId().equals(pageName)) continue;
            return foo;
        }
        return null;
    }
}

