/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports.hitrate;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.AbstractHTTPPageReportGeneratorWizard;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.hitrate.HitRateReport;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginImageManager;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

public class HTTPPageHitRateReportGeneratorWizard
extends AbstractHTTPPageReportGeneratorWizard {
    public HTTPPageHitRateReportGeneratorWizard() {
        this.setWindowTitle(SamplesPluginResourceBundle.ReportWindowWizardPage_Title);
        this.setDefaultPageImageDescriptor(SamplesPluginImageManager.getInstance().getImageDescriptor("report_window_wiz.gif"));
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        IFile outputFile = this.getReportFile();
        try {
            monitor.beginTask("", 4);
            this.initResultSelection();
            monitor.worked(1);
            HitRateReport report = new HitRateReport(this.result);
            report.generate();
            monitor.worked(1);
            ReportGraphConfiguration config = this.setupConfiguration();
            IPath svgPath = outputFile.getFullPath();
            svgPath.removeFileExtension().addFileExtension("svg");
            monitor.worked(1);
            ReportGraph graph = new ReportGraph(report.getList(), config);
            if (outputFile.exists()) {
                outputFile.delete(true, true, null);
            }
            outputFile.create(graph.generate(svgPath), true, null);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return outputFile;
    }

    private ReportGraphConfiguration setupConfiguration() {
        ReportGraphConfiguration config = new ReportGraphConfiguration();
        config.setTitle(SamplesPluginResourceBundle.HitRateReportGenerator_HIT_RATE);
        config.setXTitle(SamplesPluginResourceBundle.HitRateReportGenerator_PAGE);
        config.setYTitle(SamplesPluginResourceBundle.HitRateReportGenerator_HITS_SEC);
        config.setLegendTitle(SamplesPluginResourceBundle.HitRateReportGenerator_LEGEND);
        config.setTimeStampPrefix("");
        config.setMinWidth(800);
        config.setHeight(500);
        config.setID("org.eclipse.hyades.test.ui.URLTest.HitRateReport");
        return config;
    }
}

