/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports.hitrate;

import org.eclipse.hyades.test.tools.ui.http.internal.reports.IReportGraphDataProvider;

public class HitRateData
implements IReportGraphDataProvider {
    private static int counter = 1;
    String id = null;
    long count = 0L;
    long numberHits = 0L;
    long elapsedTime = 0L;
    static long elapsedTimeForTest = 0L;
    static long totalNumberHits = 0L;

    public HitRateData(String id) {
        this.id = id;
    }

    public void addHit(long time) {
        ++this.numberHits;
        ++totalNumberHits;
        this.elapsedTime += time;
        elapsedTimeForTest += time;
    }

    public static int getNextCounter() {
        return ++counter;
    }

    public static void resetCounter() {
        counter = 1;
        totalNumberHits = 0L;
        elapsedTimeForTest = 0L;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        double noHits = new Double(this.numberHits);
        double cumulativeTime = new Double(elapsedTimeForTest);
        double translator = 1000.0;
        double retVal = noHits / (cumulativeTime / translator);
        return new Double(retVal).toString();
    }

    public static void setTestElapsedTime(long testElapsedTime) {
        elapsedTimeForTest = testElapsedTime;
    }

    public static String getOverallHitRate() {
        return new Double((double)totalNumberHits / new Double((double)elapsedTimeForTest / 1000.0)).toString();
    }

    static class OverallHitRate
    implements IReportGraphDataProvider {
        OverallHitRate() {
        }

        public String getId() {
            return "Overall Hit Rate";
        }

        public String getValue() {
            return HitRateData.getOverallHitRate();
        }
    }
}

