/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports.responsetime;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.HttpAbstractReport;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.responsetime.ResponseTimeData;

public class ResponseTimeReport
extends HttpAbstractReport {
    public ResponseTimeReport(TPFExecutionResult result) {
        super(result);
    }

    protected void finishReport() {
        if (this.list.size() > 1) {
            this.list.add(new ResponseTimeData.OverallResponseTime());
        }
    }

    protected void setupReport() {
        ResponseTimeData.resetCumulativeValues();
    }

    protected void processMessageEvent(TPFMessageEvent event) {
        String message = event.getText();
        int responseTimeIndex = message.indexOf("Time:");
        if (responseTimeIndex != -1) {
            String pageName = message.substring(message.indexOf("ResponseURL:") + "ResponseURL:".length(), responseTimeIndex).trim();
            String responseTime = message.substring(responseTimeIndex + "Time:".length(), message.length());
            if (responseTime.indexOf("\n") > -1) {
                responseTime = responseTime.substring(0, responseTime.indexOf("\n"));
            }
            responseTime = responseTime.trim();
            ResponseTimeData data = (ResponseTimeData)this.findPage(pageName);
            if (data == null) {
                data = new ResponseTimeData(pageName);
                this.list.add(data);
            }
            data.addSample(new Long(responseTime));
        }
    }

    protected void processTypedEvent(TPFTypedEvent typedEvent) {
    }
}

