/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class BaseProfilerView
implements IViewSelectionChangedListener {
    public static Object[] _empty = new Object[0];
    public static String PREFERENCE_KEY_PREFIX = "org.eclipse.tptp.trace.jvmti.internal.client.views.";
    protected Composite _viewContainer;
    protected Composite _viewComp;
    protected HyadesFormToolkit _toolkit;
    protected TraceViewerPage _page;

    protected abstract Control createDataViewer(Composite var1);

    protected abstract String getViewTypeStr();

    protected abstract void update();

    protected BaseProfilerView(Composite parent, TraceViewerPage page) {
        this._page = page;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        this.createControl(parent);
    }

    int getMarginWidth(int idx) {
        return idx == 0 ? 5 : 0;
    }

    int getMarginHeight(int idx) {
        return idx == 0 ? 5 : 0;
    }

    protected Composite createControl(Composite parent) {
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this._viewContainer = this._toolkit.createComposite(parent, 0x800000);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.getMarginWidth(0);
        layout.marginHeight = this.getMarginHeight(0);
        this._viewContainer.setLayout((Layout)layout);
        this._viewContainer.setLayoutData((Object)GridUtil.createFill());
        this.createLabel(this._viewContainer);
        this._viewComp = this._toolkit.createComposite(this._viewContainer, 0x800000);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.getMarginWidth(1);
        layout.marginHeight = this.getMarginWidth(1);
        this._viewComp.setLayout((Layout)layout);
        this._viewComp.setLayoutData((Object)GridUtil.createFill());
        Control dataView = this.createDataViewer(this._viewComp);
        dataView.setLayoutData((Object)GridUtil.createFill());
        return this._viewContainer;
    }

    public void dispose() {
    }

    protected String getPreferenceString(String str) {
        return String.valueOf(this.getViewTypeStr()) + "." + str;
    }

    protected void createLabel(Composite viewContainer) {
    }

    public HyadesFormToolkit getToolkit() {
        return this._toolkit;
    }

    public Control getControl() {
        return this._viewContainer;
    }

    protected Composite getViewComponent() {
        return this._viewComp;
    }

    protected String getContextHelpId() {
        return null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void updateModelSelection() {
        ISelection selection = this.getSelection();
        Object sel = null;
        if (selection != null && !selection.isEmpty()) {
            sel = ((IStructuredSelection)selection).getFirstElement();
        }
        this.notifyViewSelectionChanged(this, sel);
    }

    public void notifyViewSelectionChanged(Object source, Object selection) {
        if (selection != null) {
            UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(selection);
        }
        ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
        event.setSource(source);
        UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
    }

    protected Object getSelectionModel() {
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        Object sel = null;
        if (model != null && model.size() > 0) {
            sel = model.getFirstElement();
        }
        return sel;
    }

    public void selectionChanged() {
        this.handleSelectionEvent();
    }

    protected void handleSelectionEvent() {
        Object sel = this.getSelectionModel();
        if (sel != null) {
            this.select(sel);
        }
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        } else {
            this.updateButtons();
        }
    }

    void updateButtons() {
    }

    protected void select(Object obj) {
    }

    public void menuAboutToShow(IMenuManager arg0) {
    }
}

