/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.actions.internal.OpenSourceAction;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelComparator;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnsDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseProfilerView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.SortByColumnDlg;
import org.eclipse.tptp.trace.jvmti.internal.client.views.StatisticViewColumnInfo;
import org.eclipse.tptp.trace.jvmti.internal.client.views.TIColumnData;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public abstract class BaseStatisticView
extends BaseProfilerView
implements SelectionListener {
    protected TreeViewer _treeViewer;
    protected StatisticSorter _viewerSorter;
    protected ArrayList _currentColumns = null;
    protected Action _updateAction;
    protected Action _showPercent;
    protected Action _deltaColumnsAction;
    protected Action _chooseColumnAction;
    protected Action _sortByColumnAction;
    protected Separator _separator;
    protected boolean _newSelection = false;
    protected boolean _isShowPercent = false;
    protected boolean _deltaColumns = false;
    protected boolean _refresh = false;
    protected boolean _firstTime = true;
    protected double _maxTime;
    protected int _totalInst;
    protected int _totalCalls;
    protected int _activeInst;
    protected long _totalSize;
    protected long _activeSize;
    protected int _collectedInst;

    protected abstract String getColumnsPreferencesKey();

    protected abstract String getDefaultColumnsTemplate();

    protected abstract StatisticSorter getViewerSorterInstance();

    protected abstract String getColumnText(Object var1, int var2);

    protected abstract Image getColumnImage(Object var1, int var2);

    protected abstract Object[] getElements(Object var1);

    protected abstract boolean hasChildren(Object var1);

    protected abstract Object[] getChildren(Object var1);

    protected BaseStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        if (arg0.widget instanceof TreeColumn) {
            this._viewerSorter.setSortedColumn((TreeColumn)arg0.widget);
            this._treeViewer.setSorter((ViewerSorter)this._viewerSorter);
            this._treeViewer.refresh();
        } else if (arg0.widget instanceof Table || arg0.widget instanceof Tree) {
            this.updateModelSelection();
        }
        this.updateButtons();
    }

    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected TreeViewer getTreeViewer(Tree tree) {
        return new StatisticTreeViewer(tree);
    }

    protected TreeViewer createTreeViewer(Tree tree) {
        TreeViewer tv = this.getTreeViewer(tree);
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Object node;
                    TreeViewer tv = BaseStatisticView.this.getTreeViewer();
                    if (tv.isExpandable(node = ((IStructuredSelection)selection).getFirstElement())) {
                        tv.setExpandedState(node, !tv.getExpandedState(node));
                    } else {
                        BaseStatisticView.this.defaultActionForSelection(selection);
                    }
                }
            }
        });
        return tv;
    }

    protected IContentProvider getContentProvider() {
        return new BaseStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        class StatisticLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            StatisticLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return BaseStatisticView.this.getColumnImage(element, columnIndex);
            }

            public String getColumnText(Object element, int columnIndex) {
                return BaseStatisticView.this.getColumnText(element, columnIndex);
            }
        }
        return new StatisticLabelProvider();
    }

    protected void defaultActionForSelection(ISelection selection) {
        OpenSourceAction action = new OpenSourceAction();
        action.selectionChanged((IAction)action, selection);
        action.run();
    }

    protected TraceViewerPage getTraceViewerPage() {
        return this._page;
    }

    public void showNewSelection() {
        if (this._newSelection) {
            this.getTree().showSelection();
            this._newSelection = false;
        }
    }

    public boolean showingDeltaColumns() {
        return this._deltaColumns;
    }

    protected void setNewSelection() {
        this._newSelection = true;
    }

    public Action getUpdateAction() {
        if (this._updateAction == null) {
            this._updateAction = new UpdateAction(UIPlugin.getResourceString((String)"REFRESH_VIEWS"));
        }
        return this._updateAction;
    }

    public Separator getSeparator() {
        if (this._separator == null) {
            this._separator = new Separator();
        }
        return this._separator;
    }

    public Action getChooseColumnsAction() {
        ArrayList cols = this.getColumnDataList();
        String key = this.getColumnsPreferencesKey();
        if (this._chooseColumnAction == null) {
            this._chooseColumnAction = new ChooseColumnsAction(String.valueOf(UIMessages._ChooseColumns) + "...", cols, key);
        }
        return this._chooseColumnAction;
    }

    protected void resetChooseColumnsAction() {
        this._chooseColumnAction = null;
    }

    public Action getSortByColumnAction() {
        if (this._sortByColumnAction == null) {
            this._sortByColumnAction = new SortByColumnsAction(String.valueOf(UIMessages._SortByColumn) + "...");
        }
        return this._sortByColumnAction;
    }

    public Action getDeltaColumnsAction() {
        if (this._deltaColumnsAction == null) {
            this._deltaColumnsAction = new DeltaColumnsAction(UIMessages._ShowDeltaColumns);
        }
        return this._deltaColumnsAction;
    }

    public Action getShowPercentAction() {
        if (this._showPercent == null) {
            this._showPercent = new ShowPercentAction(UIMessages._ShowAsPercentage);
        }
        return this._showPercent;
    }

    public boolean isShowPercent() {
        return this._isShowPercent;
    }

    public ArrayList getColumnDataList() {
        return this._currentColumns;
    }

    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    public StatisticSorter getViewerSorter() {
        return this._viewerSorter;
    }

    protected void setRedrawTable(boolean redraw) {
        this._treeViewer.getControl().setRedraw(redraw);
    }

    protected void showPercentUpdate() {
    }

    protected int updateTableGetColumnNumber() {
        return 0;
    }

    public void update() {
        IContextViewer viewer;
        if (this._firstTime) {
            this.firstTimeUpdate();
        }
        if (this.contextChanged() || this._page.getTraceViewer().contextHandlerSelectionChanged()) {
            this.updateContext();
        }
        if ((viewer = this.getContextViewer()) != null) {
            viewer.getContextSelectionMenuListener().setMOFObject(this._page.getMOFObject());
        }
        this.showPercentUpdate();
        this.setRedrawTable(false);
        this.getTreeViewer().setInput((Object)this._page.getMOFObject());
        this.expandFirstElement();
        this.setRedrawTable(true);
        this.postUpdateEvents();
    }

    protected void firstTimeUpdate() {
        this._firstTime = false;
        Tree tree = this.getTree();
        TreeColumn firstColumn = tree.getColumn(this.updateTableGetColumnNumber());
        this._viewerSorter = this.getViewerSorterInstance();
        this._viewerSorter.setSortedColumn(firstColumn);
        this._treeViewer.setSorter((ViewerSorter)this._viewerSorter);
        this.redrawTable();
    }

    protected void redrawTable() {
        this.getTree().setRedraw(false);
        this._currentColumns = ColumnData.createColumnData((String)this.getColumnsPreferencesKey(), (String)this.getDefaultColumnsTemplate());
        this._currentColumns = TIColumnData.convertColumnData(this._currentColumns);
        this.resetColumns(this._currentColumns);
        this.getTree().setRedraw(true);
    }

    protected void postUpdateEvents() {
        this.handleSelectionEvent();
    }

    protected void expandFirstElement() {
    }

    protected String getContext() {
        IContextViewer viewer = this.getContextViewer();
        return viewer != null ? viewer.getSelectedContext() : null;
    }

    protected boolean contextChanged() {
        IContextViewer viewer = this.getContextViewer();
        if (viewer != null) {
            if (viewer.contextChanged()) {
                return true;
            }
            viewer.setSelectedContext(ContextUpdaterHelper.getCurrentContext((String[])ContextUpdaterHelper.getContexts((EObject)this._page.getMOFObject()), (IContextViewer)viewer), false);
            return viewer.contextChanged();
        }
        return false;
    }

    protected void updateContext() {
        this.resetColumns(this._currentColumns);
        IContextViewer viewer = this.getContextViewer();
        if (viewer != null) {
            viewer.updateContext();
        }
    }

    private IContextViewer getContextViewer() {
        TraceViewer traceViewer;
        if (this._page != null && (traceViewer = this._page.getTraceViewer()) != null && traceViewer instanceof IContextViewer) {
            return (IContextViewer)traceViewer;
        }
        return null;
    }

    protected void resetColumns(ArrayList list) {
        String sortedColumnKey = "";
        boolean isDeltaColumn = false;
        int sortSequence = this._viewerSorter.getSortSequence();
        Tree tree = this.getTree();
        this.setRedrawTable(false);
        int idx = tree.getColumnCount();
        while (idx > 0) {
            TreeColumn col = tree.getColumn(tree.getColumnCount() - 1);
            StatisticViewColumnInfo staticTblColInfo = (StatisticViewColumnInfo)col.getData();
            if (staticTblColInfo.isSortColumn()) {
                sortedColumnKey = staticTblColInfo.getColumnData().key();
                isDeltaColumn = staticTblColInfo.isDeltaColumn();
            }
            col.dispose();
            --idx;
        }
        idx = 0;
        while (idx < list.size()) {
            ColumnData data = (ColumnData)list.get(idx);
            data.setContext(this.getContext());
            if (data.visible()) {
                new StatisticViewColumnInfo(this, data, this._deltaColumns);
            }
            ++idx;
        }
        tree = this.getTree();
        idx = 0;
        while (idx < tree.getColumnCount()) {
            StatisticViewColumnInfo treeColumnInfo = this.getColumnInfo(tree.getColumn(idx));
            if (treeColumnInfo != null && sortedColumnKey.equals(treeColumnInfo.getColumnData().key()) && isDeltaColumn == treeColumnInfo.isDeltaColumn()) {
                treeColumnInfo.setSortColumn(true);
                break;
            }
            ++idx;
        }
        if (this._viewerSorter.resetSortColumn(this.getTree()) == null) {
            this._treeViewer.setSorter(null);
        } else {
            this._viewerSorter.setSortSequence(sortSequence * -1);
            this._viewerSorter.setSortedColumn(this._viewerSorter.resetSortColumn(this.getTree()));
            this._treeViewer.setSorter((ViewerSorter)this._viewerSorter);
        }
        this.setRedrawTable(true);
    }

    protected Control createDataViewer(Composite parent) {
        this._isShowPercent = Utils.loadIntOption(this.getPreferenceString("percent")) == 1;
        this._deltaColumns = Utils.loadIntOption(this.getPreferenceString("delta")) == 1;
        this._currentColumns = ColumnData.createColumnData((String)this.getColumnsPreferencesKey(), (String)this.getDefaultColumnsTemplate());
        Control table = this.createTableViewer(parent, this._currentColumns);
        return table;
    }

    protected Tree createTree(Composite parent, int options) {
        Tree tree = this._toolkit.createTree(parent, options);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        ColumnLayout layout = new ColumnLayout();
        layout.maxNumColumns = 100;
        tree.setLayout((Layout)layout);
        tree.setLayoutData((Object)new GridData(1808));
        tree.addSelectionListener((SelectionListener)this);
        return tree;
    }

    private Control createTableViewer(Composite parent, ArrayList cols) {
        Tree tree = this.createTree(parent, 8454148);
        this._treeViewer = this.createTreeViewer(tree);
        int idx = 0;
        while (idx < cols.size()) {
            ColumnData data = (ColumnData)cols.get(idx);
            data.setContext(this.getContext());
            if (data.visible()) {
                new StatisticViewColumnInfo(this, data, this._deltaColumns);
            }
            ++idx;
        }
        this._treeViewer.setContentProvider(this.getContentProvider());
        this._treeViewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        return this._treeViewer.getControl();
    }

    public void dispose() {
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this._page = null;
    }

    public void handlePercentChanged() {
        this._isShowPercent = !this._isShowPercent;
        Utils.saveIntOption(this.getPreferenceString("percent"), this._isShowPercent ? 1 : 0);
        this.update();
        this.updateButtons();
    }

    public void handleDeltaChanged() {
        this._deltaColumns = !this._deltaColumns;
        Utils.saveIntOption(this.getPreferenceString("delta"), this._deltaColumns ? 1 : 0);
        this.resetColumns(this._currentColumns);
        this.update();
    }

    protected StatisticViewColumnInfo getColumnInfo(TreeColumn treeColumn) {
        if (treeColumn.getData() != null && treeColumn.getData() instanceof StatisticViewColumnInfo) {
            return (StatisticViewColumnInfo)treeColumn.getData();
        }
        return null;
    }

    protected int compareElements(Object obj1, Object obj2, ColumnLabelAdapter col, boolean isDeltaColumn) {
        ColumnDisplayInfo info = this.getColumnDisplayInfo(col, isDeltaColumn);
        return ColumnLabelComparator.compare((Object)obj1, (Object)obj2, (ColumnLabelAdapter)col, (ColumnDisplayInfo)info);
    }

    protected String getElementColumnText(Object obj, ColumnLabelAdapter col, boolean isDeltaColumn) {
        ColumnDisplayInfo info = this.getColumnDisplayInfo(col, isDeltaColumn);
        return col.getDisplayString(obj, info);
    }

    protected Image getElementColumnImage(Object obj, ColumnLabelAdapter col, boolean isDeltaColumn) {
        ColumnDisplayInfo info = this.getColumnDisplayInfo(col, isDeltaColumn);
        return col.getDisplayImage(obj, info);
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        return col.getColumnDisplayInfo();
    }

    public ISelection getSelection() {
        return this._treeViewer.getSelection();
    }

    public class BaseStatisticContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            return BaseStatisticView.this.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return BaseStatisticView.this.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return BaseStatisticView.this.getElements(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ChooseColumnsAction
    extends Action {
        private ArrayList _cols;
        private String _key;

        public ChooseColumnsAction(String name, ArrayList cols, String key) {
            super(name);
            this._cols = cols;
            this._key = key;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".ccol0000");
            TracePluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"choosecolumn_co.gif");
        }

        public void run() {
            ColumnsDialog dialog = new ColumnsDialog(BaseStatisticView.this.getControl().getShell(), UIMessages._ChooseColumns, null, this._cols, BaseStatisticView.this.getDefaultColumnsTemplate(), BaseStatisticView.this.getContextHelpId(), BaseStatisticView.this.getContext());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                ColumnData.setColumns((ArrayList)dialog.getData(), (ArrayList)this._cols, (String)this._key);
                BaseStatisticView.this.resetColumns(this._cols);
                BaseStatisticView.this.update();
            }
        }
    }

    class DeltaColumnsAction
    extends Action {
        public DeltaColumnsAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".ccol0000");
        }

        public void setChecked(boolean value) {
            super.setChecked(value);
        }

        public void run() {
            BaseStatisticView.this.handleDeltaChanged();
        }
    }

    class ShowPercentAction
    extends Action {
        public ShowPercentAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".clst0003");
        }

        public void run() {
            BaseStatisticView.this.handlePercentChanged();
        }
    }

    class SortByColumnsAction
    extends Action {
        public SortByColumnsAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".ccol0000");
            TracePluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"alphab_sort_co.gif");
        }

        private TreeColumn getTreeColumn(Tree tree, StatisticViewColumnInfo columnInfo) {
            int idx = 0;
            while (idx < tree.getColumnCount()) {
                StatisticViewColumnInfo treeColumnInfo = BaseStatisticView.this.getColumnInfo(tree.getColumn(idx));
                if (treeColumnInfo != null && columnInfo != null && columnInfo.getColumnData().name().equals(treeColumnInfo.getColumnData().name()) && columnInfo.isDeltaColumn() == treeColumnInfo.isDeltaColumn()) {
                    return tree.getColumn(idx);
                }
                ++idx;
            }
            return null;
        }

        public void run() {
            ArrayList<StatisticViewColumnInfo> columnInfoList = new ArrayList<StatisticViewColumnInfo>();
            int i = 0;
            while (i < BaseStatisticView.this.getTree().getColumnCount()) {
                StatisticViewColumnInfo ci = BaseStatisticView.this.getColumnInfo(BaseStatisticView.this.getTree().getColumn(i));
                if (ci != null) {
                    columnInfoList.add(ci);
                }
                ++i;
            }
            SortByColumnDlg dialog = new SortByColumnDlg(BaseStatisticView.this.getControl().getShell(), null, columnInfoList, BaseStatisticView.this.getViewerSorter().getSortSequence());
            if (dialog.open() == 0) {
                BaseStatisticView.this.getViewerSorter().setSortedColumn(dialog.sortSequence(), this.getTreeColumn(BaseStatisticView.this.getTree(), dialog.sortColumn()));
                BaseStatisticView.this._treeViewer.refresh();
            }
        }
    }

    public abstract class StatisticSorter
    extends ViewerSorter {
        protected TreeColumn _sortColumn;
        protected int _sortSequence = -1;
        protected StatisticViewColumnInfo _info;
        protected int _pos = 0;

        public void setSortedColumn(TreeColumn newSortColumn) {
            TreeColumn currentColumn = this.getCurrentSortColumn(newSortColumn.getParent());
            this._sortSequence = currentColumn != null ? (currentColumn == newSortColumn ? -this._sortSequence : -1) : 1;
            this.setSortedColumn(this._sortSequence, newSortColumn);
        }

        public void setSortedColumn(int sortSequence, TreeColumn newSortColumn) {
            String text;
            this._sortSequence = sortSequence;
            this._sortColumn = newSortColumn;
            TreeColumn currentColumn = this.getCurrentSortColumn(newSortColumn.getParent());
            if (currentColumn != null) {
                text = currentColumn.getText();
                if (text.startsWith(">") || text.startsWith("<")) {
                    text = text.substring(1);
                }
                currentColumn.setText(text);
                StatisticViewColumnInfo.getStatisticTableColumnInfo(currentColumn).setSortColumn(false);
            }
            text = newSortColumn.getText();
            this._info = StatisticViewColumnInfo.getStatisticTableColumnInfo(newSortColumn);
            this._pos = this._info.getColumnData().getInitalPos();
            newSortColumn.setText(String.valueOf(this._sortSequence > 0 ? ">" : "<") + text);
            StatisticViewColumnInfo.getStatisticTableColumnInfo(newSortColumn).setSortColumn(true);
        }

        public int getSortSequence() {
            return this._sortSequence;
        }

        public void setSortSequence(int sortSequence) {
            this._sortSequence = sortSequence;
        }

        public TreeColumn getCurrentSortColumn(Tree tree) {
            int idx = 0;
            while (idx < tree.getColumnCount()) {
                if (StatisticViewColumnInfo.getStatisticTableColumnInfo(tree.getColumn(idx)).isSortColumn()) {
                    return tree.getColumn(idx);
                }
                ++idx;
            }
            return null;
        }

        public TreeColumn resetSortColumn(Tree tree) {
            this._sortColumn = this.getCurrentSortColumn(tree);
            return this._sortColumn;
        }
    }

    class StatisticTreeViewer
    extends TreeViewer {
        public StatisticTreeViewer(Tree tree) {
            super(tree);
        }

        public void expandItem(TreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }

        public ISelection getSelection() {
            ISelection sel = super.getSelection();
            return sel;
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(TraceUIPlugin.getPluginId()) + ".uvew0000");
            PDPluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"updateviews_co.gif");
        }

        public void run() {
            ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent((Object)BaseStatisticView.this._page.getMOFObject());
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }
}

