/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.trace.jvmti.internal.client.views.AllocationDetailsView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseMemoryStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MemoryAnalysisViewer;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

public class MemoryAnalysisPage
extends TraceViewerPage {
    public static final int TAB_MEMORY_STATS = 0;
    public static final int TAB_ALLOC_DETAILS = 1;
    CTabFolder _tabFolder;
    BaseStatisticView[] _views;

    public MemoryAnalysisPage(EObject mofObject, TraceViewer viewer) {
        super(mofObject, viewer);
    }

    public void refreshPage() {
        BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
        view.update();
        this.updateButtons();
    }

    public void selectionChanged() {
    }

    public void update(boolean newPage) {
        if (newPage) {
            BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
            view.update();
            this.updateButtons();
        }
    }

    public void createControl(Composite parent) {
        TRCAgentProxy agProxy;
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this._tabFolder = new CTabFolder(parent, 0x800400);
        this._tabFolder.setLayoutData((Object)gd);
        this._tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryAnalysisPage.this.updateAllocDetails();
                BaseStatisticView view = MemoryAnalysisPage.this._views[MemoryAnalysisPage.this._tabFolder.getSelectionIndex()];
                view.update();
                view.updateModelSelection();
                MemoryAnalysisPage.this.updateButtons();
            }
        });
        boolean objAllocSitesEnabled = true;
        if (this._mofObject instanceof TRCAgentProxy && this._mofObject != null && (agProxy = (TRCAgentProxy)this._mofObject).getCollectionMode() != null) {
            TRCCollectionMode collectionMode = agProxy.getCollectionMode();
            if (collectionMode == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL) {
                objAllocSitesEnabled = false;
            }
            if (objAllocSitesEnabled && collectionMode == TRCCollectionMode.HEAP_FULL_LITERAL) {
                block0: for (TRCConfiguration config : agProxy.getConfigurations()) {
                    if (config.getName() == null || !config.getName().equals("__JVMPI__")) continue;
                    for (TRCOption option : config.getOptions()) {
                        if (!option.getKey().equals("org.eclipse.tptp.platform.jvmti.client.ATTR_EXEC_OBJ_ALLOC_SITE")) continue;
                        objAllocSitesEnabled = Boolean.parseBoolean(option.getValue());
                        break block0;
                    }
                }
            }
        }
        this._views = objAllocSitesEnabled ? new BaseStatisticView[2] : new BaseStatisticView[1];
        CTabItem tabItem = new CTabItem(this._tabFolder, 0);
        tabItem.setText(UIMessages.MEM_STATISTICS_TITLE);
        BaseMemoryStatisticView memView = new BaseMemoryStatisticView((Composite)this._tabFolder, this);
        this._views[0] = memView;
        tabItem.setControl(this._views[0].getControl());
        if (objAllocSitesEnabled) {
            tabItem = new CTabItem(this._tabFolder, 0);
            tabItem.setText(UIMessages.MEM_ALLOCATION_DETAILS_TITLE);
            AllocationDetailsView allocView = new AllocationDetailsView((Composite)this._tabFolder, this);
            this._views[1] = allocView;
            tabItem.setControl(this._views[1].getControl());
            memView._viewDetails = allocView;
        }
        this._tabFolder.setSelection(0);
    }

    public Control getControl() {
        return this._tabFolder;
    }

    public void setFocus() {
        this._views[this._tabFolder.getSelectionIndex()].getControl().setFocus();
    }

    public SimpleSearchQuery getCurrentFilter() {
        return ((MemoryAnalysisViewer)this._viewer).getCurrentFilter();
    }

    public int getViewTab() {
        return this._tabFolder.getSelectionIndex();
    }

    public int getViewTabViewMode() {
        int viewMode = -1;
        BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
        if (view instanceof BaseMemoryStatisticView) {
            BaseMemoryStatisticView view0 = (BaseMemoryStatisticView)view;
            viewMode = view0.getViewMode();
        }
        return viewMode;
    }

    public void setViewMode(int tab, int viewMode) {
        if (tab != 0 && 1 != tab) {
            return;
        }
        this._tabFolder.setSelection(tab);
        BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
        if (view instanceof BaseMemoryStatisticView) {
            BaseMemoryStatisticView view0 = (BaseMemoryStatisticView)view;
            view0.setViewMode(viewMode);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this._viewer instanceof MemoryAnalysisViewer) {
            ((MemoryAnalysisViewer)this._viewer).updateButtons();
        }
    }

    public void updateFilterAppliedDescription() {
        ((MemoryAnalysisViewer)this._viewer).updateFilterAppliedDescription();
    }

    public BaseStatisticView getCurrentView() {
        BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
        return view;
    }

    public boolean isShowDelta() {
        BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
        return view.showingDeltaColumns();
    }

    public boolean isShowPercent() {
        BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
        return view.isShowPercent();
    }

    void showAllocDetails() {
        this.setViewMode(1, 0);
        this.updateAllocDetails();
    }

    void updateAllocDetails() {
        BaseStatisticView view = this._views[this._tabFolder.getSelectionIndex()];
        if (view instanceof AllocationDetailsView) {
            ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this.getMOFObject());
            if (model.size() > 0) {
                Object obj = model.getFirstElement();
                ((AllocationDetailsView)view).showAllocDetails(obj);
            } else {
                ((AllocationDetailsView)view).showAllocDetails(null);
            }
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getTotalSize((EObject)this.getMOFObject()) <= 0L;
    }
}

