/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tptp.trace.jvmti.internal.client.AllocationSite;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseProfilerView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MemoryAnalysisPage;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.CustomAnalysisView;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.ICustomAnalysisView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public class MemoryAnalysisViewer
extends FilterTraceViewer
implements IContextViewer {
    public static final String VIEW_ID = "org.eclipse.tptp.trace.jvmti.internal.client.views.MemoryAnalysisViewer";
    public static final String RUNTIME_ID = "RUNTIME_ID";
    private static final String GROUP_COLUMNS = "actions.columns";
    Action _viewPackage;
    Action _viewClass;
    Action _openSource;
    Action _chooseColumns;
    Action _sortByColumn;
    Action _percentMode;
    Action _deltaColumns;
    Menu _contextMenu;
    private String _context;
    private boolean _contextChanged;
    private ContextSelectionMenuListener _contextSelectionMenuListener;

    public TraceViewerPage createPage(EObject mofObject) {
        if (this._fi != null) {
            this._fi.restore();
        }
        return new MemoryAnalysisPage(mofObject, (TraceViewer)this);
    }

    public void dispose() {
        if (this._contextMenu != null) {
            this._contextMenu.dispose();
        }
        super.dispose();
    }

    public Object[] getViewerControls() {
        BaseProfilerView view = this.getCurrentView();
        if (view instanceof BaseStatisticView) {
            return new Object[]{((BaseStatisticView)view).getTree()};
        }
        return null;
    }

    public String getViewTitle() {
        return UIMessages.MEM_ANALYSIS_TITLE;
    }

    public boolean contextChanged() {
        return this._contextChanged;
    }

    public ContextSelectionMenuListener getContextSelectionMenuListener() {
        if (this._contextSelectionMenuListener == null) {
            this._contextSelectionMenuListener = new ContextSelectionMenuListener();
        }
        return this._contextSelectionMenuListener;
    }

    public String getSelectedContext() {
        return this._context;
    }

    public void setSelectedContext(String context) {
        this.setSelectedContext(context, true);
    }

    public void setSelectedContext(String context, boolean refresh) {
        this._contextChanged = context == null ? this._context != null : !context.equals(this._context);
        this._context = context;
        if (this._contextChanged && refresh && this.getCurrentPage() != null) {
            ((TraceViewerPage)this.getCurrentPage()).refreshPage();
        }
    }

    public void updateContext() {
        ContextUpdaterHelper.setCurrentFocusContextLanguage((String)this.getSelectedContext());
        this._contextChanged = false;
    }

    public void filterUpdated() {
        TraceViewerPage page = (TraceViewerPage)this.getCurrentPage();
        if (page != null) {
            if (this.fPartVisible) {
                page.refreshPage();
            } else {
                this.fForceRefresh = true;
            }
        }
    }

    public String[] getFilterScope() {
        String[] scope = new String[]{"ProfilingAgentScope"};
        return scope;
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        this.initializedMenu(true);
        this.createActions();
        this.updateButtons();
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.updateActionBars();
    }

    public void updateButtons() {
        MemoryAnalysisPage page = null;
        if (this.getCurrentPage() instanceof MemoryAnalysisPage) {
            page = (MemoryAnalysisPage)this.getCurrentPage();
        }
        boolean memStatsTab = page != null && page.getViewTab() == 0;
        boolean memAllocTab = page != null && page.getViewTab() == 1;
        boolean classMode = memStatsTab && page.getViewTabViewMode() == 0;
        boolean packageMode = memStatsTab && page.getViewTabViewMode() == 1;
        boolean isDelta = memStatsTab && page.isShowDelta();
        boolean isPercent = page != null && page.isShowPercent();
        this._viewClass.setEnabled(memStatsTab);
        this._viewClass.setChecked(classMode);
        this._viewPackage.setEnabled(memStatsTab);
        this._viewPackage.setChecked(packageMode);
        boolean canSrc = page != null && Utils.canOpenSourceOnThisObject(page.getMOFObject());
        this._openSource.setEnabled(canSrc);
        this._deltaColumns.setEnabled(memStatsTab);
        this._percentMode.setEnabled(memAllocTab || memStatsTab);
        this._deltaColumns.setChecked(isDelta);
        this._percentMode.setChecked(isPercent);
        this.setFilterActionEnabled(memStatsTab);
    }

    void createActions() {
        this._viewClass = new Action(){

            public void run() {
                MemoryAnalysisPage page = (MemoryAnalysisPage)MemoryAnalysisViewer.this.getCurrentPage();
                page.setViewMode(0, 0);
            }
        };
        this._viewPackage = new Action(){

            public void run() {
                MemoryAnalysisPage page = (MemoryAnalysisPage)MemoryAnalysisViewer.this.getCurrentPage();
                page.setViewMode(0, 1);
            }
        };
        Utils.setActionProperties(this._viewPackage, this._context, "show.package.level");
        Utils.setActionProperties(this._viewClass, this._context, "show.class.level");
        String openSourceStr = TraceUIMessages._74;
        this._openSource = new Action(openSourceStr){

            public void run() {
                MemoryAnalysisPage page = (MemoryAnalysisPage)MemoryAnalysisViewer.this.getCurrentPage();
                if (page != null) {
                    Object obj = UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement();
                    if (obj instanceof AllocationSite) {
                        Utils.openSource(Utils.composeMethodName((AllocationSite)obj));
                    } else {
                        Utils.openSource(obj);
                    }
                }
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, (String)"tool16", (String)"opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        this._openSource.setEnabled(false);
        String strShowPercent = TraceUIMessages._13;
        this._percentMode = new Action(strShowPercent){

            public void run() {
                MemoryAnalysisPage page = (MemoryAnalysisPage)MemoryAnalysisViewer.this.getCurrentPage();
                if (page != null) {
                    page.getCurrentView().getShowPercentAction().run();
                }
            }
        };
        this._percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, (String)"lcl16", (String)"percentage_show.gif");
        this._percentMode.setDescription(strShowPercent);
        this._percentMode.setToolTipText(strShowPercent);
        this._percentMode.setEnabled(true);
        String strShowDelta = TraceUIMessages._84;
        this._deltaColumns = new Action(strShowDelta){

            public void run() {
                MemoryAnalysisPage page = (MemoryAnalysisPage)MemoryAnalysisViewer.this.getCurrentPage();
                if (page != null) {
                    page.getCurrentView().getDeltaColumnsAction().run();
                }
            }
        };
        this._deltaColumns.setText(strShowDelta);
        TracePluginImages.setImageDescriptors((IAction)this._deltaColumns, (String)"lcl16", (String)"delta_show.gif");
        this._deltaColumns.setDescription(strShowDelta);
        this._deltaColumns.setToolTipText(strShowDelta);
        this._deltaColumns.setEnabled(true);
        String strChooseColumns = UIMessages._ChooseColumns;
        this._chooseColumns = new Action(strChooseColumns){

            public void run() {
                BaseProfilerView view = MemoryAnalysisViewer.this.getCurrentView();
                if (view instanceof BaseStatisticView) {
                    ((BaseStatisticView)view).getChooseColumnsAction().run();
                }
            }
        };
        this._chooseColumns.setText(strChooseColumns);
        TracePluginImages.setImageDescriptors((IAction)this._chooseColumns, (String)"lcl16", (String)"choosecolumn_co.gif");
        this._chooseColumns.setDescription(strChooseColumns);
        this._chooseColumns.setToolTipText(strChooseColumns);
        String strSortByColumn = UIMessages._SortByColumn;
        this._sortByColumn = new Action(strSortByColumn){

            public void run() {
                BaseProfilerView view = MemoryAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatisticView) {
                    ((ThreadStatisticView)view).getSortByColumnAction().run();
                }
            }
        };
        this._sortByColumn.setText(strSortByColumn);
        TracePluginImages.setImageDescriptors((IAction)this._sortByColumn, (String)"lcl16", (String)"alphab_sort_co.gif");
        this._sortByColumn.setDescription(strSortByColumn);
        this._sortByColumn.setToolTipText(strSortByColumn);
    }

    void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this._openSource);
        manager.add((IContributionItem)new Separator(GROUP_COLUMNS));
        manager.add((IAction)this._chooseColumns);
        manager.add((IAction)this._sortByColumn);
    }

    void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this._viewPackage);
        manager.add((IAction)this._viewClass);
        manager.add((IAction)this._openSource);
        manager.add((IAction)this._percentMode);
        manager.add((IAction)this._deltaColumns);
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            this.getCurrentPage().setFocus();
        }
    }

    public BaseProfilerView getCurrentView() {
        if (!(this.getCurrentPage() instanceof MemoryAnalysisPage)) {
            return null;
        }
        MemoryAnalysisPage page = (MemoryAnalysisPage)this.getCurrentPage();
        if (page.getControl() == null || page.getControl().isDisposed()) {
            return null;
        }
        return page.getCurrentView();
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public EObject getObjectToView(EObject selObject) {
        return MemoryAnalysisViewer.getObjectToView_((EObject)selObject);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            return;
        }
        final String rid = memento.getString(RUNTIME_ID);
        if (rid == null) {
            return;
        }
        this.loadingTrace();
        site.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                PDProjectExplorer.getFromActivePerspective();
                TRCAgentProxy obj = PDContentProvider.getAgent((String)rid);
                if (obj != null) {
                    MemoryAnalysisViewer.this.addViewPage((EObject)obj, true);
                } else {
                    MemoryAnalysisViewer.this.loadingTraceDone();
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        String rid = null;
        if (this._mofObject != null && this._mofObject instanceof TRCAgentProxy) {
            rid = ((TRCAgentProxy)this._mofObject).getRuntimeId();
        }
        if (rid != null) {
            memento.putString(RUNTIME_ID, rid);
            super.saveState(memento);
        }
    }

    public void handleProfileEvent(ProfileEvent event) {
        ICustomAnalysisView[] customViewProviders = CustomAnalysisView.getContributors();
        if (customViewProviders != null) {
            BaseProfilerView view = this.getCurrentView();
            int provider = 0;
            while (provider < customViewProviders.length) {
                customViewProviders[provider].handleProfileEvent(event, view);
                ++provider;
            }
        }
        super.handleProfileEvent(event);
    }
}

