/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;

public class MonitorCallDetails {
    static final String ANNATATION_NAME_LINES = "callStackDumpLineNumbers";
    static final String ANNATATION_NAME_METHODS = "callStackDumpMethods";
    static final String WAIT_METHOD_STR_CONST = "java.lang.Object.wait";
    protected ArrayList _waitDeltas = new ArrayList();
    protected ArrayList _blockDeltas = new ArrayList();
    protected HashSet _waitThreadsSet = new HashSet();
    protected HashSet _waitObjectsSet = new HashSet();
    protected HashSet _blockThreadsSet = new HashSet();
    protected HashSet _blockObjectsSet = new HashSet();
    private String _idString = "";
    private String _callTitle = "";
    private String _stackString = "";
    private boolean _isObjectWaiting = false;
    protected double _sleepingTime;
    protected int _sleepingCount;
    protected double _waitingTime;
    protected double _maxWaitingTime = 0.0;
    protected double _minWaitingTime = Double.MAX_VALUE;
    protected double _avgWaitingTime;
    protected int _waitCount;
    protected double _blockedTime;
    protected double _maxBlockedTime = 0.0;
    protected double _minBlockedTime = Double.MAX_VALUE;
    protected double _avgBlockedTime;
    protected int _blockedCount;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._idString == null ? 0 : this._idString.hashCode());
        result = 31 * result + (this._isObjectWaiting ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonitorCallDetails other = (MonitorCallDetails)obj;
        if (this._idString == null ? other._idString != null : !this._idString.equals(other._idString)) {
            return false;
        }
        return this._isObjectWaiting == other._isObjectWaiting;
    }

    MonitorCallDetails(TRCThreadEvent event) {
        if (event instanceof TRCThreadWaitingForObjectEvent) {
            this._isObjectWaiting = true;
        }
        TRCAnnotation methodsAnn = null;
        TRCAnnotation linesAnn = null;
        for (Object element : event.getAnnotations()) {
            if (!(element instanceof TRCAnnotation)) continue;
            TRCAnnotation ann = (TRCAnnotation)element;
            if (ann.getName().equals(ANNATATION_NAME_METHODS)) {
                methodsAnn = ann;
                continue;
            }
            if (!ann.getName().equals(ANNATATION_NAME_LINES)) continue;
            linesAnn = ann;
        }
        if (methodsAnn != null) {
            this._idString = "";
            EList listMeth = methodsAnn.getValues();
            EList listLines = null;
            if (linesAnn != null) {
                listLines = linesAnn.getValues();
            }
            if (!this._isObjectWaiting && listMeth.size() > 0) {
                this._callTitle = listMeth.get(0).toString();
            }
            boolean titleFound = false;
            int i = 0;
            while (i < listMeth.size()) {
                if (this._isObjectWaiting) {
                    if (!titleFound && this._callTitle.startsWith(WAIT_METHOD_STR_CONST) && !listMeth.get(i).toString().startsWith(WAIT_METHOD_STR_CONST)) {
                        this._callTitle = listMeth.get(i).toString();
                        titleFound = true;
                    } else if (!titleFound) {
                        this._callTitle = listMeth.get(i).toString();
                    }
                }
                this._idString = String.valueOf(this._idString) + listMeth.get(i);
                this._stackString = String.valueOf(this._stackString) + listMeth.get(i);
                if (listLines != null && i < listLines.size()) {
                    this._idString = String.valueOf(this._idString) + listLines.get(i);
                    this._stackString = String.valueOf(this._stackString) + ":" + listLines.get(i);
                }
                this._stackString = String.valueOf(this._stackString) + "\n";
                ++i;
            }
        }
    }

    public String getCallTitle() {
        return this._callTitle;
    }

    public String getStackText() {
        return this._stackString;
    }

    public int getBlockedCount() {
        return this._blockedCount;
    }

    public int getWaitingCount() {
        return this._waitCount;
    }

    public int getSleepingCount() {
        return this._sleepingCount;
    }

    public double getBlockedTime() {
        return this._blockedTime;
    }

    public double getSleepingTime() {
        return this._sleepingTime;
    }

    public double getWaitingTime() {
        return this._waitingTime;
    }

    public double getMinBlockedTime() {
        return this._minBlockedTime;
    }

    public double getAvgBlockedTime() {
        return this._avgBlockedTime;
    }

    public double getMaxBlockedTime() {
        return this._maxBlockedTime;
    }

    public double getMinWaitingTime() {
        return this._minWaitingTime;
    }

    public double getAvgWaitingTime() {
        return this._avgWaitingTime;
    }

    public double getMaxWaitingTime() {
        return this._maxWaitingTime;
    }

    public int getWaitingObjectsCount() {
        return this._waitObjectsSet.size();
    }

    public int getBlockedObjectsCount() {
        return this._blockObjectsSet.size();
    }

    public int getWaitingThreadsCount() {
        return this._waitThreadsSet.size();
    }

    public int getBlockedThreadsCount() {
        return this._blockThreadsSet.size();
    }

    public void updateCallData(TRCThreadEvent event, double timeSpan) {
        if (event instanceof TRCThreadSleepingEvent) {
            this._sleepingTime += timeSpan;
            ++this._sleepingCount;
        } else if (event instanceof TRCThreadWaitingForObjectEvent) {
            this._waitingTime += timeSpan;
            ++this._waitCount;
            this._avgWaitingTime = this._waitingTime / (double)this._waitCount;
            if (timeSpan > this._maxWaitingTime) {
                this._maxWaitingTime = timeSpan;
            }
            if (timeSpan < this._minWaitingTime) {
                this._minWaitingTime = timeSpan;
            }
            this._waitThreadsSet.add(event.getThread());
            this._waitObjectsSet.add(((TRCThreadWaitingForObjectEvent)event).getObjectWaitingFor());
        } else if (event instanceof TRCThreadWaitingForLockEvent) {
            this._blockedTime += timeSpan;
            ++this._blockedCount;
            this._avgBlockedTime = this._blockedTime / (double)this._blockedCount;
            if (timeSpan > this._maxBlockedTime) {
                this._maxBlockedTime = timeSpan;
            }
            if (timeSpan < this._minBlockedTime) {
                this._minBlockedTime = timeSpan;
            }
            this._blockThreadsSet.add(event.getThread());
            this._blockObjectsSet.add(((TRCThreadWaitingForLockEvent)event).getLockedObject());
        }
    }
}

